REM Copyright (c) 2002 Startech Industries Inc.  pfm + ejo..
REM Program: Hyper Shuttle v2.2 Date: 02/23/02
DEFSNG A-Z
DECLARE FUNCTION rho# (ntheta#, a!, b!)
COMMON SHARED ndta AS INTEGER
COMMON SHARED sumtheta, deltheta AS INTEGER

CLS
REM SCREEN 8, 1 '--> 640x200
SCREEN 12, 0 '--> 640x480
COLOR 1 '--> Use 'Palette' to change colors!?

pi = ATN(1) * 4    ' define PI
dpts = 360          ' data points per pi control circle arclength
hypC = 1

instar = 24
pixratio = 48 / 64 '768 / 1024  ' 20/64      '   h-p, i.b.m. screen pixels
scrnset = 4 / 3
pix = 64 * .5' pixels per inch

clrC = 13: clrE = 5: clrRF = 1  ' color curve, ellipse, ref lines

'ycon = scrnset * pixratio

'DIM SHARED tvctr(dpts, 3)
'DIM SHARED uvctr(dpts, 3)
'DIM SHARED nvctr(dpts, 3)

DIM SHARED phi(6) AS DOUBLE
DIM SHARED phi4(6) AS DOUBLE
'DIM SHARED hypCln(dpts, 5)
'DIM SHARED Elrf1(dpts, 5)
'DIM SHARED Elrf2(dpts, 5)

deltheta = (dpts / 180) * 18 ' for surface fuselage lines at ** degree intervals

mono = 0:    plx = 1.2  ' : hypC = 1  ' hypC is coeff. C in z = C*cosh(Se)
' for stereo set mono = 0, else -1;   plx = parallax (eye separation) / 2
setx = 330:   sety = 240    ' v-basic screen set zero on 640 * 200 pixels

epi = pi / dpts    ' epsilon for eliminating discontinuity at pi/2, -pi/2
                    ' skips data point: note for error report
a1 = 1.7: b1 = 1.5     ' upper test ellipse:  b must be less than a
a2 = 1.6: b2 = 1.5      ' lower test ellipse:   also  [ b < a ]

 thestar = pi / 3'pi '7 * pi / 12 'pi / 2   ' stack, test data points
' phistar = pi / 12'pi / 2'-pi / 3            ' roll, yaw, pitch
 omstar = pi / 2  'pi / 3'pi / 2'pi / 6 '-pi / 3 ' pi / 6  '      [ trials ]

 xref = 0  '2              '  deltx       three axis reference translation
 yref = 0  '-2   '-2        '  delty     vector on [ x' y' z' ]
 zref = 0'  4   '2         '  deltz      [ trial data points ]

3

'FOR thestar = -pi TO pi STEP pi / 6

FOR phistar = pi / 6 TO 2 * pi STEP pi / 6

'FOR omstar = -pi TO pi STEP pi / 12
'phistar = phistar + pi / 6
'IF phistar > 2 * pi THEN phistar = 0
'omstar = omstar + pi / 12
'IF omstar > 2 * pi THEN phistar = 0

CLS
GOSUB screenset

COLOR 9
'LOCATE 2, 2
'PRINT "phi: "
LOCATE 4, 3
PRINT INT(10 * phistar * 180 / pi + .01) / 10;
'LOCATE 2, 9
'PRINT "theta: "
LOCATE 4, 10
PRINT INT(10 * thestar * 180 / pi + .01) / 10;
'LOCATE 2, 18
'PRINT "omega: "
LOCATE 4, 18
PRINT INT(10 * omstar * 180 / pi + .01) / 10;
'LOCATE 2, 48
'PRINT INT(10 * xref) / 10;        ' debug output data:
'LOCATE 2, 55
'PRINT INT(10 * yref) / 10;           ' reference translation vector
'LOCATE 2, 62
'PRINT INT(10 * zref) / 10;             ' [ xref, yref, zref ]
'LOCATE 2, 69
'PRINT "ref";

a = a1: b = b1         ' for integration 0 to pi/2 - epi  (top ellipse and
clr = 1          ' color for reference lines               '   mirror image)

'Rx = 0: Ry = 0: Rz = -1.3
'zflag = -1
'zcr = 6  '7.7
'GOSUB refline     ' central z-axis
'zflag = 0

Rx = a / 6: Ry = 0: Rz = 0
zflag = 0
xflag = -1
xcr = -a / 6
'clr = clrRF
GOSUB refline      ' x-axis marker, y = 0 , z = 0
xflag = 0

Rx = 0: Ry = b / 6: Rz = 0
xflag = 0
yflag = -1
ycr = -b / 6
GOSUB refline      ' y-axis marker, x = 0 , z = 0
yflag = 0

'Rx = a: Ry = 0: Rz = -1
'yflag = 0
'zflag = -1
'zcr = 1
'clr = 5
'GOSUB refline      ' top center reference line part 1

Rx = a: Ry = 0: Rz = 4.3
yflag = 0
zflag = -1
zcr = 6.3
GOSUB refline       ' top center reference line part 2

Rx = a: Ry = 0: Rz = -3
yflag = 0
zflag = -1
zcr = -4.3
GOSUB refline       ' top center reference line part 3


'LINE (setx + 10, sety)-(setx - 10, sety), 1    ' v-basic (xstar, ystar)
'LINE (setx, sety + 5)-(setx, sety - 5), 1    ' screen set zero target lines

zflag = 0

10              ' integrate ellipse zero to pi/2 - epi
ndta = 0
last2 = 0: last4 = 0
thestart = 0
cntrl = 1
se = 0
selocal = 0
selast = 0
sumtheta = 0

FOR theta = epi TO pi / 2 - epi STEP pi / dpts  'increment theta
    IF ndta = sumtheta THEN flagS = -1 ELSE flagS = 0  ' surface line flag
    ndta = ndta + 1
    GOSUB vectors
    Rx = x: Ry = y: Rz = z
    GOSUB curvplot
    IF flagS = -1 THEN GOSUB surfaceline
    Rx = x: Ry = y: Rz = -z
    GOSUB curvplot
    IF flagS = -1 THEN GOSUB surfaceline
    Rx = x: Ry = -y: Rz = z
    GOSUB curvplot
    IF flagS = -1 THEN GOSUB surfaceline
    Rx = x:   Ry = -y: Rz = -z
    GOSUB curvplot
    IF flagS = -1 THEN GOSUB surfaceline
   
    IF flagS = -1 THEN sumtheta = sumtheta + deltheta
NEXT

'Rx = 0: Ry = 0: Rz = -1.3
'zflag = -1
'zcr = 6  '7.7
'GOSUB refline     ' central z-axis
'zflag = 0

'IF mono = 0 THEN GOSUB priority

20                 ' integrate from pi/2 to pi - epi
a = a2: b = b2         ' bottom ellipse and mirror image
selocal = 0
se = 0                      ' error note:   last interval of top half
ndta = 0                     ' ellipse gets left out here;  will correct with
'last2 = 0: last4 = 0          ' exact expansion series for arcellipse
thestart = pi / 2              ' see weierstrass  1879
cntrl = 2
'sumtheta = deltheta
sumtheta = 0

FOR theta = epi + pi / 2 TO -epi + pi STEP pi / dpts
    IF ndta = sumtheta THEN flagS = -1 ELSE flagS = 0  ' surface line flag
    ndta = ndta + 1
    GOSUB vectors      ' generate hyperbolic cosine position vectors
    Rx = x: Ry = y: Rz = z
    GOSUB curvplot           ' plot hyperbolic cosine curve
    IF flagS = -1 THEN GOSUB surfaceline
    Rx = x: Ry = y: Rz = -z
    GOSUB curvplot             ' plot mirror image: y = -y
    IF flagS = -1 THEN GOSUB surfaceline
    Rx = x: Ry = -y: Rz = z
    GOSUB curvplot
    IF flagS = -1 THEN GOSUB surfaceline
    Rx = x:   Ry = -y: Rz = -z
    GOSUB curvplot
    IF flagS = -1 THEN GOSUB surfaceline
    
    IF flagS = -1 THEN sumtheta = sumtheta + deltheta  ' surface line increments

'Rx = 0: Ry = 0: Rz = -1.3
'zflag = -1
'zcr = 6  '7.7
'GOSUB refline     ' central z-axis
'zflag = 0

'NEXT
'NEXT
NEXT

'IF mono = 0 THEN GOSUB priority

zflag = -1
'xflag = 0
'yflag = 0

Rx = -a2: Ry = 0: Rz = -6
zcr = 6
clr = 5
GOSUB refline     ' bottom center reference line
zflag = 0

   DO UNTIL INKEY$ = " "
     : LOOP        ' finished; hold loop

NEXT
GOTO 3

END      ' END OF PROGRAM   starbase three industries      pfm

arcellipse:     ' integrates arclength of reference ellipse

'phi0 = thestart      ' set interval begin
phi2 = 0                ' reset transition variables
phi4 = 0             ' note : parabolic approximation
arcse = 0              ' also note : interval pi/2 - epi to pi/2 will be
                           ' left out due to discontinuity at pi/2
FOR n = 0 TO 6
   phi(n) = theta - epi + (pi / dpts) * n / 6
NEXT

FOR n = 1 TO 5
   phi2 = phi2 + 2 * rho(phi(n), a, b)
NEXT

FOR n = 1 TO 6
   phi4 = phi4 + 4 * rho(((phi(n) + phi(n - 1)) / 2), a, b)
NEXT

front = (phi(6) - phi(0)) / 36
start = phi(0) + phi(6)

arcse = front * (start + phi2 + phi4)
selocal = selocal + arcse

IF cntrl = 1 THEN     ' for bottom portion of hypC curve
   se = selocal          ' se in radians
   selast = se         ' ERROR REPORT:  arclength from pi/2-epi tp pi/2 will
'   LOCATE 2, 2            ' not be accumulated in "second half" integrals;
'   PRINT selast         '  therefore all second half position vectors are
ELSE                   ' plotted off by this amount, unoticeable but not okay;
   se = selocal + selast     ' have exact arclength solution almost ready -
END IF                   ' very difficult series - will check with weierstrass
RETURN                            ' 05 MAR 2002       pfm




rotate:     ' rotation matrix, or tensor, in vector form, very beautiful tri-symmetry


xdelx = -Rx * SIN(thestar)
xdely = Rx * COS(thestar) * COS(omstar)
xdelz = Rx * COS(thestar) * SIN(omstar)

ydelx = Ry * SIN(phistar) * COS(thestar)
ydely = -Ry * (COS(phistar) * SIN(omstar) - SIN(phistar) * SIN(thestar) * COS(omstar))
ydelz = Ry * (COS(phistar) * COS(omstar) + SIN(phistar) * SIN(thestar) * SIN(omstar))

'zdelx = Rz * (COS(phistar) * COS(thestar) - SIN(phistar) * SIN(omstar) * SIN(thestar))
zdelx = Rz * COS(phistar) * COS(thestar)
zdely = Rz * (COS(phistar) * SIN(thestar) * COS(omstar) + SIN(phistar) * SIN(omstar)) ' * COS(thestar))
zdelz = Rz * (COS(phistar) * SIN(thestar) * SIN(omstar) - SIN(phistar) * COS(omstar))


deltx = xdelx + ydelx + zdelx      ' accumulate vector components from
delty = xdely + ydely + zdely       ' [ x y z ] vector to [ x' y' z' ]
deltz = xdelz + ydelz + zdelz         ' ( 3-d vector spaces, 4-d in motion )

RETURN

image:                       ' calculate screen images, input is [ x' y' z' ]
zstrI = (pix * instar - zprmI) '    and output is:
Iphi = ATN(xprmI / zstrI)      '         ImC   mono x screen position (xstar)
'xstrI = 12 * 80 * TAN(Iphi)   '         ImY   y screen position (ystar)
Iomega = ATN(yprmI / zstrI)    '       zstrI   depth from screen
                               '         ImL   left screen xstar
' LOCATE 4, 2                  '         ImR   right screen xstar
' PRINT Iphi; Iomega;

ImC = instar * pix * TAN(Iphi)
ImR = instar * pix * (xprmI + plx * pix) / (instar * pix - zprmI) - plx * pix
ImL = instar * pix * (xprmI - plx * pix) / (instar * pix - zprmI) + plx * pix
ImY = -instar * pix * scrnset * pixratio * TAN(Iomega)

RETURN

vectors:   ' calculates hypC and ellipse vectors in [ x y z ]

bva = b ^ 2 / a ^ 2          ' b squared over a '
avb = 1 / bva                ' a squared over b squared
x11 = (1 - (1 - bva) * COS(theta) ^ 2)
x = SGN(COS(theta)) * a * SQR(1 - (SIN(theta) ^ 2) / x11)
y11 = (1 - (1 - avb) * SIN(theta) ^ 2)
y = SGN(SIN(theta)) * b * SQR(1 - (COS(theta) ^ 2) / y11)

rhosq = x ^ 2 + y ^ 2
'curvsq = 1 / rhosq

GOSUB arcellipse ' calculates se

' z is hyperbolic cosine of ellipse arclength at theta

'z = SQR(rhosq) * (EXP(se) + EXP(-se)) / 2

z = hypC * (EXP(se) + EXP(-se)) / 2        ' hyperbolic cosine se(theta)
'dzds = hypC * (EXP(se) - EXP(-se)) / 2     ' hyperbolic sine
'dzds = SQR(rhosq) * (EXP(se) - EXP(-se)) / 2
'dd2zds2 = hypC * z  ' [tensor development]  ' hyperbolic cosine

'LOCATE 15, 2
'PRINT "vector:"              ' output debug data [ x y z ]
'PRINT " "
'LOCATE 17, 2
'PRINT INT(100 * x) / 100;
'LOCATE 17, 9
'PRINT INT(100 * y) / 100;
'LOCATE 17, 16
'PRINT INT(100 * z) / 100
'PRINT " "
'PRINT "ellipse arc", se, " "    ' output reference ellipse arclength [ se ]
'PRINT " "

'sc2 = 2 * SIN(theta) * COS(theta)    ' also equals sine two theta

'dxdth = (1 / (2 * x)) * -avb * (((rhosq * sc2) - SIN(theta) ^ 2 * (-sc2) / a ^ 2 + sc2 / b ^ 2)) / rhosq ^ 2
'overload here

'IF ABS(y) < 1 * 10 ^ -30 THEN
'   dydth = 88888888   ' dummy output at discontinuity of dy/dth at theta=0
'ELSE
'   dydth = (1 / (2 * y)) * -bva * (((rhosq * (-sc2)) - COS(theta) ^ 2 * (-sc2) / a ^ 2 + sc2 / b ^ 2)) / rhosq ^ 2
'END IF

'dthds = 1 / SQR(x ^ 2 + y ^ 2 + z ^ 2)    ' R(hypC) magnitude, inverse

'tvctr(ndta, 1) = dxdth * dthds  ' this is de Se, arclength ellipse
'tvctr(ndta, 2) = dydth * dthds    ' ve ri de Sc, arclength hyperbolic cosine
'tvctr(ndta, 3) = dzds               ' mapped on ellipse Se ordinate
                                  ' in flat (transform zero) development
'LOCATE 4, 2
'PRINT "vector:"                 ' this is tangent vector data:
'LOCATE 4, 11                            '    not ready yet
'PRINT INT(100 * tvctr(ndta, 1)) / 100;
'LOCATE 4, 18                              ' please excuse latin above
'PRINT INT(100 * tvctr(ndta, 2)) / 100;
'LOCATE 4, 25
'PRINT INT(100 * tvctr(ndta, 3)) / 100;  ' get function for significant figures

'LOCATE 7, 2
'PRINT "theta Sc:", INT((10 * theta * 180 / pi) + .1) / 10
                                  ' control circle arclength [ Sc ] in degrees
'tvctr(ndta, 1) = dxdth * dthds
'tvctr(ndta, 2) = dydth * dthds
'tvctr(ndta, 3) = dzds      ' error: these are dR/d(Se) not dR/d(ShypC)

RETURN

curvplot:

'  receives Rx : Ry : Rz   and rotates to xprime, yprime, zprime
'                       then translates  xref, yref, zref   and finally
'                    transforms to xstarL, xstarR, and ystar
IF Rz >= 6 THEN Rz = 6
IF Rz <= -6 THEN Rz = -6
GOSUB rotate

xprime = pix * (xref + deltx)
yprime = pix * (yref + delty)
zprime = pix * (zref + deltz)

IF prmflag = -1 THEN GOTO 44          ' for prime data output
xprm = INT(100 * xprime / pix) / 100          '  [ x' y' z' ]
yprm = INT(100 * yprime / pix) / 100
zprm = INT(100 * zprime / pix) / 100      ' needs to skip mirror image
                                     ' data so output doesn't oscillate
'LOCATE 29, 2
'PRINT "position vector: ";
LOCATE 30, 21
PRINT xprm;
LOCATE 30, 28
PRINT yprm;
LOCATE 30, 35
PRINT zprm;
'PRINT " ";
prmflag = -1
'LOCATE 21, 2
'PRINT x; y; z;

GOTO 47
44
count1 = count1 + 1
IF count1 = 3 THEN
   prmflag = 0
   count1 = 0
END IF

47

zstar = (instar * pix - zprime)
IF zstar <= 0 THEN GOTO 51     ' zstar postitive for red-green mix.*

Iphi = ATN(xprime / zstar)
Iomega = ATN(yprime / zstar)

'LOCATE 17, 2
'PRINT Iphi

xstar = instar * pix * TAN(Iphi)   ' note for behind eye angles > pi/2
xstarR = instar * pix * (xprime + plx * pix) / (instar * pix - zprime) - plx * pix
xstarL = instar * pix * (xprime - plx * pix) / (instar * pix - zprime) + plx * pix
ystar = -instar * pix * scrnset * pixratio * TAN(Iomega)

'hypCln(ndta, 1) = xstar         ' storage data for future line interpreter
'hypCln(ndta, 2) = xstarL        ' stereo imaging priority lines, mode A
'hypCln(ndta, 3) = xstarR
'hypCln(ndta, 4) = ystar             ' code not ready yet
'hypCln(ndta, 5) = zstar

IF mono = -1 THEN GOTO 50


PSET (xstarL + setx, ystar + sety), 1 'clrC
PSET (xstarR + setx, ystar + sety), 4 'clrC

GOTO 53
50
PSET (xstar + setx, ystar + sety), clrC
GOTO 53
51
'LOCATE 2, 1
'PRINT "zstar < zero: continue"  ' test output signal for change
53                                       ' to bottom ellipse
'LOCATE 25, 2
'PRINT "screen: ", INT(100 * (xstar + setx) / pix) / 100, INT(100 * (ystar + sety) / pix) / 100;

'GOTO 63  ' skip ref ellipse for now

Rzhold = Rz
Rz = 0
                  
IF primflag2 = -1 THEN GOTO 54
'LOCATE 24, 2
'PRINT "ellipse:"
LOCATE 27, 2
PRINT INT(100 * Rx) / 100;
LOCATE 27, 9
PRINT INT(100 * Ry) / 100;
LOCATE 27, 16
PRINT INT(100 * Rz) / 100;
'LOCATE 24, 23
'PRINT "virtual";

primflag2 = -1
GOTO 55
54
count = count + 1
IF count = 3 THEN
  primflag2 = 0
  count = 0
END IF
55                   ' plot reference ellipse

GOSUB rotate
Exprime = pix * (xref + deltx)
Eyprime = pix * (yref + delty)
Ezprime = pix * (zref + deltz)

IF primflag3 = -1 THEN GOTO 56

'LOCATE 19, 2
'PRINT INT(100 * Exprime / pix) / 100
'LOCATE 19, 7
'PRINT INT(100 * Eyprime / pix) / 100
'LOCATE 19, 12
'PRINT INT(100 * Ezprime / pix) / 100
LOCATE 28, 3
PRINT INT(100 * deltx) / 100;
LOCATE 28, 10
PRINT INT(100 * delty) / 100;
LOCATE 28, 17
PRINT INT(100 * deltz) / 100;
'LOCATE 27, 24
'PRINT "prime";

primflag3 = -1
GOTO 57
56
count3 = count3 + 1
IF count3 = 3 THEN
  primflag3 = 0
  count3 = 0
END IF

57

Ezstar = (instar * pix - Ezprime)         ' redundant (first composition) imaging
Iphi = ATN(Exprime / Ezstar)       ' solution, refined in subroutine image
Iomega = ATN(Eyprime / Ezstar)      ' - modulating program in progress -

Exstar = instar * pix * TAN(Iphi)
ExstarR = instar * pix * (Exprime + plx * pix) / (instar * pix - Ezprime) - plx * pix
ExstarL = instar * pix * (Exprime - plx * pix) / (instar * pix - Ezprime) + plx * pix
Eystar = -instar * pix * scrnset * pixratio * TAN(Iomega)

'Elrf1(ndta, 1) = Exstar       ' storage data for developing line interpreter
'Elrf1(ndta, 2) = ExstarL      ' that will erase lines behind lines
'Elrf1(ndta, 3) = ExstarR      ' (priority line interpreter not ready)
'Elrf1(ndta, 4) = Eystar
'Elrf1(ndta, 5) = Ezstar

'GOTO 60
IF mono = -1 THEN GOTO 60
PSET (ExstarL + setx, Eystar + sety), 1 'clrE
PSET (ExstarR + setx, Eystar + sety), 4 'clrE
GOTO 63
60
PSET (Exstar + setx, Eystar + sety), clrE
63

'   Rz = -4                      ' second reference ellipse at z = **
'   GOSUB rotate                   ' due modular code, next re-write

'  xprmI = pix * (deltx + xref)
'  yprmI = pix * (delty + yref)
'  zprmI = pix * (deltz + zref)

'   GOSUB image
   
'  Ellref2(ndta, 1) = ImC        '  priority line data
'  Ellref2(ndta, 2) = ImL
'  Ellref2(ndta, 3) = ImR
'  Ellref2(ndta, 4) = ImY
'  Ellref2(ndta, 5) = zstarI

'   clrv = 5     'clrE

'   GOSUB pointset          ' new image data plotting subroutine
67
Rz = Rzhold

  IF INKEY$ = CHR$(27) THEN         ' eject  = escape
     DO UNTIL INKEY$ = " ": LOOP
  END IF

RETURN

refline:     ' reference lines, controllability awkward here

GOSUB rotate
  xprmI = pix * (deltx + xref)
  yprmI = pix * (delty + yref)
  zprmI = pix * (deltz + zref)

'LOCATE 2, 44
'PRINT xprmI / pix, yprmI / pix, zprmI / pix

GOSUB image
  tcntr1 = ImC
  tcntrL = ImL
  tcntrR = ImR
  tcntrY = ImY

'LOCATE 2, 44
'PRINT ImL / pix, ImY / pix;

IF zflag = -1 THEN Rz = zcr
IF xflag = -1 THEN Rx = xcr
IF yflag = -1 THEN Ry = ycr

GOSUB rotate

  xprmI = pix * (deltx + xref)
  yprmI = pix * (delty + yref)
  zprmI = pix * (deltz + zref)

'LOCATE 4, 3
'PRINT xprmI / pix, yprmI / pix, zprmI / pix ;
GOSUB image

  tcntr2 = ImC
  tcntrL2 = ImL
  tcntrR2 = ImR
  tcntrY2 = ImY

IF mono = -1 THEN GOTO 70

LINE (tcntrL + setx, tcntrY + sety)-(tcntrL2 + setx, tcntrY2 + sety), 1 'clr
LINE (tcntrR + setx, tcntrY + sety)-(tcntrR2 + setx, tcntrY2 + sety), 4 'clr
GOTO 73
70
LINE (tcntr1 + setx, tcntrY + sety)-(tcntr2 + setx, tcntrY2 + sety), clr
73
'LOCATE 2, 46
'PRINT INT(ImL * 10) / 10;
'LOCATE 2, 53
'PRINT INT(ImR * 10) / 10;
'LOCATE 2, 60
'PRINT ":"
'LOCATE 2, 62
'PRINT INT(ImY * 10) / 10

RETURN

pointset:

IF mono = -1 THEN GOTO 80
PSET (ImL + setx, ImY + sety), 1  'clRV
PSET (ImR + setx, ImY + sety), 4  'clRV
GOTO 83
80
PSET (ImC + setx, ImY + sety), clrv
83
RETURN

'surfaceline:   ' interesting line plotter, rewritten below, keep.**

'ydel = hypCline(ndta, 4) - Ellref1(ndta, 4)
'xdelC = hypCline(ndta, 1) - Ellref1(ndta, 1)
'xdelL = hypCline(ndta, 2) - Ellref1(ndta, 2)
'xdelR = hypCline(ndta, 3) - Ellref1(ndta, 3)
'slopeC = ydel / xdelC
'slopeL = ydel / xdelL
'slopeR = ydel / xdelR

'y1 = Ellref1(ndta, 4)
'x1C = Ellref1(ndta, 1)
'x1L = Ellref1(ndta, 2)
'x1R = Ellref1(ndta, 3)
'x2C = hypCline(ndta, 1)
'x2L = hypCline(ndta, 2)
'x2R = hypCline(ndta, 3)
''IF stopflag = -1 THEN GOTO 105
'IF z >= 6 THEN
'   x2L = Ellref2(ndta, 2)
'   x2R = Ellref2(ndta, 3)
'   x2C = Ellref2(ndta, 1)
''   stopflag = -1
''   GOTO 103
'END IF

''lastx2L = x2L
''lastx2R = x2R
''lastx2C = x2C
''103
'IF mono = -1 THEN GOTO 90
'
'FOR xnL = x1L TO x2L STEP 1
'  ynL = slopeL * (xnL - x1L) + y1
'  PSET (xnL + setx, -ynL + sety), 5
'NEXT
'FOR xnR = x1R TO x2R STEP 1
'  ynR = slopeR * (xnR - x1R) + y1
'  PSET (xnR + setx, -ynR + sety), 5
'NEXT
'GOTO 93
'90
'FOR xnC = x1C TO x2C STEP 1
'   ynC = slopeC * (xnC - x1C) + y1
'   PSET (xnC + setx, -ynC + sety), 5
'NEXT
'93
'RETURN

surfaceline:    '  for fuselage surface lines in z direction

zflag = -1
xflag = 0
yflag = 0
Rz = 0
'zcr = z
zcr = Rzhold     '   Rzhold datum from curvplot
IF zcr >= 6 THEN zcr = 6
IF zcr <= -6 THEN zcr = -6
clr = 5
GOSUB refline

RETURN

priority:

'hypCline(ndta, 1) = xstar

'hypCln(ndta, 2) = xstarL
'hypCln(ndta, 3) = xstarR
'hypCln(ndta, 4) = ystar
'hypCln(ndta, 5) = zstar

'Ellref1(ndta, 1) = Exstar

'Elrf1(ndta, 2) = ExstarL
'Elrf1(ndta, 3) = ExstarR
'Elrf1(ndta, 4) = Eystar
'Elrf1(ndta, 5) = Ezstar

FOR ndta = 0 TO dpts
   xvalL1 = hypCln(ndta, 2)
   xvalR1 = hypCln(ndta, 3)
   yval1 = hypCln(ndta, 4)
   FOR ndt = 0 TO dpts
      xvalL2 = Elrf1(ndt, 2)
      xvalR2 = Elrf1(ndt, 3)
      yval2 = Elrf1(ndt, 4)
      IF yval2 - 2 <= yval1 <= yval2 + 2 THEN
         IF xvalL2 - 2 <= xvalL1 <= xvalL2 + 2 THEN GOSUB prepareL
         IF xvalR2 - 2 <= xvalR1 <= xvalR2 + 2 THEN GOSUB prepareR
      END IF
   NEXT
NEXT

RETURN

prepareL:
zval1 = hypCln(ndta, 5)
zval2 = Elrf1(ndt, 5)
IF zval2 < zval1 THEN GOSUB erasepointsEL
IF zval1 < zval2 THEN GOSUB erasepointsCL
RETURN
prepareR:
zval1 = hypCln(ndta, 5)
zval2 = Elrf1(ndt, 5)
IF zval2 < zval1 THEN GOSUB erasepointsER
IF zval1 < zval2 THEN GOSUB erasepointsCR
RETURN
erasepointsEL:
PSET (xvalL2, yval2), 0
RETURN
erasepointsER:
PSET (xvalR2, yval2), 0
RETURN
erasepointsCL:
PSET (xvalL1, yval1), 0
RETURN
erasepointsCR:
PSET (xvalR1, yval1), 0
RETURN

screenset:
COLOR 9
LOCATE 2, 60
PRINT "stereo CAD"
LOCATE 30, 59
PRINT "pfm enterprise"
COLOR 1
LOCATE 2, 2
PRINT "phi : "
LOCATE 2, 9
PRINT "theta : "
LOCATE 2, 18
PRINT "omega : "
LOCATE 30, 2
PRINT "position vector: ";
LOCATE 25, 2
PRINT "ellipse:"
LOCATE 27, 23
PRINT "virtual";
LOCATE 28, 24
PRINT "prime";

RETURN

FUNCTION rho# (ntheta#, a!, b!)

rho# = 1 / SQR((COS(ntheta#) / a!) ^ 2 + (SIN(ntheta#) / b!) ^ 2)

'PRINT "c=", c, "d=", d
END FUNCTION

