/*  devread.c   -- Read logical sectors */
/*  Copyright 1988,1991 Steven W. Harrold. All rights reserved. */
/*  $Header: DEVREAD.C_V 1.4 91/03/20 08:48:57 SWH Exp $ */

#include    "mfs.h"
#include    "dev.h"

extern int Dstatus ;


/*================================================================*/
int devread (ddata, nsects, sectno, buffer)
struct devdata  *ddata ;
int             nsects ;
int             sectno ;
void            *buffer ;
{
    int         drive, head, track, sector ;
    char        *buff = buffer ;


/*  Perform a cursory check that the disk device has been initialized.
*/
    if (!ddata->d_heads)
    {
        Dstatus = -1 ;
        return Dstatus ;
    }

/*  Perform the operation one sector at a time.  This eliminates the need
**  for special handling of requests that span a track/head boundary.
*/
    drive = ddata->d_drive ;
    for (; nsects > 0; nsects--, sectno++)
    {
        track = sectno / (ddata->d_heads * ddata->d_sectors) ;
        if (track >= ddata->d_tracks)
            return -1 ;

        sector = (sectno % ddata->d_sectors) + 1;
        head = (sectno % (ddata->d_heads * ddata->d_sectors)) /
               ddata->d_sectors ;

        buffer = &buff[BLOCK_SIZE-(nsects*SECTOR_SIZE)];

        Dstatus = NEW_MEDIA ;
        while (Dstatus == NEW_MEDIA)
            Dstatus = BIOSDISK(_DISK_READ) ;
        if (Dstatus)
            return Dstatus ;

    } /* for nsects */

    return 0;

} /* devread() */


/*---eof---*/
