
; ****************************************************************
; **								**
; ** zdinstab.inc						**
; **								**
; **	 This file provides mnemonic strings for Z80		**
; **		    instructions for the			**
; **								**
; **		      MK Associates Z80 Dissasembler		**
; **								**
; ****************************************************************

mnem_strings	equ	this byte
	db	'NOP',TAB,RS		; 00
	db	'LD',TAB,'BC,0    H',RS	; 01 XX XX
	db	'LD',TAB,'(BC),A',RS	; 02
	db	'INC',TAB,'BC',RS	; 03
	db	'INC',TAB,'B',RS 	; 04
	db	'DEC',TAB,'B',RS 	; 05
	db	'LD',TAB,'B,0  H',RS	; 06 XX
	db	'RLCA',TAB,RS		; 07
	db	'EX',TAB,'AF,AF',APOST,RS ; 08
	db	'ADD',TAB,'HL,BC',RS	; 09
	db	'LD',TAB,'A,(BC)',RS	; 0A
	db	'DEC',TAB,'BC',RS	; 0B
	db	'INC',TAB,'C',RS 	; 0C
	db	'DEC',TAB,'C',RS 	; 0D
	db	'LD',TAB,'C,0  H',RS	; 0E XX
	db	'RRCA',TAB,RS		; 0F
	db	'DJNZ',TAB,'0    H',RS	; 10 XX
	db	'LD',TAB,'DE,0    H',RS	; 11 XX XX
	db	'LD',TAB,'(DE),A',RS	; 12
	db	'INC',TAB,'DE',RS	; 13
	db	'INC',TAB,'D',RS 	; 14
	db	'DEC',TAB,'D',RS 	; 15
	db	'LD',TAB,'D,0  H',RS	; 16 XX
	db	'RLA',TAB,RS		; 17
	db	'JR',TAB,'0    H',RS	; 18 XX
	db	'ADD',TAB,'HL,DE',RS	; 19
	db	'LD',TAB,'A,(DE)',RS	; 1A
	db	'DEC',TAB,'DE',RS	; 1B
	db	'INC',TAB,'E',RS 	; 1C
	db	'DEC',TAB,'E',RS 	; 1D
	db	'LD',TAB,'E,0  H',RS	; 1E XX
	db	'RRA',TAB,RS		; 1F
	db	'JR',TAB,'NZ,0    H',RS	; 20 XX
	db	'LD',TAB,'HL,0    H',RS	; 21 XX XX
	db	'LD',TAB,'(0    H),HL',RS ; 22 XX XX
	db	'INC',TAB,'HL',RS	; 23
	db	'INC',TAB,'H',RS 	; 24
	db	'DEC',TAB,'H',RS 	; 25
	db	'LD',TAB,'H,0  H',RS	; 26 XX
	db	'DAA',TAB,RS		; 27
	db	'JR',TAB,'Z,0    H',RS	; 28 XX
	db	'ADD',TAB,'HL,HL',RS	; 29
	db	'LD',TAB,'HL,(0    H)',RS ; 2A XX XX
	db	'DEC',TAB,'HL',RS	; 2B
	db	'INC',TAB,'L',RS 	; 2C
	db	'DEC',TAB,'L',RS 	; 2D
	db	'LD',TAB,'L,0  H',RS	; 2E XX
	db	'CPL',TAB,RS		; 2F
	db	'JR',TAB,'NC,0    H',RS	; 30 XX
	db	'LD',TAB,'SP,0    H',RS	; 31 XX XX
	db	'LD',TAB,'(0    H),A',RS ; 32 XX XX
	db	'INC',TAB,'SP',RS	; 33
	db	'INC',TAB,'(HL)',RS	; 34
	db	'DEC',TAB,'(HL)',RS	; 35
	db	'LD',TAB,'(HL),0  H',RS ; 36 XX
	db	'SCF',TAB,RS		; 37
	db	'JR',TAB,'C,0    H',RS	; 38 XX
	db	'ADD',TAB,'HL,SP',RS	; 39
	db	'LD',TAB,'A,(0    H)',RS ; 3A XX XX
	db	'DEC',TAB,'SP',RS	; 3B
	db	'INC',TAB,'A',RS 	; 3C
	db	'DEC',TAB,'A',RS 	; 3D
	db	'LD',TAB,'A,0  H',RS	; 3E XX
	db	'CCF',TAB,RS		; 3F
	db	'LD',TAB,'B,B',RS	; 40
	db	'LD',TAB,'B,C',RS	; 41
	db	'LD',TAB,'B,D',RS	; 42
	db	'LD',TAB,'B,E',RS	; 43
	db	'LD',TAB,'B,H',RS	; 44
	db	'LD',TAB,'B,L',RS	; 45
	db	'LD',TAB,'B,(HL)',RS	; 46
	db	'LD',TAB,'B,A',RS	; 47
	db	'LD',TAB,'C,B',RS	; 48
	db	'LD',TAB,'C,C',RS	; 49
	db	'LD',TAB,'C,D',RS	; 4A
	db	'LD',TAB,'C,E',RS	; 4B
	db	'LD',TAB,'C,H',RS	; 4C
	db	'LD',TAB,'C,L',RS	; 4D
	db	'LD',TAB,'C,(HL)',RS	; 4E
	db	'LD',TAB,'C,A',RS	; 4F
	db	'LD',TAB,'D,B',RS	; 50
	db	'LD',TAB,'D,C',RS	; 51
	db	'LD',TAB,'D,D',RS	; 52
	db	'LD',TAB,'D,E',RS	; 53
	db	'LD',TAB,'D,H',RS	; 54
	db	'LD',TAB,'D,L',RS	; 55
	db	'LD',TAB,'D,(HL)',RS	; 56
	db	'LD',TAB,'D,A',RS	; 57
	db	'LD',TAB,'E,B',RS	; 58
	db	'LD',TAB,'E,C',RS	; 59
	db	'LD',TAB,'E,D',RS	; 5A
	db	'LD',TAB,'E,E',RS	; 5B
	db	'LD',TAB,'E,H',RS	; 5C
	db	'LD',TAB,'E,L',RS	; 5D
	db	'LD',TAB,'E,(HL)',RS	; 5E
	db	'LD',TAB,'E,A',RS	; 5F
	db	'LD',TAB,'H,B',RS	; 60
	db	'LD',TAB,'H,C',RS	; 61
	db	'LD',TAB,'H,D',RS	; 62
	db	'LD',TAB,'H,E',RS	; 63
	db	'LD',TAB,'H,H',RS	; 64
	db	'LD',TAB,'H,L',RS	; 65
	db	'LD',TAB,'H,(HL)',RS	; 66
	db	'LD',TAB,'H,A',RS	; 67
	db	'LD',TAB,'L,B',RS	; 68
	db	'LD',TAB,'L,C',RS	; 69
	db	'LD',TAB,'L,D',RS	; 6A
	db	'LD',TAB,'L,E',RS	; 6B
	db	'LD',TAB,'L,H',RS	; 6C
	db	'LD',TAB,'L,L',RS	; 6D
	db	'LD',TAB,'L,(HL)',RS	; 6E
	db	'LD',TAB,'L,A',RS	; 6F
	db	'LD',TAB,'(HL),B',RS	; 70
	db	'LD',TAB,'(HL),C',RS	; 71
	db	'LD',TAB,'(HL),D',RS	; 72
	db	'LD',TAB,'(HL),E',RS	; 73
	db	'LD',TAB,'(HL),H',RS	; 74
	db	'LD',TAB,'(HL),L',RS	; 75
	db	'HALT',TAB,RS		; 76
	db	'LD',TAB,'(HL),A',RS	; 77
	db	'LD',TAB,'A,B',RS	; 78
	db	'LD',TAB,'A,C',RS	; 79
	db	'LD',TAB,'A,D',RS	; 7A
	db	'LD',TAB,'A,E',RS	; 7B
	db	'LD',TAB,'A,H',RS	; 7C
	db	'LD',TAB,'A,L',RS	; 7D
	db	'LD',TAB,'A,(HL)',RS	; 7E
	db	'LD',TAB,'A,A',RS	; 7F
	db	'ADD',TAB,'A,B',RS	; 80
	db	'ADD',TAB,'A,C',RS	; 81
	db	'ADD',TAB,'A,D',RS	; 82
	db	'ADD',TAB,'A,E',RS	; 83
	db	'ADD',TAB,'A,H',RS	; 84
	db	'ADD',TAB,'A,L',RS	; 85
	db	'ADD',TAB,'A,(HL)',RS	; 86
	db	'ADD',TAB,'A,A',RS	; 87
	db	'ADC',TAB,'A,B',RS	; 88
	db	'ADC',TAB,'A,C',RS	; 89
	db	'ADC',TAB,'A,D',RS	; 8A
	db	'ADC',TAB,'A,E',RS	; 8B
	db	'ADC',TAB,'A,H',RS	; 8C
	db	'ADC',TAB,'A,L',RS	; 8D
	db	'ADC',TAB,'A,(HL)',RS	; 8E
	db	'ADC',TAB,'A,A',RS	; 8F
	db	'SUB',TAB,'B',RS 	; 90
	db	'SUB',TAB,'C',RS 	; 91
	db	'SUB',TAB,'D',RS 	; 92
	db	'SUB',TAB,'E',RS 	; 93
	db	'SUB',TAB,'H',RS 	; 94
	db	'SUB',TAB,'L',RS 	; 95
	db	'SUB',TAB,'(HL)',RS	; 96
	db	'SUB',TAB,'A',RS 	; 97
	db	'SBC',TAB,'B',RS 	; 98
	db	'SBC',TAB,'C',RS 	; 99
	db	'SBC',TAB,'D',RS 	; 9A
	db	'SBC',TAB,'E',RS 	; 9B
	db	'SBC',TAB,'H',RS 	; 9C
	db	'SBC',TAB,'L',RS 	; 9D
	db	'SBC',TAB,'(HL)',RS	; 9E
	db	'SBC',TAB,'A',RS 	; 9F
	db	'AND',TAB,'B',RS 	; A0
	db	'AND',TAB,'C',RS 	; A1
	db	'AND',TAB,'D',RS 	; A2
	db	'AND',TAB,'E',RS 	; A3
	db	'AND',TAB,'H',RS 	; A4
	db	'AND',TAB,'L',RS 	; A5
	db	'AND',TAB,'(HL)',RS	; A6
	db	'AND',TAB,'A',RS 	; A7
	db	'XOR',TAB,'B',RS 	; A8
	db	'XOR',TAB,'C',RS 	; A9
	db	'XOR',TAB,'D',RS 	; AA
	db	'XOR',TAB,'E',RS 	; AB
	db	'XOR',TAB,'H',RS 	; AC
	db	'XOR',TAB,'L',RS 	; AD
	db	'XOR',TAB,'(HL)',RS	; AE
	db	'XOR',TAB,'A',RS 	; AF
	db	'OR',TAB,'B',RS		; B0
	db	'OR',TAB,'C',RS		; B1
	db	'OR',TAB,'D',RS		; B2
	db	'OR',TAB,'E',RS		; B3
	db	'OR',TAB,'H',RS		; B4
	db	'OR',TAB,'L',RS		; B5
	db	'OR',TAB,'(HL)',RS	; B6
	db	'OR',TAB,'A',RS		; B7
	db	'CP',TAB,'B',RS		; B8
	db	'CP',TAB,'C',RS		; B9
	db	'CP',TAB,'D',RS		; BA
	db	'CP',TAB,'E',RS		; BB
	db	'CP',TAB,'H',RS		; BC
	db	'CP',TAB,'L',RS		; BD
	db	'CP',TAB,'(HL)',RS	; BE
	db	'CP',TAB,'A',RS		; BF
	db	'RET',TAB,'NZ',RS	; C0
	db	'POP',TAB,'BC',RS	; C1
	db	'JP',TAB,'NZ,0    H',RS ; C2 XX XX
	db	'JP',TAB,'0    H',RS	; C3 XX XX
	db	'CALL',TAB,'NZ,0    H',RS ; C4 XX XX
	db	'PUSH',TAB,'BC',RS	; C5
	db	'ADD',TAB,'A,0  H',RS	; C6 XX
	db	'RST',TAB,'000H',RS	; C7
	db	'RET',TAB,'Z',RS 	; C8
	db	'RET',TAB,RS		; C9
	db	'JP',TAB,'Z,0    H',RS	; CA XX XX
	db	RS			; CB -	ROT_BIT
	db	'CALL',TAB,'Z,0    H',RS ; CC XX XX
	db	'CALL',TAB,'0    H',RS	; CD XX XX
	db	'ADC',TAB,'A,0  H',RS	; CE XX
	db	'RST',TAB,'08H',RS	; CF
	db	'RET',TAB,'NC',RS	; D0
	db	'POP',TAB,'DE',RS	; D1
	db	'JP',TAB,'NC,0    H',RS ; D2 XX XX
	db	'OUT',TAB,'(0  H),A',RS ; D3 XX
	db	'CALL',TAB,'NC,0    H',RS ; D4 XX XX
	db	'PUSH',TAB,'DE',RS	; D5
	db	'SUB',TAB,'0  H',RS	; D6 XX
	db	'RST',TAB,'10H',RS	; D7
	db	'RET',TAB,'C',RS 	; D8
	db	'EXX',TAB,RS		; D9
	db	'JP',TAB,'C,0    H',RS	; DA XX XX
	db	'IN',TAB,'A,(0  H)',RS	; DB XX
	db	'CALL',TAB,'C,0    H',RS ; DC XX XX
	db	RS			; DD - INDEX1
	db	'SBC',TAB,'A,0  H',RS	; DE XX
	db	'RST',TAB,'18H',RS	; DF
	db	'RET',TAB,'PO',RS	; E0
	db	'POP',TAB,'HL',RS	; E1
	db	'JP',TAB,'PO,0    H',RS	; E2 XX XX
	db	'EX',TAB,'(SP),HL',RS	; E3
	db	'CALL',TAB,'PO,0    H',RS ; E4 XX XX
	db	'PUSH',TAB,'HL',RS	; E5
	db	'AND',TAB,'0  H',RS	; E6 XX
	db	'RST',TAB,'20H',RS	; E7
	db	'RET',TAB,'PE',RS	; E8
	db	'JP',TAB,'(HL)',RS	; E9
	db	'JP',TAB,'PE,0    H',RS	; EA XX XX
	db	'EX',TAB,'DE,HL',RS	; EB
	db	'CALL',TAB,'PE,0    H',RS ; EC XX XX
	db	RS			; ED - ZSPEC
	db	'XOR',TAB,'0  H',RS	; EE XX
	db	'RST',TAB,'28H',RS	; EF
	db	'RET',TAB,'P',RS 	; F0
	db	'POP',TAB,'AF',RS	; F1
	db	'JP',TAB,'P,0    H',RS	; F2 XX XX
	db	'DI',TAB,RS		; F3
	db	'CALL',TAB,'P,0    H',RS ; F4 XX XX
	db	'PUSH',TAB,'AF',RS	; F5
	db	'OR',TAB,'0  H',RS	; F6 XX
	db	'RST',TAB,'30H',RS	; F7
	db	'RET',TAB,'M',RS 	; F8
	db	'LD',TAB,'SP,HL',RS	; F9
	db	'JP',TAB,'M,0    H',RS	; FA XX XX
	db	'EI',TAB,RS		; FB
	db	'CALL',TAB,'M,0    H',RS ; FC XX XX
	db	RS			; FD - INDEX2
	db	'CP',TAB,'0  H',RS	; FE XX
	db	'RST',TAB,'38H',RS	; FF


bytes		equ	this byte
	db	1	; 00
	db	3	; 01 XX XX
	db	1	; 02
	db	1	; 03
	db	1	; 04
	db	1	; 05
	db	2	; 06 XX
	db	1	; 07
	db	1	; 08
	db	1	; 09
	db	1	; 0A
	db	1	; 0B
	db	1	; 0C
	db	1	; 0D
	db	2	; 0E XX
	db	1	; 0F
	db	2	; 10 XX
	db	3	; 11 XX XX
	db	1	; 12
	db	1	; 13
	db	1	; 14
	db	1	; 15
	db	2	; 16 XX
	db	1	; 17
	db	2	; 18 XX
	db	1	; 19
	db	1	; 1A
	db	1	; 1B
	db	1	; 1C
	db	1	; 1D
	db	2	; 1E XX
	db	1	; 1F
	db	2	; 20 XX
	db	3	; 21 XX XX
	db	3	; 22 XX XX
	db	1	; 23
	db	1	; 24
	db	1	; 25
	db	2	; 26 XX
	db	1	; 27
	db	2	; 28 XX
	db	1	; 29
	db	3	; 2A XX XX
	db	1	; 2B
	db	1	; 2C
	db	1	; 2D
	db	2	; 2E XX
	db	1	; 2F
	db	2	; 30 XX
	db	3	; 31 XX XX
	db	3	; 32 XX XX
	db	1	; 33
	db	1	; 34
	db	1	; 35
	db	2	; 36 XX
	db	1	; 37
	db	2	; 38 XX
	db	1	; 39
	db	3	; 3A XX XX
	db	1	; 3B
	db	1	; 3C
	db	1	; 3D
	db	2	; 3E XX
	db	1	; 3F
	db	1	; 40
	db	1	; 41
	db	1	; 42
	db	1	; 43
	db	1	; 44
	db	1	; 45
	db	1	; 46
	db	1	; 47
	db	1	; 48
	db	1	; 49
	db	1	; 4A
	db	1	; 4B
	db	1	; 4C
	db	1	; 4D
	db	1	; 4E
	db	1	; 4F
	db	1	; 50
	db	1	; 51
	db	1	; 52
	db	1	; 53
	db	1	; 54
	db	1	; 55
	db	1	; 56
	db	1	; 57
	db	1	; 58
	db	1	; 59
	db	1	; 5A
	db	1	; 5B
	db	1	; 5C
	db	1	; 5D
	db	1	; 5E
	db	1	; 5F
	db	1	; 60
	db	1	; 61
	db	1	; 62
	db	1	; 63
	db	1	; 64
	db	1	; 65
	db	1	; 66
	db	1	; 67
	db	1	; 68
	db	1	; 69
	db	1	; 6A
	db	1	; 6B
	db	1	; 6C
	db	1	; 6D
	db	1	; 6E
	db	1	; 6F
	db	1	; 70
	db	1	; 71
	db	1	; 72
	db	1	; 73
	db	1	; 74
	db	1	; 75
	db	1	; 76
	db	1	; 77
	db	1	; 78
	db	1	; 79
	db	1	; 7A
	db	1	; 7B
	db	1	; 7C
	db	1	; 7D
	db	1	; 7E
	db	1	; 7F
	db	1	; 80
	db	1	; 81
	db	1	; 82
	db	1	; 83
	db	1	; 84
	db	1	; 85
	db	1	; 86
	db	1	; 87
	db	1	; 88
	db	1	; 89
	db	1	; 8A
	db	1	; 8B
	db	1	; 8C
	db	1	; 8D
	db	1	; 8E
	db	1	; 8F
	db	1	; 90
	db	1	; 91
	db	1	; 92
	db	1	; 93
	db	1	; 94
	db	1	; 95
	db	1	; 96
	db	1	; 97
	db	1	; 98
	db	1	; 99
	db	1	; 9A
	db	1	; 9B
	db	1	; 9C
	db	1	; 9D
	db	1	; 9E
	db	1	; 9F
	db	1	; A0
	db	1	; A1
	db	1	; A2
	db	1	; A3
	db	1	; A4
	db	1	; A5
	db	1	; A6
	db	1	; A7
	db	1	; A8
	db	1	; A9
	db	1	; AA
	db	1	; AB
	db	1	; AC
	db	1	; AD
	db	1	; AE
	db	1	; AF
	db	1	; B0
	db	1	; B1
	db	1	; B2
	db	1	; B3
	db	1	; B4
	db	1	; B5
	db	1	; B6
	db	1	; B7
	db	1	; B8
	db	1	; B9
	db	1	; BA
	db	1	; BB
	db	1	; BC
	db	1	; BD
	db	1	; BE
	db	1	; BF
	db	1	; C0
	db	1	; C1
	db	3	; C2 XX XX
	db	3	; C3 XX XX
	db	3	; C4 XX XX
	db	1	; C5
	db	2	; C6 XX
	db	1	; C7
	db	1	; C8
	db	1	; C9
	db	3	; CA XX XX
	db	5	; CB
	db	3	; CC XX XX
	db	3	; CD XX XX
	db	2	; CE XX
	db	1	; CF
	db	1	; D0
	db	1	; D1
	db	3	; D2 XX XX
	db	2	; D3 XX
	db	3	; D4 XX XX
	db	1	; D5
	db	2	; D6 XX
	db	1	; D7
	db	1	; D8
	db	1	; D9
	db	3	; DA XX XX
	db	2	; DB XX
	db	3	; DC XX
	db	6	; DD
	db	2	; DE XX
	db	1	; DF
	db	1	; E0
	db	1	; E1
	db	3	; E2 XX XX
	db	1	; E3
	db	3	; E4 XX XX
	db	1	; E5
	db	2	; E6 XX
	db	1	; E7
	db	1	; E8
	db	1	; E9
	db	3	; EA XX XX
	db	1	; EB
	db	3	; EC XX XX
	db	7	; ED
	db	2	; EE XX
	db	1	; EF
	db	1	; F0
	db	1	; F1
	db	3	; F2 XX XX
	db	1	; F3
	db	3	; F4 XX XX
	db	1	; F5
	db	2	; F6 XX
	db	1	; F7
	db	1	; F8
	db	1	; F9
	db	3	; FA XX XX
	db	1	; FB
	db	3	; FC XX XX
	db	8	; FD
	db	2	; FE XX
	db	1	; FF
