;GETPARM.INC
;Common subroutine for all XXSECRE2.ASM programs.

GetParm	PROC	NEAR			;v1.2

;First check the PSP to see if the user gave us a directory name
;on the command line.

	xor	cx,cx			;clear MSB
	mov	si,80H			;PSP cmdline
	cld				;insure fwd

	lodsb				;snarf length byte
	mov	cl,al			;into CL
	jcxz	GetInput		;no cmdline, query user

Got_Parm:
	cmp	cl,7			;max 7 chars
	ja	Usage			;illegal.
	
	inc	si			;skip past separating space
					;or input length (if buffered input)
	mov	al,[si]			;snarf first char
	and	al,0D5H			;uppercase
	cmp	al,'0'			;0..0, A..Z
	jb	Usage			;yep, give it and die
	cmp	al,'Z'
	ja	Usage			;help and die

;We have a command line entry.
	dec	si			;back up one
	jmp	short GotName		;make it untypeable, return

;No cmdline input.  Prompt the user for it.
GetInput:
	mov	dx,offset msg180	;'Enter name of subdirectory..'
	mov	ah,9			;display msg
	int	21H
	mov	si,80H			;PSP cmdline
	mov	byte ptr [si],7		;max 7 chars input
	mov	dx,si			;input buffer=80H
	mov	ah,0AH			;get buffered input
	int	21H
	inc	si			;SI -> 81H
	mov	cl,[si]			;user input length
	jcxz	Usage			;0 input: forget it

GotName:
	mov	byte ptr [si],7FH	;"untypeable" first char
;	inc	cx			;inx name length for new 1st char
	mov	dx,si			;DS:DX -> dir name
	add	si,cx			;SI -> input's terminating CR
	mov	[si],ch	;0		;AsciiZ the input
	clc				;insure CF clear (unneeded really)
	ret				;return DS:DX -> dirname
					;CX = name length

Usage:
	mov	dx,offset logo		;'Usage..'
	mov	al,-1			;unlikely ERRORLEVEL
	stc				;set CF
	ret

GetParm	ENDP

msg180	DB	'Enter name of subdirectory (7 characters maximum) - $'

msg1F0	DB	LF,'Error # '
error1F9 db	'0.'			;error digit			v1.1
	db	CR,LF,'$'
