;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File VIDRAM.ASM			<Description>			*
;*									*
;************************************************************************
;LastEdit: 12/30/92

	INCLUDE	API.INC
	Header@

;========================================================================

DSeg@
initialized db 0
DSegEnd@

;========================================================================

BSeg@
VIDRAM_entry dd ?
BSegEnd@

;========================================================================

CSeg@

ExtProc@ QOSINIT,__PASCAL__

;------------------------------------------------------------------------

PubProc@ VIDRAM_ENTRYPOINT,__PASCAL__
	SET_DS
	mov	al,1
	xchg	al,initialized
	or	al,al
	jnz	vidram_entry_done2
	call	QOSinit@
	jz	vidram_entry_done2	; if no QOS progs, no VIDRAM entry pt
	mov	ah,al			; set multiplex number
	mov	al,1
	mov	bx,5649h   ; VI
	mov	cx,4452h   ; DR
	mov	dx,414Dh   ; AM
	push	es
	push	di
	int	2Fh
	xor	ax,ax			; assume not installed
	xor	dx,dx
	cmp	bx,4F4Bh   ; OK
	jne	vidram_entry_done
	mov	ax,di
	mov	dx,es
vidram_entry_done:
	pop	di
	pop	es
	mov	word ptr DGROUP:VIDRAM_entry,ax
	mov	word ptr DGROUP:VIDRAM_entry+2,dx
vidram_entry_return:
	mov	bx,ax
	or	bx,dx
	RESTORE_DS
	ret

vidram_entry_done2:
	ASSUME	DS:DGROUP
	mov	ax,word ptr DGROUP:VIDRAM_entry
	mov	dx,word ptr DGROUP:VIDRAM_entry+2
	jmp	vidram_entry_return
EndProc@ VIDRAM_ENTRYPOINT,__PASCAL__

;------------------------------------------------------------------------

PubProc@ VIDRAM_INSTALLED,__PASCAL__
	call	VIDRAM_ENTRYPOINT@
	jz	vidram_inst_done	; AX = 0 if not installed
	mov	ax,1
vidram_inst_done:
	ret
EndProc@ VIDRAM_INSTALLED,__PASCAL__

;------------------------------------------------------------------------

PubProc@ VIDRAM_STATUS,__PASCAL__
@features = DPTR_ [bp+Overhead+4*dPtrSize]
@flags = DPTR_ [bp+Overhead+3*dPtrSize]
@monitor = DPTR_ [bp+Overhead+2*dPtrSize]
@memtop = DPTR_ [bp+Overhead+dPtrSize]
@hiram = DPTR_ [bp+Overhead]
	@Enter
IF LDATA
	push	es
ENDIF
	push	di
	push	si
	mov	ah,0
	call	VIDRAM_entry
	push	ax			; remember VIDRAM state
	push	di			; and HiRAM segment
	LES_	di,@memtop
	DPTR_NULL es,di,ax
	jz	no_memtop
	mov	ES_[di],si
no_memtop:
	LES_	di,@monitor
	DPTR_NULL es,di,ax
	jz	no_monitor
	mov	al,cl
	mov	ah,0
	mov	ES_[di],ax
no_monitor:
	LES_	di,@flags
	DPTR_NULL es,di,ax
	jz	no_flags
	mov	al,bh
	mov	ah,0
	mov	ES_[di],ax
no_flags:
	LES_	di,@features
	DPTR_NULL es,di,ax
	jz	no_features
	mov	bh,0
	mov	ES_[di],bx
no_features:
	pop	bx			; retrieve HiRAM chain
	LES_	di,@hiram
	DPTR_NULL es,di,ax
	jz	no_hiram
	mov	ES_[di],bx
no_hiram:
	pop	ax			; retrieve VIDRAM state
	mov	ah,0			; zero-extend returned state to 16 bits
	pop	si
	pop	di
IF LDATA
	pop	es
ENDIF
	@Exit
	ret	5*dPtrSize
EndProc@ VIDRAM_STATUS,__PASCAL__

;------------------------------------------------------------------------

PubProc@ VIDRAM_SETUP,__PASCAL__
@state = word ptr [bp+Overhead+8]
@features = word ptr [bp+Overhead+6]
@flags = word ptr [bp+Overhead+4]
@monitor = word ptr [bp+Overhead+2]
@memtop = word ptr [bp+Overhead]
	call	VIDRAM_ENTRYPOINT@
	jz	vr_setup_exit
	@Enter
	push	si
	mov	al,byte ptr @state
	mov	bl,byte ptr @features
	mov	bh,byte ptr @flags
	mov	cl,byte ptr @monitor
	mov	si,@memtop
	mov	ah,01h
	call	VIDRAM_entry
	mov	ax,0
	jc	vr_setup_done
	inc	ax
vr_setup_done:
	pop	si
	@Exit
vr_setup_exit:
	ret	10
EndProc@ VIDRAM_SETUP,__PASCAL__

CSegEnd@

	END
