;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File API.INC	Basic DV-GLUE type and constant declarations	*
;*									*
;************************************************************************
;LastEdit: 12/17/93

	INCLUDE	RULES.ASI

.XLIST

DVGLUE_VERSION equ 171
DVGLUE_VERSION_STR equ "1.71"

;========================================================================
;  Manifest Constants for using the DESQview SEND interface
;========================================================================

OBJECT_MSG	equ	0
NEW_MSG		equ	1
FREE_MSG	equ	2
ADDR_MSG	equ	3
DIR_MSG		equ	3
CONNECT_MSG	equ	3	; v2.26+
READ_MSG	equ	4
APPLY_MSG	equ	4
WRITE_MSG	equ	5
SETPRI_MSG	equ	6	; v2.20+
GETPRI_MSG	equ	7	; v2.20+
SIZE_MSG	equ	8
LEN_MSG		equ	9
ADDTO_MSG	equ	10
SUBFROM_MSG	equ	11
OPEN_MSG	equ	12
CLOSE_MSG	equ	13
UNLOCK_MSG	equ	13
ERASE_MSG	equ	14
STATUS_MSG	equ	15
EOF_MSG		equ	16
AT_MSG		equ	17
SETSCALE_MSG	equ	17
SETNAME_MSG	equ	17
READN_MSG	equ	18
GETSCALE_MSG	equ	18
GETNAME_MSG	equ	18	; v2.50+
REDRAW_MSG	equ	19
SETICON_MSG	equ	19
READINTO_MSG	equ	19	; v2.50+
SETESC_MSG	equ	20
LOCK_MSG	equ	20
SETFLAGS_MSG	equ	21	; v2.20+
GETFLAGS_MSG	equ	22	; v2.20+

;; Object modifiers:
TOS		equ	0	; use contents on top of stack
ME		equ	1	; use requesting task's WINDOW as object
MAILTOS		equ	2	; use MAILBOX(tos) as object
MAILME		equ	3	; use MAILBOX(me) as object
KEYTOS		equ	4
KEYME		equ	5
OBJQTOS		equ	6
OBJQME		equ	7
PARENTTOS	equ	12	; v2.26+
PARENTME	equ	13	; v2.26+
;; only for creating new objects:
WINDOW_CLASS	equ	8
MAILBOX_CLASS	equ	9
KEYBOARD_CLASS	equ	10
TIMER_CLASS	equ	11
POINTER_CLASS	equ	15
PANEL_CLASS	equ	16
;; returned by OBJTYPE
OBJECTQ_CLASS	equ	12	; v2.20+

;========================================================================
; Manifest Constants for TVposwin()
;========================================================================

;/* select a horizontal position... */
PW_HCURR	equ	0
PW_HCENTER	equ	1
PW_LEFT		equ	2
PW_RIGHT	equ	3
;/* ...and a vertical position by ORing them together */
PW_VCURR	equ	0
PW_VCENTER	equ	4
PW_TOP		equ	8
PW_BOTTOM	equ	12
;/* optionally, choose not to refresh the screen right away */
PW_NOREDRAW	equ	16

;========================================================================
;  Manifest Constants for TVkbd_setflags() and TVkbd_clrflags()
;========================================================================

KBD_FIELDMODE	equ	1
KBD_ACTIVE	equ	2
KBD_INSERT	equ	4
KBD_CONCURRENT	equ	8
KBD_FILTERALL	equ	16
KBD_EXCLINPUT	equ	32	; v2.20+

;========================================================================
;  Manifest Constants for TVptr_setflags() and TVptr_clrflags()
;========================================================================

PTR_BUTTON	equ	1
PTR_LEAVE	equ	2	; v2.23+
PTR_RELEASE	equ	4
PTR_ABSOLUTE	equ	8
PTR_SLOWCLICK	equ	16
PTR_NOTFORE	equ	32
PTR_NOTTOP	equ	64
PTR_HIDDEN	equ	128

;/* bits to check for 'button_state' field of POINTER_MSG type */
BUTTON_PRESS	equ	80h
BUTTON_RELEASE	equ	40h
BUTTON_LEFT	equ	1
BUTTON_RIGHT	equ	2

;========================================================================
;  Manifest Constants for DVwin_scroll() and DVfld_scroll()
;========================================================================

SCRL_UP		equ	0
SCRL_DOWN	equ	1
SCRL_LEFT	equ	2
SCRL_RIGHT	equ	3

;========================================================================
;  Manifest Constants for DVfld_build_header() and type FT_HEADER
;========================================================================

;/* screen types (OR together to get desired behavior) */
;/* first, pick on of the following read types: */
F_NOREAD	equ	0
F_READARRAY	equ	1
F_READALL	equ	2
F_READNEW	equ	3
;/* now, add in the remaining flags: */
F_NOFLAGS	equ	8
F_RIGHTBUTTON	equ	10h
F_LEFTBUTTON	equ	20h
F_ALLOWKBD	equ	40h

;========================================================================
;  Manifest Constants for DVfld_build_entry() and type FT_ENTRY
;========================================================================

;/* field types */
F_NONENTRY	equ	0
F_MENUECHO	equ	40h
F_FILLIN	equ	80h
F_MENU		equ	0C0h

;/* field flags, OR with one of the above types */
F_SELECTED	equ	2
F_MODIFIED	equ	1

;/* field modifiers for F_FILLIN (OR together) */
F_BEEP		equ	80h
F_NEXT		equ	40h
F_NUMBER	equ	20h
F_UPPER		equ	10h
F_CLEAR		equ	08h

;========================================================================
;  Other Predefined Constants
;========================================================================

;/* logical text attributes */
LTA_NORMAL	equ	1
LTA_NORMAL_HI	equ	2
LTA_HELP	equ	3
LTA_HELP_HI	equ	4
LTA_ERROR	equ	5
LTA_ERROR_HI	equ	6
LTA_EMPHASIZED	equ	7
LTA_MARK	equ	8
;/* ADD the following to get reverse version of any of the above */
LTA_REVERSEVID	equ	8

;========================================================================
;  Type Definitions
;========================================================================

FT_HEADER	STRUC
  fth_numfields db ?
  fth_type	db ?
  fth_cursor_last db ?
  fth_mouse_last  db ?
  fth_curr_attr db ?
  fth_sel_attr	db ?
FT_HEADER	ENDS

FT_ENTRY	STRUC
  fte_upleftrow db ?
  fte_upleftcol db ?
  fte_lowrightrow db ?
  fte_lowrightcol db ?
  fte_type	db ?
  fte_modifier	db ?
  fte_status	db ?
  fte_key2	db ?
FT_ENTRY	ENDS

POINTER_MSG	STRUC
  pm_row	dw ?
  pm_col	dw ?
  pm_button_state db ?
  pm_extra	db ?
POINTER_MSG	ENDS

DVWININFO	STRUC
  wi_ownerhandle dd ?
  wi_mapcontext	 dw ?
  wi_flags	 dw ?
  wi_tskflag	 db ?
  wi_procnumber  db ?
  wi_tskstatus   db ?
  wi_fgonly	 db ?
  wi_logrows	 db ?
  wi_logcols	 db ?
  wi_physrows	 db ?
  wi_physcols	 db ?
  wi_posrow	 db ?
  wi_poscol	 db ?
DVWININFO	ENDS

DVGREGS	STRUC
  reg_ax	dw ?
  reg_bx	dw ?
  reg_cx	dw ?
  reg_dx	dw ?
  reg_bp	dw ?
  reg_si	dw ?
  reg_ds	dw ?
  reg_di	dw ?
  reg_es	dw ?
  reg_flags	dw ?
DVGREGS ENDS

;========================================================================
;  Inlined Functions
;========================================================================

DV_PAUSE	MACRO	
	mov	ax,1000h
	int	15h
		ENDM

DV_USTACK	MACRO
	mov	ax,1025h
	int	15h
		ENDM

DV_OSTACK	MACRO
	mov	ax,101Ah
	int	15h
		ENDM

DV_CRITBEGIN	MACRO
	mov	ax,101Bh
	int	15h
		ENDM

DV_CRITDEC	MACRO
	mov	ax,111Bh
	int	15h
		ENDM

DV_CRITEND	MACRO
	mov	ax,101Ch
	int	15h
		ENDM

DV_CRITENTER	MACRO
	mov	ax,111Ch
	int	15h
		ENDM

DV_ENABLE	MACRO
	mov	ax,110Fh
	int	15h
		ENDM

;========================================================================
;  Useful Macros
;========================================================================

PUSHM		MACRO	a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,over
IFNB <over>
	.err "Too many args to PUSHM"
ENDIF
	IRP	var,<a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p>
	   IFNB <var>
	      push	var
	   ENDIF
	ENDM
		ENDM

;------------------------------

POPM		MACRO	a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,over
IFNB <over>
	.err "Too many args to POPM"
ENDIF
	IRP	var,<a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p>
	   IFNB <var>
	      pop	var
	   ENDIF
	ENDM
		ENDM

;------------------------------

STACK_STREAM	MACRO	stream
IFNB <stream>
	mov	bx,offset stream
ENDIF
	extrn	$DVG$STACK_STREAM:near
	call	$DVG$STACK_STREAM
		ENDM

;------------------------------

SEND_N		MACRO	message,modif,dflt_mod,obj
IFNB <message>
   IFNB <modif>
     IF ((((.type message) and 0DFh) eq 4) and (((.type modif) and 0DFh) eq 4))
	mov	bx,(message shl 8) + modif
     ELSE
	mov	bh,byte ptr message
	mov	bl,byte ptr modif
     ENDIF
   ELSE
	mov	bh,byte ptr message
   ENDIF
ELSE
   IFNB <modif>
	mov	bl,byte ptr modif
   ENDIF
ENDIF
IFNB <dflt_mod>
  IFIDNI <modif>,<dflt_mod>
  	mov	cl,bl
  ELSE
	mov	cl,byte ptr dflt_mod
  ENDIF
ENDIF
IFNB <obj>
   IFIDNI <obj>,<NIL>
        xor	di,di
	mov	es,di
   ELSE
	les	di,dword ptr obj
   ENDIF ;NIL
ENDIF
	extrn	$DVG$SEND_N:near
	call	$DVG$SEND_N
		ENDM

;------------------------------

SEND_NULL	MACRO	message,mod,obj
IFNB <message>
   IFNB <mod>
     IF (((type message) eq 4) and ((.type mod) eq 4))
   	mov	bx,(message shl 8) + mod
     ELSE
        mov	bh,message
	mov	bl,mod
     ENDIF
   ELSE
   	mov	bh,message
   ENDIF
ELSE
   IFNB <mod>
   	mov	bl,mod
   ENDIF
ENDIF
IFNB <obj>
	les	di,obj
ENDIF
	extrn	$DVG$SEND_NULL:near
	call	$DVG$SEND_NULL
		ENDM

;------------------------------

WIN_STREAM	MACRO	win,seg,off
IFB <seg>
  IF LDATA
  	mov	dx,word ptr off+2
  ELSE
  	mov	dx,ds
  ENDIF
  	mov	bx,word ptr off
ELSE ;NB <seg>
  IFDIFI <seg>,<DX>
	mov	dx,seg
  ENDIF
  IFDIFI <off>,<BX>
	mov	bx,off
  ENDIF
ENDIF
IFNB <win>
	les	di,win
ENDIF
	extrn	$DVG$WIN_STREAM:near
	call	$DVG$WIN_STREAM
		ENDM

;------------------------------

SendOverhead equ Overhead+4

@EnterSend	MACRO	size,reg
	pushm	es,di
	@Enter	size,reg
		ENDM

;------------------------------

@ExitSend	MACRO	count
	@Exit	Y
	popm	di,es
	ret	count
		ENDM

;------------------------------

WIN_MOVE	MACRO	win,row,col
	PUSH_OBJHANDLE win
	push	row
	push	col
ExtProc@ DVWIN_MOVE,__PASCAL__
	call	DVWIN_MOVE@
		ENDM

;------------------------------

WIN_TOP		MACRO	win
	PUSH_OBJHANDLE win
ExtProc@ DVWIN_TOP,__PASCAL__
	call	DVWIN_TOP@
		ENDM

;------------------------------

WIN_REDRAW	MACRO	win
	PUSH_OBJHANDLE win
ExtProc@ DVWIN_REDRAW,__PASCAL__
	call	DVWIN_REDRAW@
		ENDM

;------------------------------

WRITELIT	MACRO	win,string,crlf
		LOCAL	txt
DSeg@
txt	db	string
IFNB <crlf>
	db	13,10
ENDIF
	db	0
DSegEnd@
	PUSH_OBJHANDLE win
	mov	ax,offset DGROUP:txt
	push	ax
ExtProc@ DVWIN_SWRITE,__PASCAL__
	call	DVWIN_SWRITE@
		ENDM

;------------------------------

SLEEP		MACRO	duration
	xor	ax,ax
	push	ax
	mov	ax,duration
	push	ax
ExtProc@ DVSLEEP,__PASCAL__
	call	DVSLEEP@
		ENDM

;------------------------------

ALLOC_MEM	MACRO	count
IFNB <count>
	mov	ax,count
ENDIF
	extrn	$DVG$ALLOC:near
	call	$DVG$ALLOC
		ENDM

;------------------------------

FREE_MEM	MACRO	seg,ofs
IFNB <seg>
  IFNB <ofs>
  	PUSHDPTR seg,ofs
  ELSE
    	PUSHDPTRMEM seg
  ENDIF
ENDIF
	extrn	$DVG$FREE:near
	call	$DVG$FREE
		ENDM

;------------------------------

TMPALLOC	MACRO	count
IFNB <count>
  IFDIFI <count>,<ax>
	mov	ax,count
  ENDIF
ENDIF
	extrn 	$DVG$TMPALLOC:near
	call	$DVG$TMPALLOC
		ENDM

;------------------------------

TMPFREE         MACRO   seg,off
IF LDATA
  IFNB <seg>
    IFDIFI <seg>,<es>
       IFIDNI <seg>,<off>
	  mov	dx,word ptr seg+2
       ELSE
	  mov	dx,seg
       ENDIF
    ENDIF
  ENDIF ;nb seg
ENDIF
IFNB <off>
  IFDIFI <off>,<di>
    IFIDNI <seg>,<off>
	mov	ax,word ptr off
    ELSE
  	mov	ax,off
    ENDIF
  ENDIF
ENDIF
	extrn	$DVG$TMPFREE:near
	extrn	$DVG$TMPFREE_ESDI:near
IFIDNI <seg>,<es>
  IFIDNI <off>,<di>
  	call	$DVG$TMPFREE_ESDI
  ELSE
  	call	$DVG$TMPFREE
  ENDIF
ELSE
	call	$DVG$TMPFREE
ENDIF
		ENDM

;------------------------------

IFDEF I386
PUSHMEM32	MACRO	var
	push	dword ptr var
		ENDM

POPMEM32	MACRO	var
	pop	dword ptr var
		ENDM

COPYMEM32	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ E&tmp
ELSE
	reg equ EAX
ENDIF
	mov	reg,dword ptr src
	mov	dword ptr dest,reg
		ENDM

IF LDATA

PUSHDPTRMEM	MACRO	var
	push	dword ptr var
		ENDM
PUSHDPTR32	MACRO	var
	push	dword ptr var
		ENDM
POPDPTRMEM	MACRO	var
	pop	dword ptr var
		ENDM
COPYDPTR	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ E&tmp
ELSE
	reg equ EAX
ENDIF
	mov	reg,dword ptr src
	mov	dword ptr dest,reg
		ENDM

ELSE ;not LDATA

PUSHDPTRMEM	MACRO	var
	push	word ptr var
		ENDM
PUSHDPTR32	MACRO	var
	push	ds
	push	word ptr var
		ENDM
POPDPTRMEM	MACRO	var
	pop	word ptr var
		ENDM
COPYDPTR	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ tmp
ELSE
	reg equ AX
ENDIF
	mov	reg,word ptr src
	mov	word ptr dest,reg
		ENDM

ENDIF ;LDATA

IF LPROG	; and I386 defined

PUSHCPTRMEM	MACRO	var
	push	dword ptr var
		ENDM
PUSHCPTR32	MACRO	var
	push	dword ptr var
		ENDM
POPCPTRMEM	MACRO	var
	pop	dword ptr var
		ENDM
COPYCPTR	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ E&tmp
ELSE
	reg equ EAX
ENDIF
	mov	reg,dword ptr src
	mov	dword ptr dest,reg
		ENDM

ELSE ;not LPROG

PUSHCPTRMEM	MACRO	var
	push	word ptr var
		ENDM
PUSHCPTR32	MACRO	var
	push	cs
	push	word ptr var
		ENDM
POPCPTRMEM	MACRO	var
	pop	word ptr var
		ENDM
COPYCPTR	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ tmp
ELSE
	reg equ AX
ENDIF
	mov	reg,word ptr src
	mov	word ptr dest,reg
		ENDM

ENDIF ;LPROG

LSS_		MACRO	reg,stk
	lss	reg,dword ptr stk
		ENDM

ELSE ;I386

PUSHMEM32	MACRO	var
	push	word ptr var+2
	push	word ptr var
		ENDM

POPMEM32	MACRO	var
	pop	word ptr var
	pop	word ptr var+2
		ENDM

COPYMEM32	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ tmp
ELSE
	reg equ AX
ENDIF
	mov	reg,word ptr src
	mov	word ptr dest,reg
	mov	reg,word ptr src+2
	mov	word ptr dest+2,reg
		ENDM

IF LDATA	; and not I386

PUSHDPTRMEM	MACRO	var
	push	word ptr var+2
	push	word ptr var
		ENDM
PUSHDPTR32	MACRO	var
	push	word ptr var+2
	push	word ptr var
		ENDM
POPDPTRMEM	MACRO	var
	pop	word ptr var
	pop	word ptr var+2
		ENDM
COPYDPTR	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ tmp
ELSE
	reg equ AX
ENDIF
	mov	reg,word ptr src
	mov	word ptr dest,reg
	mov	reg,word ptr src+2
	mov	word ptr dest+2,reg
		ENDM

ELSE ;not LDATA and not I386

PUSHDPTRMEM	MACRO	var
	push	word ptr var
		ENDM
PUSHDPTR32	MACRO	var
	push	ds
	push	word ptr var
		ENDM
POPDPTRMEM	MACRO	var
	pop	word ptr var
		ENDM
COPYDPTR	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ tmp
ELSE
	reg equ AX
ENDIF
	mov	reg,word ptr src
	mov	word ptr dest,reg
		ENDM

ENDIF ;LDATA and not I386

IF LPROG	; and not I386

PUSHCPTRMEM	MACRO	var
	push	word ptr var+2
	push	word ptr var
		ENDM
PUSHCPTR32	MACRO	var
	push	word ptr var+2
	push	word ptr var
		ENDM
POPCPTRMEM	MACRO	var
	pop	word ptr var
	pop	word ptr var+2
		ENDM
COPYCPTR	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ tmp
ELSE
	reg equ AX
ENDIF
	mov	reg,word ptr src
	mov	word ptr dest,reg
	mov	reg,word ptr src+2
	mov	word ptr dest+2,reg
		ENDM

ELSE ;not LPROG and not I386

PUSHCPTRMEM	MACRO	var
	push	word ptr var
		ENDM
PUSHCPTR32	MACRO	var
	push	cs
	push	word ptr var
		ENDM
POPCPTRMEM	MACRO	var
	pop	word ptr var
		ENDM
COPYCPTR	MACRO	dest,src,tmp
		LOCAL reg
IFNB <tmp>
	reg equ tmp
ELSE
	reg equ AX
ENDIF
	mov	reg,word ptr src
	mov	word ptr dest,reg
		ENDM

ENDIF ;LPROG and not I386

LSS_		MACRO	reg,stk
	cli
	mov	ss,word ptr stk+2
	mov	reg,word ptr stk
	sti
		ENDM

ENDIF ;I386

;------------------------------

MOV_AX_DGROUP	MACRO
IFDEF __TINY__
	mov	ax,cs
ELSE
	mov	ax,DGROUP
ENDIF
		ENDM

;------------------------------

SERIALIZE	MACRO	mutex
		LOCAL	serloop,done
serloop:
	mov	al,1
	lock xchg al,byte ptr mutex
	or	al,al
	jz	done
	DV_PAUSE
	jmp	serloop
done:
		ENDM

;------------------------------

IF LPROG

CALL_REG	MACRO	seg,ofs
		local	return
		push	cs
		mov	ax,offset __TEXT:return
		push	ax		; build fake FAR RET stack frame
		push	seg
		push	ofs
		retf			; jump to subroutine
return:
		ENDM
CALL_NONNULL	MACRO	pointer,tmpreg
		LOCAL	skip,reg
IFB <tmpreg>
	reg equ AX
ELSE
IFIDNI <tmpreg>,<->
	reg equ AX
ELSE
	reg equ tmpreg
ENDIF
ENDIF
IFIDNI <tmpreg>,<->
	push	reg
ENDIF
	mov	reg,word ptr pointer
	or	reg,word ptr pointer+2
IFIDNI <tmpreg>,<->
	pop	reg
ENDIF
	jz	skip
	call	pointer
skip:
		ENDM

ELSE ;LPROG

CALL_REG	MACRO	seg,ofs
		call	ofs
		ENDM
CALL_NONNULL	MACRO	pointer,tmpreg
		LOCAL	reg,skip
IFB <tmpreg>
	reg equ CX
ELSE
IFIDNI <tmpreg>,<->
	reg equ AX
ELSE
	reg equ tmpreg
ENDIF
ENDIF
IFIDNI <tmpreg>,<->
	cmp	pointer,0
	jz	skip
	call	pointer
ELSE
  IFIDNI <reg>,<CX>
	mov	cx,word ptr pointer
	jcxz	skip
	call	cx
  ELSE
	mov	reg,word ptr pointer
	or	reg,reg
	jz	skip
	call	reg
  ENDIF
ENDIF
skip:
		ENDM

ENDIF ;LPROG

;------------------------------

PUSH_OBJHANDLE macro handle,tmpreg
	LOCAL  reg
IFB <tmpreg>
  reg equ AX
ELSE
  reg equ tmpreg
ENDIF
IFIDNI <handle>,<NIL>
  IFDEF I386
	xor	E&reg,E&reg
	push	E&reg
  ELSE
	xor	reg,reg
	push	reg
	push	reg
  ENDIF
ELSE ;IDNI <handle>
	PUSHMEM32 handle
ENDIF
     ENDM

;========================================================================
;========================================================================

; don't touch the following line!
extrn $DVG$COPYRIGHT_MESSAGE:byte

;/* end of API.INC */
.LIST
