#include "mouser.h"
#include <fstream.h>
#include "help.h"

help::help (Mcursor & mouse, bstring hf) : the_mouse (mouse), buttons (2)
	{
	help_file = hf;
	}

help::~help ()
	{
	}

void help::show ()
	{
	show_panel ();

	int is_read = private_show();

	if (is_read == -1)
		{
		moveto (145,100);
		outtext ("Could not find the help data file.");
		}

	if (is_read != 1)
		wait_mouse (0);
	}

/* void help::clear_help ()
	{
	the_mouse.hide();
	setfillstyle (SOLID_FILL,BLUE);
	bar (130,90,getmaxx()-130,getmaxy());
	}
*/

int help::wait_mouse (int more)
	{
	buttons[0].init (getmaxx()-200,getmaxy()-40," DONE ",TEXT);

	if (more)
		buttons[1].init (getmaxx()-275,getmaxy()-40," More ",TEXT);

	mouser 	read_mouse (buttons, more+1, the_mouse, more);
	read_mouse.show();

	int exit = 0;

	while (!exit)
		{
		char keypress;
		char option = read_mouse.get (keypress);

		if ((option == -1 && keypress == 27) || option == 0)
			exit = 2;
		if (option == 1)
			exit = 1;
		}

	return (exit-1);
	}

int help::private_show ()
	{
	int the_color = 0;

	bstring char_string;

	int current_line = 100;

	fstream	file;

	moveto (140,current_line);
	setcolor (BLACK);
	settextjustify (LEFT_TEXT, TOP_TEXT);

	file.open (help_file, ios::in | ios::nocreate);

	if (!file)
		return (-1);

	char in_char;
	int exit = 0;

	while (file.get (in_char) && !exit)
		{
		switch (in_char)
			{
			case '%':
				file.get (in_char);
				the_color = (int(in_char) - 48) * 10;
				file.get (in_char);
				the_color += (int(in_char) - 48);
				setcolor (the_color);
				break;
			case '@':
				file.get (in_char); // get \n
				current_line = 100;
				exit = wait_mouse();
				if (!exit)
					{
//					clear_help ();
					show_panel ();
					setcolor (the_color);
					moveto (140,current_line);
					}
				settextjustify (LEFT_TEXT, TOP_TEXT);
				break;
			case 10: // control-n
				current_line += 10;
				moveto (140,current_line);
				break;
			default:
				char_string = in_char;
				outtext (char_string.return_string());
				break;
			}
		}
	file.close ();

	return exit; // successful
	}


void help::show_panel ()
	{
	Panel help_panel;
	help_panel.init (130,90,375,380, IN, THICK);
	help_panel.show();
	}
