/*
 *  Cheshiresoft Calendar-Almanac
 *  Copyright (c) 2003 by Andrew Ziem.  All rights reserved.
 *  http://chesire.freeservers.com
 *  http://cday.sourceforge.net
 *
 *     LIBRARY.C -- library access routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/*
 *  Problems and Concerns:
 *    - handle leap day
 *    - Day of Week (DoW) mishandled
 *    - '!' mishandled (not handled)
 *
 *
 */

#include <sys/stat.h>
#include <strings.h>

int ListLibraries;
int libraries;
int ListEvents;
int events;
int CompareResult;


#define _GNU_SOURCE
#include "library.h"
int
file_exists (char *fname)
{
#ifdef OLD_NOT_USED
  FILE *f;

  f = fopen (filename, "rb");

  if (!f)
    {

      return FALSE;
    }

  fclose (f);
  return TRUE;
#else
  struct stat stat_buf;
  int rc;

  rc = stat (fname, &stat_buf);

  /* return if file is not a standard file */

  /* should symbolic links be ignored? */

  return (S_ISREG (stat_buf.st_mode));

#endif
}


int
resource_exists (char *rname)
{
  struct stat stat_buf;
  int rc;

  rc = stat (rname, &stat_buf);

  return (0 == rc);
}


/*
 * events_compare()
 * Compare two events for sorting.
 */
int
events_compare (const void *C1, const void *C2)
{
  int RetVal;
  RetVal = 0;

  /* events with years */
  if (0 == ((EVENT *) C1)->year && 0 != ((EVENT *) C2)->year)
    {
      RetVal = ((EVENT *) C2)->year;
    }
  else if (0 != ((EVENT *) C1)->year)
    {
      RetVal = ((EVENT *) C2)->year - ((EVENT *) C1)->year;
    }

  if (0 == RetVal)
    RetVal = strcasecmp (((EVENT *) C2)->text, ((EVENT *) C1)->text);
  CompareResult = RetVal;
  return RetVal >= 0 ? 0 : 1;
}				/* events_compare() */

int
library_sort (void)
{
  EVENT e;
  int ListSort;
  ListSort = LLScreate (sizeof (EVENT));
  if (ERR_MEMORY == ListSort)

    {
      fprintf (stderr, "\nerror: insufficient memory\n");
      fprintf (stderr,
	       "warning: unable to initilize linked list for sorting (memory error)\n");
      return FALSE;
    }
  if (!LLSnodePtr2First (ListEvents))

    {
      fprintf (stderr,
	       "warning: unable to initilize linked list for sorting\n");
      return FALSE;
    }

  do

    {
      LLSnodeDataTo (ListEvents, &e);
      LLSnodePtr2First (ListSort);
      LLSnodeFind (ListSort, events_compare, &e);
      if (0 <= CompareResult)
	LLSnodeInsertFrom (ListSort, &e);

      else
	LLSnodeAddFrom (ListSort, &e);

/*      LLSnodeDelete(ListEvents); */
    }
  while (LLSnodePtr2Next (ListEvents));
  LLSdelete (ListEvents);
  ListEvents = ListSort;
  return TRUE;
}				/* library_sort() */


#include <glob.h>
#include <fnmatch.h>
#ifdef FNM_CASEFOLD
#define GLOB_FLAG FNM_CASEFOLD	/* FNM_CASEFOLD = case insensitive match */
#else
#define GLOB_FLAG 0
#endif
int
filename_matches (char *fname)
{
  /* to do: make month-sensitive */
  char *library_extensions[] =
    { "*.own", "*.all", "*.jan", "*.feb", "*.mar", "*.apr", "*.may", "*.jun",
    "*.jul",
    "*.aug", "*.sep", "*.oct", "*.nov", "*.dec"
  };
  int i;

  for (i = 0; i <= 13; i++)
    {
      if (0 == fnmatch (library_extensions[i], fname, GLOB_FLAG))
	{
	  return TRUE;
	}
    }

  return FALSE;

}


/* queue file to scan later */
void
library_file_queue (char *fname)
{
  LIBRARY l;

  l.fname = MALLOC (strlen (fname) + 1, char);

  if (NULL == l.fname)
    {
      fprintf (stderr, "error: unable to allocate memory (%i bytes)\n",
	       strlen (fname) + 1);
      return;
    }

  strcpy (l.fname, fname);

  LLSnodeAddFrom (ListLibraries, &l);

}				/* library_file_queue () */




/* read files previously queued */
void
library_file_read_queued (void)
{
  LIBRARY l;

  if (!LLSnodePtr2First (ListLibraries))
    return;

  do
    {
      LLSnodeDataTo (ListLibraries, &l);
      library_file_read (l.fname);
    }
  while (LLSnodePtr2Next (ListLibraries));




}				/* library_file_queue () */


/* search for library files to scan */
void
library_file_add (char *fname)
{
  glob_t globbuf;
  int i;
  int rc;
  
  
#ifdef GLOB_TILDE
  rc = glob (fname, GLOB_TILDE, NULL, &globbuf);
#else
  rc = glob (fname, 0, NULL, &globbuf);
#endif

/*
  if (mopts.debug)
    {
      printf ("debug: glob (%s) returns %i\n", fname, rc);
      printf ("debug: gl_pathc = %i\n", globbuf.gl_pathc);
    }
*/
  if (0 == rc)
    {
      for (i = 0; i < globbuf.gl_pathc; i++)
	{
/*	    printf("debug: globbuf.glpathv[%i] = %s\n", i,  globbuf.gl_pathv[i]); */
	  if (filename_matches (globbuf.gl_pathv[i]))
	    {
	      /* library_file_read (globbuf.gl_pathv[i]); */

/*	     
	      if (mopts.debug)
		{
		  printf ("debug: library_file_add->queuing %s\n", globbuf.gl_pathv[i]);
		}
*/
	      library_file_queue (globbuf.gl_pathv[i]);
	    }
	}
    }
  globfree (&globbuf);


}				/* library_file_add() */

int
library_entry_add (char *sinfo1, char *sinfo2, char savebit)
{
  EVENT e;
  char t, sb[2];
  char smon[4], sday[4], syear[6];

/*    printf("debug: sinfo2 = '%s'\n", sinfo2);*/
  /* clear */
  bzero (&e, sizeof (EVENT));
  t = sinfo1[0];

  /* fill */
  if (opts.showbirthdays && t == 'B')
    e.type = T_BIRTHDAY;

  else if (opts.showevents && t == 'S')
    e.type = T_EVENT;

  else
    return FALSE;		/* bad type */
  sinfo1++;
  strncpy (smon, sinfo1, 2);
  sinfo1 = sinfo1 + 2;
  strncpy (sday, sinfo1, 2);
  sinfo1 = sinfo1 + 2;
  strncpy (syear, sinfo1, 4);
  sinfo1 = sinfo1 - 4;
  sb[0] = savebit;
  sb[1] = NUL;
  if (atoi (sb) && atoi (sb) != greg.wday)
    return FALSE;
  if (atoi (smon) != greg.month || atoi (sday) != greg.mday)
    return FALSE;

  e.year = atoi (syear);

#if defined(__EMX__) && !defined(__RSXNT__)
  /* bug */
  if (e.year > 10000)
    e.year = e.year / 10;
#endif /* EMX */

  /* continued */
  if ('C' == savebit)

    {
      EVENT e2;
      LLSnodePtr2Last (ListEvents);
      LLSnodeDataTo (ListEvents, &e2);
      e.text = MALLOC (strlen (sinfo2) + strlen (e2.text) + 2, char);
      if (NULL == e.text)

	{
	  fprintf (stderr,
		   "error: memory full; unable to allocate %i bytes\n",
		   strlen (sinfo2) + 1);
	  return FALSE;
	}

      strcpy (e.text, e2.text);
      strcat (e.text, " ");
      strcat (e.text, sinfo2);
      free (e2.text);
      LLSnodeDelete (ListEvents);
      LLSnodeAppendFrom (ListEvents, &e);
    }

  else

    {
      /* original */
      e.text = MALLOC (strlen (sinfo2) + 1, char);
      if (NULL == e.text)

	{
	  fprintf (stderr, "error: unable to allocate %i bytes memory\n",
		   strlen (sinfo2) + 1);
	  return FALSE;
	}
      strcpy (e.text, sinfo2);
      LLSnodeAppendFrom (ListEvents, &e);
      events++;
    }
  return TRUE;
}				/* library_entry_add() */

void
library_file_read (char *fname)
{
  FILE *in;
  char line[MAX_FGETS_READ], *pstr, *pstr2, savebit;

  if (mopts.debug)

    {
      printf ("debug: searching database `%s`...\n", fname);
      printf ("debug: raw-date(search) %i-%i-%i\n", greg.year, greg.month,
	      greg.mday);
    }

  if (!file_exists (fname))
    {
      return;
    }

  /* open file */

  in = fopen (fname, "rt");
  if (!in)

    {
      fprintf (stderr, "cday: unable to open `%s` for reading\n", fname);
      return;
    }

  /* read file */

  while (NULL != fgets (line, MAX_FGETS_READ, in))

    {
      if (strlen (line) > 12 && '*' != line[0])

	{

	  /* remove trailing CR/LF */
	  if (strchr (line, 0x0D))
	    {
	      char *pszline;
/*		    printf("debug: \"%s\" contains 0x0D\n", line);*/
	      pszline = strchr (line, 0x0D);
	      pszline[0] = '\0';
	    }

	  if (strchr (line, 0x0A))
	    {
	      char *pszline;
	      pszline = strchr (line, 0x0A);
	      pszline[0] = '\0';
	    }

	  pstr = line;

	  savebit = pstr[9];
	  pstr[9] = NUL;
	  pstr2 = &pstr[10];
	  switch (pstr[0])

	    {
	    case 'B':
	    case 'S':
	      library_entry_add (pstr, pstr2, savebit);
	      break;
	    }
	}
    }
  fclose (in);
}				/* library_file_read() */


/* probably very inefficent, but it does work */
void
library_event_show (char *string, int indent)
{
  char *line, *end_line;
  int last = 0, first = 0;
  size_t len;
  word_wrap (string, get_terminal_width () - indent);
  line = string;
  while (!last)

    {
      end_line = strchr (line, '\n');
      if (NULL == end_line)

	{
	  last = 1;
	  end_line = strchr (line, '\0');
	}
      len = end_line - line;
      if (0 != first)

	{
	  printf ("\n");
	  if (indent)
	    printf ("%*c", indent, ' ');
	}

      else
	first++;
      printf ("%*.*s", len, len, line);
      line = end_line + 1;
    }
}				/* library_show_event() */

void
library_show (TYPE showtype)
{
  int first = 0;
  EVENT e;
  if (!LLSnodePtr2First (ListEvents))
    return;

  do

    {
      LLSnodeDataTo (ListEvents, &e);
      if (e.type == showtype)

	{
	  if (0 == first)

	    {
	      switch (showtype)
		{
		case T_EVENT:

		  if (DISPLAY_HTML == mopts.display_mode)
		    printf ("<H3>On this day...</H3>\n");
		  else
		    printf ("\nOn this day...\n");
		  break;

		case T_BIRTHDAY:

		  if (DISPLAY_HTML == mopts.display_mode)
		    printf ("<H3>Happy Birthday to...</H3>\n");

		  else

		    printf ("\nHappy Birthday to...\n");
		  break;

		case T_REMINDER:

		  if (DISPLAY_HTML == mopts.display_mode)
		    printf ("<H3>Don't forget...</H3>\n");
		  else
		    printf ("\nDon't forget...\n");
		  break;

		}

	      ++first;

	    }

	  if (0 != e.year)
	    printf ("In %4i ", e.year);

	  library_event_show (e.text, e.year == 0 ? 2 : 8);
	  if (DISPLAY_HTML == mopts.display_mode)
	    printf ("<BR>\n");
	  printf ("\n");
	}
    }
  while (LLSnodePtr2Next (ListEvents));

}				/* library_show() */
