/*
 *  Cheshiresoft Calendar-Almanac
 *  Copyright (c) 2003 by Andrew Ziem.  All rights reserved.
 *  http://chesire.freeservers.com
 *  http://cday.sourceforge.net
 *
 *     CAL.C -- calendar code
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include "cal.h"


char *gregorian_days[7] = 
  { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday",
"Saturday" 
};
char *gregorian_months[] = { "January", /* 1 */ 
    "February", /* 2 */ 
    "March", /* 3 */ 
    "April", /* 4 */ 
    "May", /* 5 */ 
    "June", /* 6 */ 
    "July", /* 7 */ 
    "August", /* 8 */ 
    "September",  /* 9 */
    "October", /* 10 */ 
    "November",  /* 11 */
    "December" /* 12 */
};
char *gue_months[12] = 
  { "Estuary", "Frobuary", "Arch", "Oracle", "Mage", "Jam", "Jelly",
"Augur", "Suspendur", "Ottobur", "Mumberbur", "Dismembur" 
};
char *gue_days[7] = 
  { "Sand Day", "Mud Day", "Grues Day", "Wands Day", "Birthday",
"Frob Day", "Star Day" 
};

/* (The second e in Vendemiaire and the e in Floreal carry an acute
   accent. The o's in Nivose, Pluviose, and Ventose carry a circumflex
   accent.) -- CALENDAR.FAQ */ 
  
/* from Scott Lee */ 
char *FrenchMonthName[14] = 
  { "", "Vendemiaire", "Brumaire", "Frimaire", "Nivose", "Pluviose",
"Ventose", "Germinal", "Floreal", "Prairial", "Messidor", "Thermidor", "Fructidor", "Extra" 
};
char *FrenchWeekDays[] = 
  { "", "Primidi", "Duodi", "Tridi", "Quartidi", "Quintidi", "Sextidi",
"Septidi", "Octidi", "Nonidi", "Decadi" 
};

/* from DAYNUM.C */ 
char *MoonPhaseText[8] = 
  { "new", "waxing crescent", "first quarter", "waxing gibbous", "full",
"waning gibbous", "third quarter", "waning crescent" 
};

#ifdef NOTUSED
char *moon_text[] = { "new", /* totally dark                         */ 
    "waxing crescent", /* increasing to full & quarter light   */ 
    "first quarter", /* increasing to full & half light      */ 
    "waxing gibbous", /* increasing to full & > than half     */ 
    "full", /* fully lighted                        */ 
    "waning gibbous", /* decreasing from full & > than half   */ 
    "last quarter", /* decreasing from full & half light    */ 
    "waning crescent" /* decreasing from full & quarter light */  
};
char *dias_espanoles[7] = 
  { "Domingo" 
"Lunes"  "Martes"  "Miercols" /* accented 'e' #130 in DOS */  
    "Jueves"  "Viernes"  "Sbado" /* accented 'a' #160 in DOS */  
};
char *meses_espanoles[12] = 
  { "Enero", "Febrero", "Marzo", "Abril", "Junio", "Julio", "Augusto",
"Septiembre", "Octubre", "Noviembre"  "Deciembre" 
};
char *german_days[7] = 
  { "Sonntag", "Muintag", "Tiustag", "Wotanstag", "Thunarrstag",
"Freyjastag", "Saturday" /* ? */  
};

#endif	/* NOTUSED */


/*
 * Return: year's Golden Number (1-19).
 *
 */

#define gregorian_golden_number(year)      ((year % 19) + 1)

/*
 * Return: year's Epact (1-30), Gregorian method
 * Accepts: positive years
 * Warning: untested
 *
 * "In the Gregorian calendar, the Epact is the age of the moon at the
 * start of the year."
 *
 * Adapted to C from the Calendar FAQ.
 *
 */  
int gregorian_epact (YEAR year) 
{
  unsigned int epact = 0, century;
  century = (year / 100) + 1;
  epact = (11 * (gregorian_golden_number (year) - 1)) % 30;
  epact = epact - (3 * century) / 4;
  epact = epact + (8 * century + 5) / 25;
  epact = epact + 8;
  
/* 5) Add or subtract 30 until the Epact lies between 1 and 30. */ 
    if (epact > 30)
    epact -= 30;
  return epact;
}				/* gregorian_epact() */


/*
 * gregorian_moon_phase()
 * Return: phase of the moon for a certian point in time (0-7, 0=new).
 *
 * Stolen from Doorskel, where it was stolel from Lynn Nash, who hacked it
 * from BSD UNIX.
 *
 */ 
unsigned int 
gregorian_moon_phase (YEAR year, int diy) 
{
  int phase;

  /* Calculate the phase, using the magic numbers defined above. Note that
   * (phase and 7) is equivalent to (phase mod 8) and is needed on two days
   * per year (when the algorithm yields 8). */ 
    phase = (((((diy + gregorian_epact (year)) * 6) + 11) % 177) / 22) & 7;
  if (8 == phase)
    
    {
      phase = (((((diy + gregorian_epact (year)) * 6) + 11) % 177) / 22) % 8;
    }
 return phase;
}


/*
 * Return: is date valid in the Gregorian calendar?  (0 = false, 1 = true)
 * From: DAYNUM.C by Bob Stout.
 *
 * Modified to not accept the year '0' and slightly optimized.
 *
 */
int
gregorian_check_date (unsigned yr, unsigned mo, unsigned day)
{
  unsigned int days[] =  {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
  if ((1 > mo || 12 < mo) || 
	(1 > day || day > (days[mo - 1] + (2 == mo && isleap (yr)))) || 
	(0 == yr))
    return FALSE;
 
  else
    return TRUE;
}


/*
 * french_dow()
 *
 * return: day of week in French Republican calendar (1..10)
 *
 */
int french_dow (int mday)
{
  if (0 == mday % 10)
    return (int) (10);

  else
    return (int) (mday % 10);
}






