#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "errors.h"
#include "types.h"

extern BYTE *bptr;
extern char modname[];
PUBLIC **publictable;

HASHREC **publichash;

BOOL loadlib = FALSE;
PUBLIC *entrypoint=0;
static int newpubnum = 0;

void PublicDefinitions(int mode)
{
	int id;
	char buf[MAX_NAMESIZE+1];

	id = ReadNumber(0);
	CheckForComma(TRUE);
	ReadString(buf,MAX_NAMESIZE+1);
	CheckForPeriod();
	if (id >= MAX_PUBLICS)
		fatal("Public ID too big in module %s", modname);
	if (mode == SCAN) {
		HASHREC **q;
		if (q =LookupHash(publichash,buf)) {
			if (!loadlib)
				Error("Public clash, symbol '%s', modules %s and %s",buf,modname,((PUBLIC *)(*q))->modname);
		}
		else {
			PUBLIC *q = AllocateMemory(sizeof(PUBLIC));
			q->name = AllocateMemory(strlen(buf)+1);
			q->modname = AllocateMemory(strlen(modname)+1);
			strcpy(q->name, buf);
			strcpy(q->modname, modname);
			q->sect = 0;
			q->id = newpubnum++;
			q->offset = 0;
			q->referenced = FALSE;
			q->datatype = TY_TYPE;
			AddHash(publichash, q);
			publictable[id] = q;
		}
	}
	else {
		PUBLIC **p = LookupHash(publichash, buf);
		if (p)
			publictable[id] = *p;
	}
}
void PublicSetAddress(void)
{
	PUBLIC *q;
	int id;
	char ch;
	long address;
	int sect=-1;
	id = ReadNumber(0);
	CheckForComma(TRUE);
	ch = ReadChar();
	if (ch == 'R') {
		sect = ReadNumber(0);
		CheckForComma(TRUE);
		address = ReadNumber(0);
		CheckForComma(TRUE);
		if (ReadChar() != '+')
			BadObjectFile();
	}
	else {
		putbackch(ch);
		address = ReadNumber(0);
	}
	CheckForPeriod();
	if ((q = publictable[id]) != 0) {
		q->offset = address;
		if (sect == -1)
			q->sect = 0;
		else
			q->sect = GetSection(sect);
	}
}
void GotoSetAddress(uint mode)
{
	long address;
	int sect;

	CheckForComma(TRUE);
	if (ReadChar() != 'R')
		BadObjectFile();
	sect = ReadNumber(0);
	CheckForComma(TRUE);
	address = ReadNumber(0);
	CheckForComma(TRUE);
	if (ReadChar() != '+')
		BadObjectFile();
	CheckForPeriod();
	if (mode == SCAN) {	
		if (entrypoint)
			Error("Entry point clash '%s' and '%s'",entrypoint->modname,modname);
		else {
			entrypoint = AllocateMemory(sizeof(PUBLIC));
			entrypoint->name = 0;
			entrypoint->modname = AllocateMemory(strlen(modname)+1);
			strcpy(entrypoint->modname, modname);
			entrypoint->offset = address;
			entrypoint->sect = GetSection(sect);
			entrypoint->id = 0;
			entrypoint->referenced = TRUE;
		}
	}
}
PUBLIC *GetPublic(char *name)
{
	PUBLIC **rv = LookupHash(publichash,name);
	if (rv)
		return(*rv);
	return(0);
}
void PublicModuleRundown(uint mode)
{
	int i;
	if (mode == SCAN) {
		PUBLIC **p=publictable;
		for (i=0; i< MAX_PUBLICS; i++) {
			*p = 0;
			p++;
		}
	}
}
void PublicTableInit(void)
{
	PUBLIC **p;
	int i;
	publictable = AllocateMemory(sizeof(PUBLIC *) * MAX_PUBLICS);
	p = publictable;
	for (i=0; i < MAX_PUBLICS; i++) {
		*p = 0;
		p++;
	}
	publichash = CreateHashTable(HASH_TABLE_SIZE);
}
void PublicTableRundown(void)
{
	HASHREC **p = publichash;
	int i;
	DeallocateMemory(publictable);
	for (i=0; i < HASH_TABLE_SIZE; i++) {
		PUBLIC *q = *p;
		while (q) {
			PUBLIC *r = q->link;
			DeallocateMemory(q->name);
			DeallocateMemory(q->modname);
			DeallocateMemory(q);
			q = r;
		}
		p++;
	}
  RemoveHashTable(publichash);
}

		
		