Procedure DoEmulation;         {The Emulator / File-Viewer Package}

        {Common data declarations & routines for Debugger & Viewer}
const
   windsep    =35;             {Location of window divider}
   baseline   =24;             {Location of base-line on screen}
   lastline   =23;             {Final line of display: baseline-1}

   baseleft   : coord = (1,baseline);
   basecentre : coord = (windsep,baseline);
   baseright  : coord = (80,baseline);
   septop     : coord = (windsep,1);
   sepbot     : coord = (windsep,baseline);

type
   dispuse    = (character, attribute);
   diselement = array[character..attribute] of byte;
   winline    = array[windsep..80] of diselement;
   savewind   = record
                cursor  : coord;
                picture : array[1..baseline] of winline;
                end;
   windptr    = ^savewind;

   CRTline    = array[1..80] of diselement;
   Screen     = array[1..25] of CRTline;
   CRTptr     = ^Screen;

var
   debugwind,                     {Save window: DEBUG Screen}
   viewind,                       {Save window: VIEWER Screen}
   helpwind   : savewind;         {Save window: HELP  Screen}
   CRTbase    : CRTptr;           {Base of screen buffer [1,1]}
   firsthelp  : boolean;          {First entry to HELP screen}


procedure showwindow(var which :savewind);  {Moves WHICH to Screen}
var
   line : integer;

begin
   window(1,1,80,25);
   with which do
      for line:= 1 to baseline do move(picture[line], CRTbase^[line,windsep],
                                       (81-windsep)*sizeof(diselement));
   window(windsep+1,1,80,baseline-1);
   end;

procedure savewindow(var which :savewind);  {Moves Screen to WHICH}
var
   line : integer;

begin
   with which do begin
      cursor[xco]:= wherex;
      cursor[yco]:= wherey;
      window(1,1,80,25);
      for line:= 1 to baseline do move(CRTbase^[line,windsep], picture[line],
                                       (81-windsep)*sizeof(diselement));
      end
   end;

procedure promptline(prompts :Str255);     {Display the prompt line}
                                   {The following chars. act as format cmnds.
                                    Open-Curly - High Video
                                   Close-Curly - Low  Video
                                         Tilde - Next (only) has Bit-7 added
                                     Vert.-Bar - Next (only) as Control Chr. }
var
   ptr  : integer;
   bit7,
   ctrl,
   data : byte;

begin
   gotoxy(1,25);                  {To prompt line}
   clreol;
   lowvideo;
   ptr := 1;
   bit7:= 0;
   ctrl:= $ff;
   while (ptr <= length(prompts)) do begin
      case prompts[ptr] of
         '{' : highvideo;
         '}' : lowvideo;
         '~' : bit7:= $80;
         '|' : ctrl:= $bf;
         else begin
            data:= (ord(prompts[ptr]) + bit7) and ctrl;
            write(chr(data));
            if (data = $ba) then begin
               gotoxy(wherex-1, wherey-1);
               write(chr(midtop));          {Force in a T form}
               gotoxy(wherex, wherey+1);    {Return}
               end;
            bit7:= 0;
            ctrl:= $ff;
            end
         end;
      ptr:= ptr+1;
      end
   end;

procedure firstscreen;            {Initial window ops.}
begin
   lowvideo;
   vbar(septop, sepbot);
   gotoxy(windsep,baseline);
   write(chr(midbot));
   gotoxy(windsep,1);
   write(chr(verline));
   highvideo;
   window(windsep+1,1,80,baseline-1);
   end;

procedure pulldebug(restore :boolean);  {Pull DEBUG back onto Screen}
                   {RESTORE will reload a saved window, too}
const
    dbp1 = ' {A}dd {C}ompare {D}isplay {E}nter {F}ill {G}o {H}elp {M}ove';
    dbp2 = ' {Q}uit {R}egs {S}earch {T}race {V}iew file';

begin
   window(1,1,80,25);
   lowvideo;
   hbar(baseleft,basecentre);
   promptline(dbp1+dbp2);         {Show DEBUG prompts}
   if restore then showwindow(debugwind);         {Get the window back}
   window(1,1,80,baseline-1);     {DEBUG window}
   if restore then with debugwind do gotoxy(cursor[xco],cursor[yco])
              else gotoxy(1,1);
   highvideo;
   end;

{Data declarations for the Viewer Module. Placed here, so as to be retained
 across entry & exit to the Viewer window. They are discarded on final exit
 from the Emulator module (ie to Main Menu}

const
   VFRmax    = 255;                {Max. subscript in VF array}

type
   VFdata    = array[0..VFRmax] of byte;

   VFRecord  = record              {Record for the View file, Disk or Heap}
      VFinfo : VFdata;             {A Blocked file, to allow random access}
      end;

   VFptype   = ^VFRecord;

   VFElement = record              {Element of the Virtual-File control table}
      VFptr  : VFptype;            {Ptr. to buffer}
      VFrecno: integer;            {Record no., or -1}
      end;

   VFDescrip = (Recordnum, PosinRecd);

   VFPosn    = array[Recordnum..PosinRecd] of integer;  {A file pointer}

const
   MaxCtl    = 199;                {Highest subscript in Control array}

var
   viewfile  : file of VFRecord;   {The actual Viewer File}

   VFControl : array[0..MaxCtl] of VFElement; {The Heap-Control Table}

                                   {File Pointers...}
                {Conventionally, pointing to 1st. char. AFTER a CR}
   TopFile,                        {Top of File}
   BtmFile,                        {The actual end-of-File}
   TopScreen,                      {Current Top-of-Screen position}
   BotScreen,                      {Line following End of Screen}
   EndScreen    : VFposn;          {Locate TopScreen here to display EndFile}

   FirstView    : boolean;         {Need to draw the screen layout, first}
   ListHandle,                     {DOS handle for List file}
   ColumnOffset : integer;         {Right-shift viewing position}
