/*****************************************************************************
*
*                         Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:     $RCSfile: options.hpp $
* Version:      $Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Header file for command line parsing class. The class
*				TCOptions is an abstract class that defines the methods
*				used to parse the command line in standard System V
*				style.
*
* $Id: options.hpp 1.2 1995/09/16 11:17:03 kjb release $
*
****************************************************************************/

#ifndef	__TCL_OPTIONS_HPP
#define	__TCL_OPTIONS_HPP

#ifndef __DEBUG_H
#include "debug.h"
#endif

#ifndef	__IOSTREAM_HPP
#include <iostream.h>
#endif

/*---------------------------- Typedef's etc -----------------------------*/

#define	OPT_ALLDONE		-1
#define	OPT_PARAMETER	-2
#define	OPT_INVALID		-3
#define	OPT_HELP		-4

#define	MAXARG		40

// TCOption type sepecifiers

#define	OPT_INTEGER		'd'
#define	OPT_HEX			'h'
#define	OPT_OCTAL		'o'
#define	OPT_UNSIGNED	'u'
#define	OPT_LINTEGER	'D'
#define	OPT_LHEX		'H'
#define	OPT_LOCTAL		'O'
#define	OPT_LUNSIGNED	'U'
#define	OPT_FLOAT		'f'
#define	OPT_DOUBLE		'F'
#define	OPT_STRING		's'
#define	OPT_SWITCH		'!'

/*--------------------------- Class Definition ----------------------------*/

//---------------------------------------------------------------------------
// The following structure is used to describe each of the options to the
// options parsing routines. An array of these will need to be set up
// in the constructor call for your derived TCOptions class below.
//---------------------------------------------------------------------------

struct TCOption {
	uchar	opt;				// The letter to describe the option
	uchar	type;				// Type descriptor for the option
	void	*arg;				// Place to store the argument
	char	*desc;				// Description for this option
	};

//---------------------------------------------------------------------------
// The following class is an abstract base class to provide the generalised
// methods to parse a command line. Descendants of this class will need
// to set up the optarr pointer in the constructor before parse() is
// called.
//---------------------------------------------------------------------------

class TCOptions {
protected:
	int			nextargv;		// Variable required by getopt
	char*		nextchar;
	TCOption	*optarr;		// Pointer to option desciption array
	int			numopt;			// Number of options in table

			// Protected member to parse a single option
			int getopt(int argc,char** argv,char* format,char** argument);

			// Protected member to convert a single option
			int convert(const TCOption& option,char* argument);

			// Protected pure virtual to parse a single parameter
	virtual	int doParam(char* param,int num) = 0;

public:
			// Constructor
			TCOptions()	{ optarr = NULL; };

			// Method to parse the command line
			int parse(int argc,char *argv[]);

			// Friend function to display usage information
	friend	ostream& operator << (ostream& o,TCOptions& opt);
	};

#endif	// __TCL_OPTIONS_HPP
