/* Power Render Direct3D State Interface */

#ifndef _PRSTATED3D_
#define _PRSTATED3D_

#ifdef __cplusplus
  extern "C" {
#endif


#define SET_TMAP(mat, renderpoly1, renderpoly2, renderpoly3, vptr1, vptr2, vptr3, vptr1data, vptr2data, vptr3data, facedata) { \
       if (mat->environment_map)                                          \
         {                                                                \
          if (mat->environment_axis == ZAXIS)                             \
            {                                                             \
             (renderpoly1)->s0 = (PR_REAL)((vptr1)->wnx) * 0.000488f + 0.5f;             \
             (renderpoly1)->t0 =-(PR_REAL)((vptr1)->wny) * 0.000488f + 0.5f;             \
             (renderpoly2)->s0 = (PR_REAL)((vptr2)->wnx) * 0.000488f + 0.5f;             \
             (renderpoly2)->t0 =-(PR_REAL)((vptr2)->wny) * 0.000488f + 0.5f;             \
             (renderpoly3)->s0 = (PR_REAL)((vptr3)->wnx) * 0.000488f + 0.5f;             \
             (renderpoly3)->t0 =-(PR_REAL)((vptr3)->wny) * 0.000488f + 0.5f;             \
            }                                                             \
          else if (mat->environment_axis == XAXIS)                        \
            {                                                             \
             (renderpoly1)->s0 = (PR_REAL)((vptr1)->wnz) * 0.000488f + 0.5f;             \
             (renderpoly1)->t0 =-(PR_REAL)((vptr1)->wny) * 0.000488f + 0.5f;             \
             (renderpoly2)->s0 = (PR_REAL)((vptr2)->wnz) * 0.000488f + 0.5f;             \
             (renderpoly2)->t0 =-(PR_REAL)((vptr2)->wny) * 0.000488f + 0.5f;             \
             (renderpoly3)->s0 = (PR_REAL)((vptr3)->wnz) * 0.000488f + 0.5f;             \
             (renderpoly3)->t0 =-(PR_REAL)((vptr3)->wny) * 0.000488f + 0.5f;             \
            }                                                             \
          if (mat->environment_axis == YAXIS)                             \
            {                                                             \
             (renderpoly1)->s0 = (PR_REAL)((vptr1)->wnx) * 0.000488f + 0.5f;             \
             (renderpoly1)->t0 =-(PR_REAL)((vptr1)->wnz) * 0.000488f + 0.5f;             \
             (renderpoly2)->s0 = (PR_REAL)((vptr2)->wnx) * 0.000488f + 0.5f;             \
             (renderpoly2)->t0 =-(PR_REAL)((vptr2)->wnz) * 0.000488f + 0.5f;             \
             (renderpoly3)->s0 = (PR_REAL)((vptr3)->wnx) * 0.000488f + 0.5f;             \
             (renderpoly3)->t0 =-(PR_REAL)((vptr3)->wnz) * 0.000488f + 0.5f;             \
            }                                                             \
         }                                                                \
         else                                                             \
         {                                                                \
             (renderpoly1)->s0 = (facedata)->u[0];                        \
             (renderpoly1)->t0 = (facedata)->v[0];                        \
             (renderpoly2)->s0 = (facedata)->u[1];                        \
             (renderpoly2)->t0 = (facedata)->v[1];                        \
             (renderpoly3)->s0 = (facedata)->u[2];                        \
             (renderpoly3)->t0 = (facedata)->v[2];                        \
         }                                                               }


#define CLAMP_RGB {    \
  if (ADDPRIV_r > 255) \
    ADDPRIV_r = 255;   \
  if (ADDPRIV_g > 255) \
    ADDPRIV_g = 255;   \
  if (ADDPRIV_b > 255) \
    ADDPRIV_b = 255;   \
  if (ADDPRIV_r < 1) \
    ADDPRIV_r = 1;   \
  if (ADDPRIV_g < 1) \
    ADDPRIV_g = 1;   \
  if (ADDPRIV_b < 1) \
    ADDPRIV_b = 1;   }


#define ALPHA_OFF { \
     if (PR_D3D_Caps.AlphaBlend)															\
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_BLENDENABLE, FALSE);	\
     else if (PR_D3D_Caps.AlphaStipple)														\
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, FALSE);	}

void PR_CalcFaceLightingD3D (PR_FACE *face);
/* Calculates the lighting value for a given face */

void PR_CalcVertexLightingD3D (PR_VERTEX *vert, PR_VERTEX_DATA *vertdata);
/* Calculates the lighting value for a given vertex */

/* These are the globals used for rendering.   */
extern PR_FACE_DATA_REAL * ADDPRIV_facedatareal; /* Face Data in floating point format */
extern PR_FACE *        ADDPRIV_face;         /* Pointer to the current face */
extern PR_MATERIAL *    ADDPRIV_mat;          /* Pointer to the current material */
extern PR_VERTEX *      ADDPRIV_vptr1;        /* Pointer to vertices */
extern PR_VERTEX *      ADDPRIV_vptr2;
extern PR_VERTEX *      ADDPRIV_vptr3;
extern PR_VERTEX_DATA * ADDPRIV_vptr1data;    /* Pointer to vertex data */
extern PR_VERTEX_DATA * ADDPRIV_vptr2data;
extern PR_VERTEX_DATA * ADDPRIV_vptr3data;
extern PR_DWORD         ADDPRIV_tmap;         /* Set to TRUE if tmapped */
extern PR_UWORD         ADDPRIV_material_num; /* Current material number */
extern PR_REAL          ADDPRIV_r;            /* RGB color of the current vertex */
extern PR_REAL          ADDPRIV_g;
extern PR_REAL          ADDPRIV_b;
extern PR_DWORD         ADDPRIV_setup_data;   /* TRUE if color and texture data is to be initialized */
extern PR_DWORD         ADDPRIV_setup_state;  /* TRUE if the blending functions are to be initialized */

#ifdef __cplusplus
}
#endif

#endif


