//===================================================================
// utility.hpp
//
// Version 1.0
//
// Written by:
//   Brent Worden
//   WordenWare
//   email:  Brent@Worden.org
//
// Copyright (c) 1999 WordenWare
//
// Created:  April 16, 1999
// Revised:  
//===================================================================

#ifndef _UTILITY_HPP_
#define _UTILITY_HPP_

#include <iterator>
#include "numerics.h"

NUM_BEGIN

template<class T>
inline T absoluteValue(T value)
//--------------------------------------------------------------------
// Return the absolute value of value.
//--------------------------------------------------------------------
{
	static T zero(0);
	return value < zero ? -value : value;
};

template<class T>
inline bool areEqual(T a, T b, T tol = NUMERICS_MAX_ERROR)
//--------------------------------------------------------------------
// Return true if a and b are within tol of each other.  Otherwise,
// return false.
//--------------------------------------------------------------------
{
    return (b - tol <= a) && (a <= b + tol);
}

template<class S, class T, class U>
inline T* valueType(const std::iterator<S, T, U>& iter)
//--------------------------------------------------------------------
// Return the type contained by the iterator.
//--------------------------------------------------------------------
{
	return ((T *)NULL);
};

template<class T>
inline T* valueType(const T* ptr)
//--------------------------------------------------------------------
// Return the type pointed to by the pointer.
//--------------------------------------------------------------------
{
	return ((T *)NULL);
};

NUM_END

#endif

//===================================================================
// Revision History
//
// Version 1.0 - 04/16/1999 - New.
//===================================================================
