#---------------------------------------------------------------------------
#
#       MAKEFILE.MAK: makefile for DOS multitasking library.
#       Copyright (c) J.English 1993.
#       Author's address: je@unix.brighton.ac.uk
#
#       Permission is granted to use copy and distribute the
#       information contained in this file provided that this
#       copyright notice is retained intact and that any software
#       or other document incorporating this file or parts thereof
#       makes the source code for the library of which this file
#       is a part freely available.
#
#---------------------------------------------------------------------------

.AUTODEPEND
.SILENT

#----- Symbol definitions -----

DIR   = d:\borlandc                 # Borland C++ directory -- change to suit
MODEL = l                           # Memory model (s, m, l, c, h or t)
CC    = bcc -m$(MODEL) -I$(INC)\include -L$(LIB)\lib

#----- Default compilation rule -----

.cpp.obj:
    $(CC) -c $.                     # include optimise flag here if desired

#----- Compilation rules -----

all: example1.exe example2.exe example3.exe example4.exe example5.exe \
     example6.exe

example1.exe: example1.obj threads.obj
    $(CC) example1.obj threads.obj

example2.exe: example2.obj threads.obj
    $(CC) example2.obj threads.obj

example3.exe: example3.obj threads.obj
    $(CC) example3.obj threads.obj

example4.exe: example4.obj threads.obj
    $(CC) example4.obj threads.obj

example5.exe: example5.obj threads.obj
    $(CC) example5.obj threads.obj

example6.exe: example6.obj threads.obj
    $(CC) example6.obj threads.obj

thread.obj: thread.cpp
    $(CC) -c -f- $.         # only include optimise flag if you're very brave!

example1.obj: example1.cpp
example2.obj: example2.cpp
example3.obj: example3.cpp
example4.obj: example4.cpp
example5.obj: example5.cpp
example6.obj: example6.cpp

#----- Other targets -----

clean:                              # clean up directory
    del *.obj

print:                              # print sources
    print *.doc *.mak *.h *.cpp
