//--------------------------------------------------------------------------
//
//      EXAMPLE1.CPP: example for DOS multithreading library.
//      Copyright (c) J.English 1993.
//      Author's address: je@unix.brighton.ac.uk
//
//      Permission is granted to use copy and distribute the
//      information contained in this file provided that this
//      copyright notice is retained intact and that any software
//      or other document incorporating this file or parts thereof
//      makes the source code for the library of which this file
//      is a part freely available.
//
//--------------------------------------------------------------------------
//
//      This example starts 3 identical threads, each of which repeatedly
//      displays a message and then pauses.
//
//--------------------------------------------------------------------------

#include <stdio.h>
#include <conio.h>
#include "threads.h"

class Example1 : public DOSThread
{
  public:
    Example1 (int n)      { num = n; }

  protected:
    virtual void main ();

  private:
    int num;
};

void Example1::main ()
{
    char c [70];
    sprintf (c, "Thread %d\n", num);
    while (!userbreak())
    {   fputs (c, stdout);
        pause ();
    }
}

void main ()
{
    Example1 e1 (1), e2 (2), e3 (3);

    puts ("Press CONTROL-BREAK to terminate");
    puts ("Press any key to start...");
    getch ();

    if (!e1.run ())
        puts ("Couldn't start thread 1");
    if (!e2.run ())
        puts ("Couldn't start thread 2");
    if (!e3.run ())
        puts ("Couldn't start thread 3");
}
