#ifndef __PRINT_RECORD_H_
#define __PRINT_RECORD_H_

#include "geom.h"
#include <string.h>

#define ALLOCATION_STEP 20

/*  Each time we print record, we do the same group of operations.
       The sequence of operations is written on some pseudo-language.
*/

// Type of additional information
enum { TEXT_INFO, PCX_INFO, DATE_INFO, PAGE_INFO, REC_NO_INFO };

// Fields in record.
struct FIELD_LAYOUT
    {
    rect coord;                // Clip area on record, cells
    int fieldNumber;           // Number of field in table (first is 1)

    FIELD_LAYOUT(rect r, int f) { coord = r; fieldNumber = f; }
    };

// Non-field information repeated with every record
struct ADDINFO_LAYOUT
    {
    loc pos;                   // Left - top position on record, cells
    int info_type;             // Text or PCX
    char* str;                 // Text, file name and so on
    int service[6];            // For PCX it is width, height, deformation,
			       // for text - font,
			       // size and color and so on.
    ADDINFO_LAYOUT(loc p, int t, char* s = "",
		   int s0 = 0, int s1 = 0, int s2 = 0,
		   int s3 = 0, int s4 = 0)
	{ pos = p; info_type = t; str = strdup(s);
	  service[0] = s0; service[1] = s1;
	  service[2] = s2; service[3] = s3; service[4] = s4;
	  service[5] = TEXT_INFO; }
    ~ADDINFO_LAYOUT() { delete str; }
    };

// Two structures operates with fields and addinfo lists.
struct FIELD_LIST
    {
    int total_fields;          // Allocated;
    int used_fields;           // Number of fields

    FIELD_LAYOUT** field_list; // List of fields to be printed

    FIELD_LIST();
    ~FIELD_LIST();

    void add(FIELD_LAYOUT* field, int number);
    FIELD_LAYOUT* remove_field(int number);
    };

struct ADD_LIST
    {
    int total_add;             // Allocated;
    int used_add;              // Number of fields

    ADDINFO_LAYOUT** add_list; // Additional information for record

    ADD_LIST();
    ~ADD_LIST();

    void add(ADDINFO_LAYOUT* add, int number);
    ADDINFO_LAYOUT* remove_add(int number);
    };

// Record is printed as the list of fields and non-field (additive) data
struct RECORD_LAYOUT : public FIELD_LIST, public ADD_LIST
    {
    RECORD_LAYOUT();
    };


#endif __PRINT_RECORD_H_