#include  <conio.h>
#include "mouse.h"
#include "mouse2.h"
#include "ptimer.h"

class mousetimed : mouseeventlow
  {
    long time;
     mousetimed(mouseeventlow& me):
       mouseeventlow(me),time(programtime())
     {  }

     operator int() const {return time!=0;}
     int same_position(const mousetimed& other) const;
    friend class pressreleasehistory;
    friend loc mouseClearDoubleClick();
     public:
      mousetimed(int):time(0){}
      mousetimed():time(0){}
  //    void show(int line) const;
  };

  int mousetimed::same_position(const mousetimed& other) const
    {
       return x==other.x && y==other.y;
     }

/////////////////////////////////////////////////////////////////////////////

#define Type mousetimed
#define HISSIZ 6
class History_mousetimed
    {
      Type a[HISSIZ];
      int present;
      int written; // if <  HISSIZ
      public:
      History_mousetimed();
      void record(const Type& x);
      Type  recall(int n) const; // 0 - present, 1 - last but one, etc. to HISSIZ
   //   void show(int first);

    };



   History_mousetimed::History_mousetimed():present(0),written(0)
     {

     }

  void History_mousetimed::record(const Type& x)
    {
      if(! written)
	{
	 a[0]=x;
	 present=0;written=1;
	 return;
	}

      if(++present>=HISSIZ)present=0;
      a[present]=x;
     if(written <HISSIZ)written++;

    }

  Type  History_mousetimed::recall(int n) const
    {
       if (n>=written) return Type(0);
       int ind=present-n;
       if(ind<0) ind+=HISSIZ;
       return a[ind];

    }
#undef Type
/////////////////////////////////////////////////////////////////////////////

class pressreleasehistory:mousehandler,History_mousetimed
   {
      long delta_t; // double_clicking speed
	  virtual void handle(mouseeventlow& ev);
      int inhibit;
      public:
      pressreleasehistory(int dt=DEFAULTDOUBLECLICKSPEED);
      int analyze() const;

      ~pressreleasehistory(){}

       friend void  mouseSetDoubleClick(int);
       friend loc mouseClearDoubleClick();
   };

     pressreleasehistory::pressreleasehistory(int dt) :
    mousehandler(mouseeventlow::MSALL ^ mouseeventlow::MSMOVE),
      delta_t(dt),inhibit(0)
      { }
   void pressreleasehistory::handle(mouseeventlow& ev)
     {
       record(ev);
       inhibit=0;
     }

#define ANYDOWN (mouseeventlow::MSLP | mouseeventlow::MSRP | mouseeventlow::MSCP)
 int pressreleasehistory::analyze() const
  // Analyze - for double-click pending
   {
	if (inhibit) return 0;
	mousetimed e0=recall(0);
	if(e0==0)return 0;
	if(!(e0.evtype & ANYDOWN)) return 0;
	int button=MOUSECENTER;
	if(e0.evtype &mouseeventlow::MSLP) button=MOUSELEFT;
	if(e0.evtype &mouseeventlow::MSRP) button=MOUSERIGHT;
	mousetimed e1=recall(1),e2=recall(2);
	int ok=(e1!=0) &&(e2!=0);
	if(!ok) return 0;
	ok=e0.same_position(e1) && e0.same_position(e2);
	if(!ok) return 0;
	ok= !(e1.buttonstatus & button) && (e2.buttonstatus & button);
	if(! ok) return 0;
	ok= ((e0.time-e1.time)<=delta_t) && ((e1.time-e2.time)<=delta_t);
	return ok ? button<<8:0;

   }
//
//   MODULE STARTUP /CLEANUP
// -------------------------------------------------
 static pressreleasehistory * pr;
  static void start_()
  {
     pr= new pressreleasehistory;
   }
  static void exit_()
  {
    delete pr;
   }
#pragma startup start_     80
#pragma exit    exit_      80

// -------------------------------------------------

  mousestatus mouseGetStatus2()
   {  mousestatus r;
      r=mouseGetStatus();
      r.buttonstate|=pr->analyze();
      return r;
    }

/*    void mousetimed::show(int line) const
    {
      gotoxy(40,line); clreol();
	 cprintf("T:%10ld ?:%5x B:%4x (%4d,%4d)",time,evtype,buttonstatus,x,y);

     } */


void  mouseSetDoubleClick(int speed)
  {
    pr->delta_t=speed;
  }

 loc mouseClearDoubleClick()
   {
    pr->inhibit=1;
    mousetimed m=pr->recall(0);
    return loc(m.x,m.y);
    }

/*void debug()
  {pr->show(1);} */
