#ifndef __AXES_H_
#define __AXES_H_

#include "graphpp.h"
#include <string.h>

struct Axes
    {
        int len_scr;               // Length on screen, pixels
        int* ticks;                // Ticks offset from axe beginning, pixels
        int* sub_ticks;            // Sub-ticks, -//-
        char** labels;             // Ticks commentaries
        int ticks_no;              // Total number of ticks
        int sub_ticks_no;          // Total number of sub ticks

    Axes(int l, double start = 0, double end = 0,
            int tick_no = 5, int* t = NULL,
	    int s_tick_no = 0, int* s = NULL,
	    char** lab = NULL);
    ~Axes();
    virtual loc get_label_pos(loc, int )
            { return loc(0, 0); }
    virtual void show_axes(loc, int) {}
    void draw_axes(loc lt, int, int);
    virtual void show_labels(loc) {}
    int calc_labels(double start, double end, int t = 5, int s = 0);
    };
//-------------------------------------------------------------------------//



#endif __AXES_H_