{$U-,C-,R-,K-}
{ A set of routines for text window manipulation
  By Bela Lubkin
  Borland International Technical Support
  1/10/85
  2/20/85 Bug fix: DisposeWindow left a bunch of junk on the heap, causing
    uncontrolled growth!
  (For PC-DOS Turbo Pascal version 2 or greater)
}
TYPE
  XTCoord=1..80;   { X Text coordinate }
  YTCoord=1..25;   { Y Text coordinate }
  XTCoord0=0..80;  { X Text coordinate + 0 for nothing }
  YTCoord0=0..25;  { Y Text coordinate + 0 for nothing }
  WindowRec=RECORD
              XSize: XTCoord;
              YSize: YTCoord;
              XPosn: XTCoord;
              YPosn: YTCoord;
              Contents: ARRAY [0..1999] OF INTEGER;
            END;
  WindowPtr=^WindowRec;

VAR
  WindowXLo: XTCoord;
  WindowYLo: YTCoord;
  WindowXHi: XTCoord;
  WindowYHi: YTCoord;
  ScreenBase: INTEGER;

PROCEDURE TurboWindow(XL: XTCoord; YL: YTCoord; XH: XTCoord; YH: YTCoord);
{ This procedure provides an entry to Turbo's built in Window procedure }
  BEGIN
    Window(XL,YL,XH,YH);
  END;

PROCEDURE Window(XL: XTCoord; YL: YTCoord; XH: XTCoord; YH: YTCoord);
{ This procedure replaces Turbo's built in Window procedure.  It calls the
  original Window procedure, and also keeps track of the window boundaries. }

  BEGIN
    TurboWindow(XL,YL,XH,YH);
    WindowXLo:=XL;
    WindowYLo:=YL;
    WindowXHi:=XH;
    WindowYHi:=YH;
  END;

FUNCTION SaveWindow(XLow: XTCoord; YLow: YTCoord;
                    XHigh: XTCoord; YHigh:YTCoord): WindowPtr;
{ Allocate a WindowRec of the precise size needed to save the window, then
  fill it with the text that is in the window XLow..XHigh, YLow..YHigh.
  Return a pointer to this WindowRec. }

  VAR
    SW: WindowPtr;
    I: INTEGER;
    XS: XTCoord;
    YS: YTCoord;

  BEGIN
    XS:=XHigh-XLow+1;
    YS:=YHigh-YLow+1;
    GetMem(SW,2*XS*YS + 4);
    { Allocate 2 bytes for each screen position, + 4 for size and position }
    WITH SW^ DO
     BEGIN
      XSize:=XS;
      YSize:=YS;
      XPosn:=XLow;
      YPosn:=YLow;
      FOR I:=0 TO YSize-1 DO
        Move(Mem[ScreenBase:((YPosn+I-1)*80+XPosn-1) ShL 1],
             Contents[I*XSize],XSize ShL 1);
      { For each line of the window,
          Move XSize*2 bytes (1 for char, 1 for attribute) into the Contents
               array.  Leave no holes in the array. }
     END;
    SaveWindow:=SW;
  END;

FUNCTION SaveCurrentWindow: WindowPtr;
  BEGIN
    SaveCurrentWindow:=SaveWindow(WindowXLo,WindowYLo,WindowXHi,WindowYHi);
  END;

PROCEDURE RestoreWindow(WP: WindowPtr; XPos: XTCoord0; YPos: YTCoord0);
{ Given a pointer to a WindowRec, restore the contents of the window.  If
  XPos or YPos is 0, use the XPosn or YPosn that the window was originally
  saved with.  If either is nonzero, use it.  Thus a window can be restored
  exactly with  RestoreWindow(wp,0,0);  or its upper left corner can be
  placed at (2,3) with  RestoreWindow(wp,2,3); }

  VAR
    I: INTEGER;

  BEGIN
    WITH WP^ DO
     BEGIN
      IF XPos=0 THEN XPos:=XPosn;
      IF YPos=0 THEN YPos:=YPosn;
      FOR I:=0 TO YSize-1 DO
        Move(Contents[I*XSize],
             Mem[ScreenBase:2*((YPos+I-1)*80+XPos-1)],XSize*2);
      { For each line of the window,
          Move XSize*2 bytes (1 for char, 1 for attribute) from the Contents
               array onto the screen. }
     END;
  END;

PROCEDURE DisposeWindow(VAR WP: WindowPtr);
{ Dispose of a WindowPtr.  The built in procedure Dispose cannot be used,
  because it will deallocate SizeOf(WindowRec) bytes, even though less may
  have been allocated. }

  BEGIN
    WITH WP^ DO FreeMem(WP,2*XSize*YSize+4);
    WP:=NIL;
  END;

PROCEDURE DRestoreWindow(VAR WP: WindowPtr; XPos: XTCoord0; YPos: YTCoord0);
{ Restore the contents of a window, then dispose of the saved image }

  BEGIN
    RestoreWindow(WP, XPos, YPos);
    DisposeWindow(WP);
  END;

PROCEDURE DRestoreCurrentWindow(VAR WP: WindowPtr;
                                XPos: XTCoord0; YPos: YTCoord0);
{ Restore the contents of a window, set the current window to fit the restored
  window, and dispose of the saved image.  A similar procedure
  RestoreCurrentWindow could be written by changing DRestoreWindow to
  RestoreWindow in the last line of the procedure, but I have assumed that
  when you select a window area, you are going to modify it, and not want the
  old image }

  BEGIN
    WITH WP^ DO
     BEGIN
      IF XPos=0 THEN XPos:=XPosn;
      IF YPos=0 THEN YPos:=YPosn;
      Window(XPos,YPos,XPos+XSize-1,YPos+YSize-1);
     END;
    DRestoreWindow(WP, XPos, YPos);
  END;

{****** My interface - S. Murphy ******}

TYPE
    WindowParms = RECORD
        col1, col2,
        row1, row2 : INTEGER;          {corner co-ordinates}
        frame : 0..2;                  {border type}
        CursorX, CursorY : INTEGER;          {cursor position}
    END;

    WindowDescriptor = ^WindowParms;
VAR
   StatWin, TermWin,
   CurrentWin, border    : WindowDescriptor;
   TempWin               : WindowPtr;
   StackedPage           : WindowPtr;

PROCEDURE UsePermWindow(VAR w : WindowDescriptor);
BEGIN
     WITH CurrentWin^ DO
     BEGIN
          CursorX := WhereX;
          CursorY := WhereY
     END;
     CurrentWin := w;
     WITH w^ DO
     BEGIN
          Window(col1,row1,col2,row2);
          GotoXY(CursorX, CursorY)
     END
END;

PROCEDURE Status(slot :INTEGER; msg : bigstring);
VAR
   i : INTEGER;
BEGIN
     UsePermWindow(StatWin);
     GotoXY(20*slot+1,1);
     IF slot < 3 THEN
         WRITE('                    ')
     ELSE
         WRITE('                   ');
     GotoXY(20*slot+1,1);
     WRITE(msg);
     UsePermWindow(TermWin)
END;


PROCEDURE InitWindow(VAR w : WindowDescriptor;
                         x1, y1, x2, y2 : INTEGER);
BEGIN
     NEW(w);
     WITH w^ DO
     BEGIN
          col1 := x1;
          col2 := x2;
          row1 := y1;
          row2 := y2;
          CursorX := 1;
          CursorY :=1
     END
END;

PROCEDURE DrawBox(col1, row1, col2, row2, frame : INTEGER);
TYPE
    cvec6 = ARRAY[1..6] OF CHAR;
    cptr = ^cvec6;
CONST
     V1 = #179;   UR1 = #191;   UL1 = #218;
     V2 = #186;   UR2 = #187;   UL2 = #201;
     H1 = #196;   LR1 = #217;   LL1 = #192;
     H2 = #205;   LR2 = #188;   LL2 = #200;

     SFRAME : cvec6 = (UL1,H1,UR1,V1,LL1,LR1);
     DFRAME : cvec6 = (UL2,H2,UR2,V2,LL2,LR2);

VAR
   framedef : cptr;
   i,j : INTEGER;
BEGIN
     IF frame <> 0 THEN
     BEGIN
          CASE frame OF
             1 : framedef := Ptr(Seg(SFRAME),Ofs(SFRAME));
             2 : framedef := Ptr(Seg(DFRAME),Ofs(DFRAME))
          END;
          GotoXY(col1, row1);
          WRITE(framedef^[1]);
          FOR i := col1 + 1 TO col2 - 1 DO
              WRITE(framedef^[2]);
          WRITE(framedef^[3]);
          FOR i := row1 + 1 TO row2 - 1 DO
          BEGIN
                GotoXY(col1, i);
                WRITE(framedef^[4]);
                GotoXY(col2, i);
                WRITE(framedef^[4])
          END;
          GotoXY(col1, row2);
          WRITE(framedef^[5]);
          FOR i := col1 + 1 TO col2 - 1 DO
              WRITE(framedef^[2]);
          WRITE(framedef^[6])
    END
END;

PROCEDURE OpenTemp(x1,y1,x2,y2,border : INTEGER);
BEGIN
     WITH CurrentWin^ DO
     BEGIN
       CursorX := WhereX;
       CursorY := WhereY;
       TempWin := SaveWindow(col1,row1,col2,row2)
     END;
     DrawBox(x1,y1,x2,y2,border);
     TurboWindow(x1+1, y1+3, x2-1, y2+1);
     ClrScr;
     GotoXY(1,1)
END;

PROCEDURE CloseTemp;
BEGIN
     DRestoreWindow(TempWin,0,0);
     WITH CurrentWin^ DO
     BEGIN
        TurboWindow(col1,row1,col2,row2);
        GotoXY(CursorX,CursorY)
     END
END;

PROCEDURE PushPage;
CONST
     MEMNEEDED = 3696; {memory overhead to store a page}
VAR
   c : CHAR;
BEGIN
     IF MEMAVAIL >= MEMNEEDED THEN
     BEGIN
          OpenTemp(20,5,75,10,2);
          WRITE('Save this screen? (Y/N; default N) ');
          READLN(c);
          CloseTemp;
          IF c IN  ['Y','y'] THEN
               StackedPage := SaveWindow(1,3,80,25)
     END
     ELSE BEGIN
          OpenTemp(30,5,70,10,2);
          WRITELN('Out of Memory: Can''t save page.');
          WRITE('Type <cr> to continue.');
          READLN
     END
END;

PROCEDURE PopPage;
BEGIN
     IF StackedPage <> NIL THEN
          DRestoreWindow(StackedPage,0,0)
END;
