/*
 * File......: DIR2DBF.PRG
 * Author....: Steve Kolterman
 * CIS ID....: 76320,37
 * Date......: $Date:   15 Aug 1991 23:03:26  $
 * Revision..: $Revision:   1.3  $
 * Log file..: $Logfile:   E:/nanfor/src/dir2dbf.prv  $
 * 
 * This is an original work by Steve Kolterman and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/dir2dbf.prv  $
 * 
 *    Rev 1.3   15 Aug 1991 23:03:26   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.2   14 Jun 1991 19:51:34   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.1   31 May 1991 21:11:28   GLENN
 * Steve Kolterman's second revision
 * 
 *    Rev 1.0   01 Apr 1991 01:01:10   GLENN
 * Nanforum Toolkit
 *
 */



/*  $DOC$
 *  $FUNCNAME$
 *     FT_DIR2DB()
 *  $CATEGORY$
 *     Environment
 *  $ONELINER$
 *     Create .DBF of directory files, using DOS filespec
 *  $SYNTAX$
 *     FT_DIR2DB( <cSpec> [, <cDbf> ][, <cNtx> ][, <cDrvr> ] ) -> <nErrcode>
 *  $ARGUMENTS$
 *     <cSpec> can be any valid DOS file spec., including wildcards and
 *      single file names.
 *
 *     <cDbf> is the name of the .DBF to create.  If not specified, the
 *      name 'FILES' is used.
 *
 *     <cNtx> is the name of the .NTX to create.  If not specified, no
 *      index is created.
 *
 *     <cDrvr> is the name of the Nantucket RDD (replaceable database
 *      driver) to use.  If not specified, the default, 'DBFNTX', is
 *      used.
 *  $RETURNS$
 *     <nErrcode>, which will be one of the following:
 *
 *        0 - no error
 *        1 - no file spec. passed
 *        2 - no files match spec. passed
 *        3 - network error opening <cDbf>
 *  $DESCRIPTION$
 *     FT_DIR2DB() builds a .DBF from and fills it with the files/data
 *     matching any valid DOS file spec.  Fields created are 'Name',
 *     'Size', 'Date', 'Time', and 'Attr' (attribute).
 *
 *     An index on the 'name' field is also created by passing a name
 *     for the .NTX as a third parameter.  An optional fourth parameter
 *     accommodates the RDDs (replaceable database drivers) Nantucket
 *     promises.
 *  $EXAMPLES$
 *     nVal:= FT_DIR2DB( "*.dbf","dbffiles","filename" )
 *     Creates DBFFILES.DBF consisting of all .DBFs in the current dir-
 *     ectory, and also creates FILENAME.NTX.
 *
 *     nVal:= FT_DIR2DB( "*.*","pdoxdbf","pdoxntx","paradox" )
 *     would create a Paradox database and index consisting of all files
 *     in the current directory.
 *  $END$
 */

#include "directry.ch"

#ifdef FT_TEST

FUNCTION Test( spec,dbf,ntx,drvr )
LOCAL ret_val:= FT_Dir2db( spec,dbf,ntx,drvr ),msg
IF ret_val > 0
  msg:= IF( ret_val==1,"File Spec. Not Passed", ;
        IF( ret_val==2,"No Files Match Passed Spec.", ;
                       "Network Problem Creating "+upper(dbf)+".DBF" ))
  Alert( "Error!"+";"+msg,{"Quit"} ); END
QUIT
RETURN NIL

#endif

FUNCTION FT_DIR2DB( spec,dfile,ntx,driver )
LOCAL adbf,struc,orig_area,error_code:= 0
FIELD name

IF spec==NIL; error_code:= 1
ELSE
   dfile := IF( dfile==NIL,"files",dfile )
   adbf  := {  {"Name","C",12,0},;
               {"Size","N",9,0}, ;
               {"Date","D",8,0}, ;
               {"Time","C",8,0}, ;
               {"Attr","C",4,0}     }

   IF EMPTY( struc:= DIRECTORY(spec) ); error_code:= 2
   ELSE
      orig_area:= SELECT()
      DBCREATE(dfile,adbf)
      USE (dfile) EXCLUSIVE NEW VIA (driver)
      IF NETERR(); error_code:= 3
      ELSE
         Aeval( struc, {|e,n| dbAppend(), ;
                              Fieldput(F_NAME,struc[n][F_NAME]),;
                              Fieldput(F_SIZE,struc[n][F_SIZE]),;
                              Fieldput(F_DATE,struc[n][F_DATE]),;
                              Fieldput(F_TIME,struc[n][F_TIME]),;
                              Fieldput(F_ATTR,struc[n][F_ATTR])   } )
         IF ntx <> NIL; INDEX ON name TO (ntx); END
         CLOSE (dfile)
         SELECT(orig_area)
      ENDIF
   ENDIF
ENDIF

RETURN ( error_code )

// EOF: DIR2DB.PRG
