                      User's Guide to CHMSPECS
                    (Chemical Speciation of Seawater)
             Previously known as Chemical Speciation-92 (CS-92)

                            version 1.0 b
                      by Toedsit  Netratanawong
       copyright 1993 by Toedsit Netratanawong under the name CS-92


                            INTRODUCTION

     CHMSPECS or Chemical Speciation-92 (CS-92) is a programme for calculating
chemical speciation of major constituents in seawater on IBM PC and compatibles.
Speciation is defined, chemically, by the nature of interactions between
cations, e.g. Na+, Ca++, and anions, e.g. SO4--, HCO3-.  In seawater major ions,
whose concentrations are in mg/L, form strong complexes, thereby reduce the
availability of 'free' concentration.  The complexes can be visualized as water
molecules surrounding the major ions (hydrated) or surrounding the
already-formed cation-anion complexes (complex species for short).  The free
concentrations of major anions, thus, suggest the degree of complexation and
availability for interactions with other trace elements.  The trace elements, in
turn, forms further complexes with major 'free' constituents.  The availability
of both major and minor (trace) elements are important in bioavailability, cell
functions, toxicity, and living conditions of organisms, etc. (see Stumm and
Morgan, 1981 for further discussion).

     The programme followed the ideas of the late Robert M. Garrels (Garrels
and Thompson, 1962).  He and Mary helped developed a model of chemical
speciation of major ions in seawater using only paper, pencil, logarithm table,
data constants of major ions in seawater and data of dissociation constants of
complexes.  (The dissociation constants are directly inversed those of
association constants.)  They also went through the activity coefficient
topics, which were not included in the CS-92.  Algorithm used in their
calculation was successive substitution which also was used in the present
programme (see also van Gaans, 1989).  Newton-Raphson algorithm is not
considered here.  Typically, 5 number of iterations (cycles of successive
substitution) are needed for the calculation to converge (to reach stabilising
limits).  Approximately two to three hours are used to calculate the model
using a non-programmable scientific calculator.  CS-92 may, in the future,
replace time-consuming calculation steps.  However, the users are suggested to
try calculate the model using calculator once to obtain a better understanding
of the Garrels's model.


                                FEATURES

1.     The Chemical Speciation-92, CS-92, comprises 1 compressed files:
         1.1  CHMSPECS.ZIP---a PK-ZIP compressed file, which upon expanded gives,

               CS.EXE-----main programme,
               CSBACK.EXE--back-up file of CS.EXE,
               GIVEN.CSD--default constants,
               USERS.CSD--users' defined constants,
               LIT_HELP.CSD--brief help file (text file),
               BIG_HELP.CSD-this help file (text file)
               RESULTS.CSD---results file on disk,
               USERS_GR.CSD--default constants of Garrels,
               RESLT_GR.CSD--results from using USERS_GR.CSD
                         constants.
               CS92READ.TXT--description of the files and their
                             contents


     To start using the programme please
     1.1.1 Scan the diskette for computer viruses; always obtain the
               CS-92 programme from reliable software libraries or electronic
               bulletin boards, Internet sites, or friends.
     1.1.2 Make a back-up copy by using
          DISKCOPY A: A:  or  DISKCOPY B: B:  or
          at C prompt:
          MD CS and COPY A:\*.* C:\CS  or
          MD CS and COPY B:\*.* C:\CS
          depending on your diskette drive.
     1.1.3 Change to appropriate directory
     1.1.4 Use UNZIP utility to decompress the CS92.ZIP.
     1.1.5 The CHMSPECS.ZIP will expand into 10 files; 2 of these files are main
          programmes: CS.EXE and CSBACK.EXE.
     1.6 Start the programme by typing CS and press ENTER key, and follow
          the instructions on the screen.

2.     Copyright notice: This CS-92 is copyrighted by Toedsit Netratanawong
(1993).  All rights under the copyrights are reserved.  This programme is a
freeware, and requires NO registration fee.


3.     Disclaimer: Users agree to use the CS-92 programme at their own risks,
and on the basis of "as is" software.  There is no warranty of any kind.  The
author, as well as the shareware libraries or electronic downloading sources
assume no liabilities for consequences, and direct, or indirect loss of
productivity, data, and time in the users' computer system, or any errors found
in the programme.

4.     Registration: No registration fee is required.


      The distribution of CS-92 programme is allowed for only the 11 following
files:

          CS.EXE-----main programme,
          CSBACK.EXE--back-up file of CS.EXE,
          GIVEN.CSD--default constants,
          USERS.CSD--users' defined constants,
          LIT_HELP.CSD--brief help file (text file),
          BIG_HELP.CSD-this help file (text file)
          RESULTS.CSD---results file on disk,
          USERS_GR.CSD--default constants of Garrels,
          RESLT_GR.CSD--results from using USERS_GR.CSD
                         constants
          CS92READ.TXT--Guide to electronic distribution version

          CHMSPECS.ZIP---Compressed file containing the above 10 files.

5.                            General:

          The CS-92 was designed with the ease of use the convenience of
reading users' favourite constants, and the ability to save the constants as
well as the calculated results.  It should work well in estuarine as well as
open oceanic waters.  The programme was written in C language, the executable
file is < 60 kbytes; the data files and help files are < 30 kbytes.  It has a
built-in floating point emulator, thus helps speed up the calculation.  Math
(floating-point) co-processor is not a requirement; but it should definitely
speed up calculation for 1000 iterations or more.  The CS-92 can run on any IBM
compatibles using intel X-86 families: 8088, 8086, 80286, 80386, 80486 and
Pentium (80586); NEC V-series, AMD, Cyrix, and other processors should work
similarly to X-86.  DOS version can be from 2.1 through 7.0.  A computer that
has at least 256 kbytes of random-access memory (RAM) should be able to run CS-
92.  The programme was test-run successfully under DOS windows in WINDOWS 3.1
and OS/2 2.1 and Warp.  The CS-92 is expected to work under DOS windows in
WINDOWS 95 as well.  In addition, it can also run under SoftPC installed on
McIntosh computers.  (SoftPc is an X-86 emulator for Motorola 68X series.)  The
typical calculation time is < 2 seconds for 10 iterations.

6.                       Menu description:

          Main menu is self-explanatory.  First option let users browse
through a brief help.  Second and third options let users read data (constants)
from disk (either floppy or hard-disk depending the directory of CS.EXE), type
the constants to the screen, do the calculation, print the results to the
screen and save the results as RESULTS.CSD.  The second and third options read
GIVEN.CSD (default) and USERS.CSD, respectively.  The USERS.CSD can be input
using the option 4, which will be discussed later, or using an text-editor
(e.g. EDLIN.EXE, or E editor, or EDIT.COM) to create the constants following
the given formats below.  Option 4 help users input their preferred constants
one by one , save the input constants as USERS.CSD on the same disk (of CS.EXE)
and perform similar operations as options 2 and 3.  Option 5 will let users
exit the programme (to the DOS prompt).

     For advanced users, ones can rename the USERS.CSD or even GIVEN.CSD to
their preferred sets of constants created using a text-editor programme, so the
next calculation time there will be no need for input of constants using option
4.  USERS_GR.CSD is an example of constants used by Garrels and Thompson
(1962).  The calculated results are given in RESLT_GR.CSD.  The results can be
printed out to a printer (e.g. laser printer, or dot-matrix printer) easily by
using either issuing TYPE RESULTS.CSD >PRN at DOS prompt or loading into your
favourite word-processor, and print out to a printer.  For laser printers,
users may need to turn the ON LINE off, then press FORM FEED, and turn on ON
LINE again.

     Only 21 complexes are considered in this programme, namely NaSO4, NaHCO3,
NaCO3, NaF, NaB(OH)4, MgSO4, MgHCO3, MgCO3, MgF, MgB(OH)4, KSO4, KCO3, CaSO4,
CaHCO3, CaCO3, CaF, CaB(OH)4, SrSO4, SrHCO3, SrCO3, SrF, SrB(OH)4.  All
constants have to be corrected for salinity and temperature of interested
waters (including the activity coefficients).  One good reference on formation
constants is Millero and Schreiber (1982).  If the users consider a fewer
complexes than the given 21 complexes, they can input their interested
constants and set other remaining constants to zero.  However, the users still
input the values of major cations' and anions' concentrations; because one
algorithm need to use major ions' concentrations as denominators.   Final
results will show the number of iterations, concentrations of free ions,
percentages of free ions, total ionic strengths and effective ionic strengths.

     Chloride complexation is not considered in seawater as explained by
Kester (1986) and others.  The argument is that the chloride salts (e.g. NaCl,
MgCl2, etc.) dissociate fully in seawater, and do not form ion pairs (like NaCl
ion pair).

     Ionic strengths are defined as the summation of effects of charges and
total concentrations of constituents.  However, effective ionic strengths
consider the combined effects of ion- pairs of all species in waters.


7.     List of formation constants and total concentration of major ions in
                             seawater:

     (Remember to correct the formation constants to temperature and salinity
appropriated for water samples.  To input the constants for option 4, one needs
to type in only the number (up to 6 significant numbers) in e formats.  To
create your USERS.CSD or GIVEN.CSD, one needs to use plain text-editor to input
constants starting with K of NaSO4 until reaching T(Cl).  The K(s) are
formation constants in exponential form (number times 10 raised to the power
xx) , and T(Na) concentration in mol/kg.  You must type in only the number in e
formats without line number or other description: e.g. 2.121e0 press ENTER
(value=2.121), 2.804e- 1 press ENTER (value=0.2804 or 2.804 times 10 raised to
power minus 1).  There must not be extra space between constants, and should
start at line 1.)


     line 1    K of NaSO4     2.121000e0,
     line 2    K of NaHCO3    2.804000e-1,
     line 3    K of NaCO3     2.363000e0,
     line 4    K of NaF       1.003000e-1,
     line 5    K of NaB(OH)4  6.757000e-1,
     line 6    K of MgSO4     1.019000e+1,
     line 7    K of MgHCO3    2.147000e0,
     line 8    K of MgCO3     7.884000e+1,
     line 9    K of MgF       1.941000e+1,
     line 10   K of MgB(OH)4  7.795000e0,
     line 11   K of KSO4      1.625000e0,
     line 12   K of KCO3      2.844000e-1,
     line 13   K of CaSO4     1.074000e+1,
     line 14   K of CaHCO3    2.152000e0,
     line 15   K of CaCO3     1.411000e+2,
     line 16   K of CaF       4.485000e0,
     line 17   K of CaB(OH)4  1.275000e+1,
     line 18   K of SrSO4     6.912000e0,
     line 19   K of SrHCO3    2.086000e0,
     line 20   K of SrCO3     1.368000e+2,
     line 21   K of SrF       2.309000e0,
     line 22   K of SrB(OH)4  6.991000e0,
     line 23   T(Na)          4.681000e-1,
     line 24   T(Mg)          5.325000e-2,
     line 25   T(Ca)          1.027000e-2,
     line 26   T(K)           1.021000e-2,
     line 27   T(Sr)          9.106000e-5,
     line 28   T(SO4)         2.824000e-2,
     line 29   T(HCO3)        1.579000e-3,
     line 30   T(CO3)         2.950000e-4,
     line 31   T(B(OH)4)      4.127000e-4,
     line 32   T(F)           6.781000e-5,
     line 33   T(Cl)          5.459000e-1,


8.     How to contact the author:

          The current version is not bug-ridden, but programming mistakes can
happen.  If there is something wrong, try holding the CTRL key while typing C
key several times to exit the programme.  Please report any problems, bugs,
suggestions, errors or comments to the author at

          Toedsit  Netratanawong, Ph.D.
          Internet address:     toedsit.n@tfb.co.th
                                       (as of March 1997)

9.   References

Garrels, R.M. and Thompson, M.E. 1962.  A chemical model for sea water at 25oC
      and one atmosphere total pressure.  American Journal of Science 260, 57-
      66.

Kester, D.R. 1986.  Equilibrium models in seawater: Applications and
      limitations.  In: Bernhard, M. Brinckman, F.E. and Sadler, P.J.
      (editors), The importance of chemical speciation in environmental
      processes.  pages 337-363.  Dahlem Konference, 1986.  Springer-Verlag.

Millero, F.J. and Schreiber, D.R. 1982.  Use of the ion pairing model to
      estimate activity coefficients of the ionic components of natural waters.
      American Journal of Science 282, 1508-1540.

Stumm, W. and Morgan, J.J. 1981.  Aquatic chemistry, second edition.  Wiley.
      (Chapter 6.)

van Gaans, P.F.M. 1989.  WATEQX - A restructured, generalized, and extended
      FORTRAN 77 computer code and database format for the WATEQ aqueous
      chemical model for element speciation and mineral saturation, for use on
      personal computers or mainframes.  Computers & Geosciences 15, 843-887.


10.                           History

     1993 February - CS-92 version 1.0; first release
     1993 February - BIG_HELP.CSD version 1.0a.
     1993 March    - updated CS-92 with better recursive menu check
     1995 May      - CS-92 version 1.0a, fixed zero denominator problems in
                      certain options of calculations
                     BIG_HELP.CSD version 1.0b
                      Modification of registratiton rules to reflect fair
                       and wide distribution of the programme.
     1997 March    - Redistributed under the name CHEMSPECS.ZIP;
                        no registration fee is required


Toedsit Netratanawong                                           2 March 1997
------------------------------------------------------------------------------

