/*
**
** HELP.C      Eval help text.
**
** Will Mennninger, ANSI C
**
*/

char *bhelp =
"Command line options (aside from expressions)\n"
"---------------------------------------------\n"
"help [n]       Display extended help (start with page n if specified).\n"
"quit           Exit program.\n"
"?              Display brief help (this list).\n"
"?? [n]         Display extended help (start with page n if specified).\n"
"? s            Display status (output type, default bases, etc.).\n"
"? v            Display a list of all currently assigned variables.\n"
"? c            Display a list of all pre-assigned constants.\n"
"? f            Display a list of available functions.\n"
"? fl           Display a list of available functions with descriptions.\n"
"? o            Display a list of all operators.\n"
"ibase n        Set input base to n.\n"
"obase n        Set output base to n.\n"
"sci            Toggle scientific notation output on/off.\n"
"fix            Toggle fixed precision on/off.\n"
"dplace n       Set the number of digits after the decimal in fixed prec.\n"
"sigfig n       Set the number of significant figures to be printed.\n"
"maxexp n       Set exponent at which output switches to sci format.\n"
">filename      Write to script file, filename.\n"
">              Terminate write to script file.\n"
"<filename      Read script file, filename.\n"
"wdir dirname   Set write directory for scripts.\n"
"rpath path     Set path for reading scripts.\n";

char *ehelp =
"Eval evaluates floating point expressions and functions.  It has    p. 1/9\n"
"several built in operators and functions, and can take input and\n"
"display output in a variety of formats for any number base.\n"
"\n"
"A simple example-- Type:\n"
"\n"
"Ex> x = sin(2.58)*sqrt(10)+_pi*_mu0\n"
"\n"
"The value on the right is computed, printed, and assigned to 'x'.\n"
"_pi and _mu0 are two of many pre-assigned constants.  You may use any\n"
"previously assigned variable in new expressions.  Variable names are\n"
"allowed to be up to 16 characters long.\n"
"\n"
"A single double quote (\") refers to the last value displayed.  Example:\n"
"Ex> sqrt(2)\n"
"1.414213562\n"
"Ex> 20*\"*\"\n"
"40\n"
"\f\n"
"Number bases                                                        p. 2/9\n"
"------------\n"
"Values can be displayed in any number base from 2 to 36.  You can set\n"
"the default input and output bases with the \"ibase\" and \"obase\"\n"
"commands, respectively.\n"
"\n"
"Exponent representation\n"
"-----------------------\n"
"If you are working in a base above 14, use a \\ instead of an E for\n"
"scientific notation.  E.g. If you are working in base 16,\n"
"A\\10 = hex A times 10^10, where both 10's are in hex.  So the\n"
"decimal result would be 10*16^16 = 1.8447e20.\n"
"\f\n"
"Overriding the default number bases                                 p. 3/9\n"
"-----------------------------------\n"
"The default input base can be overridden in typical C fashion for hex:\n"
"0xffee = hex FFEE.  However a preceding \"0\" does NOT convert to octal.\n"
"See below for converting to octal.  To specify any base as an override,\n"
"use \\bxxxxx.xxxExxx where b is a single character representing the base\n"
"('2'-'9', '0'=10, 'A'-'Z'=11-36), x is a digit in the base, and E (or\n"
"\"\\\" for bases greater than 14) is used for scientific notation.\n"
"Example:  \\2101e101 would be 101e101 base 2, having a decimal equivalent\n"
"of 5*2^5=160.  Other special override prefixes:  &h=hex, &b=binary,\n"
"&o=octal, &d=decimal, $=hex.\n"
"To override the default output base, put any base prefix (e.g. 0x, &h)\n"
"with a space after it at the beginning of the expression line.\n"
"\n"
"The \"literal variable\" character\n"
"--------------------------------\n"
"If you are working in a default input base where there may be confusion\n"
"as to whether an input is a variable or a number, use ! in front of the\n"
"input to force the variable value:  E.g. In base 16, A = 10, but\n"
"!A = the value of the variable \"A\".\n"
"\f\n"
"Special Commands                                                    p. 4/9\n"
"----------------\n"
"ibase n   Set the default input base.  n ranges from 2 to 36.\n"
"obase n   Set the default output base.  n ranges from 2 to 36.\n"
"sci       Toggle scientific notation output on/off.\n"
"fix       Toggle fixed precision on/off.\n"
"dplace n  Set the number of digits after the decimal in fixed\n"
"          precision notation.  Ignored in scientific notation.\n"
"sigfig n  Set the number of significant figures to be printed.\n"
"          Use a value less than 1 for maximum accuracy.\n"
"maxexp n  Set the exponent at which output automatically switches\n"
"          to scientific notation format.  Use -1 for no limit.\n"
"help [n]  Display extended help (starting with page n if specified).\n"
"quit      Exit program.\n"
"\n"
"Note:  The argument, n, for the above commands, is always treated as a\n"
"       decimal (base 10) number, regardless of the default input base.\n"
"\f\n"
"Queries (the space after the ? is optional)                         p. 5/9\n"
"-------\n"
"?       Display brief help.\n"
"? ? [n] Display extended help (starting with page n if specified).\n"
"? s     Display status (output type, default bases, etc.)\n"
"? v     Display a list of all currently assigned variables\n"
"? c     Display a list of all pre-assigned constants\n"
"? f     Display a short list of available functions\n"
"? fl    Display a list of available functions with one line descriptions\n"
"? o     Display a list of all operators\n"
"\f\n"
"Scripts                                                             p. 6/9\n"
"-------\n"
"Eval can execute script files (files containing a list of Eval commands,\n"
"one per line).  This is a good way to repeat similar calculations again\n"
"and again.  It can also be used to set up Eval the way you like.\n"
"\n"
"Script commands\n"
"---------------\n"
"<filename    Run a script file\n"
">filename    Write future commands to a script file\n"
">            End writing to a script file\n"
"\n"
"Script files can also be created or edited using any text editor.\n"
"\n"
"Special Characters (primarily for use in script files)\n"
"------------------------------------------------------\n"
";  (comment)   Eval ignores commands that begin with a semi-colon.\n"
"@  (be quiet)  Eval will not print any output if you begin a command with @.\n"
"\f\n"
"The Script Read Path and Write Directory                            p. 7/9\n"
"----------------------------------------\n"
"You can set the directory to which script files will be automatically\n"
"written, and you can specify a path of directories that will automatically\n"
"be searched for scripts.\n"
"\n"
"wdir dirname   Eval sets the default writing directory to dirname.\n"
"               NOTE:  Be sure to include a slash at the end of the dir name.\n"
"Example:  wdir /usr/bin/scripts/  (unix systems)\n"
"\n"
"rpath path     Eval sets the script search path to \"path\".  NOTE:  Separate\n"
"               directories with a ; and end each dir name with a slash.\n"
"Example:  rpath /usr/bin/;/usr/bin/scripts/;../scripts/ (unix systems)\n"
"\n"
"Typing wdir or rpath without arguments will clear them.  In reading\n"
"scripts, the current directory is not always searched first, but it is\n"
"always searched last.  If you desire it to be searched first, explicitly\n"
"set it as the first directory in your read path by beginning your read\n"
"path with a ;.  If opening a script for writing causes an error, the\n"
"write directory is ignored, and an attempt to open the file is repeated.\n"
"Type '?s' to see the status of the write directory and read path.\n"
"\f\n"
"Command line arguments for Eval                                     p. 8/9\n"
"-------------------------------\n"
"You can specify a calculation for Eval directly on the command\n"
"line, and Eval will evaluate it and quit.  Example:\n"
"\n"
"C:\\DOS>Eval 4*5 + 22.5   (MS-DOS example)\n"
"42.5                     (Note:  Unix may require double quotes around\n"
"C:\\DOS>                          the expression.)\n"
"\n"
"If your command executes a script, Eval does not quit.  For example:\n"
"\n"
"C:\\DOS>Eval \"<script.evl\"\n"
"\n"
"This executes the commands in the file \"script.evl\" and continues the\n"
"Eval session when they are completed (unless the script ends with a\n"
"\"quit\" command).  Put a @ in front of the < if you do not want the\n"
"script commands echoed to the terminal as they are executed.\n"
"\n"
"The quotes around the argument in the previous example are necessary on\n"
"many operating systems since the \"<\" character is otherwise interpreted\n"
"as a redirection character by the O/S.\n"
"\f\n"
"License Agreement                                                   p. 9/9\n"
"-----------------\n"
"This program is free software; you can redistribute it and/or modify it\n"
"under the terms of the GNU General Public License as published by the\n"
"Free Software Foundation; either version 2 of the License, or any later\n"
"version.\n"
"\n"
"This program is distributed in the hope that it will be useful, but\n"
"WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
"General Public License for more details.\n"
"\n"
"You should have received a copy of the GNU General Public License along\n"
"with this program; if not, write to the Free Software Foundation, Inc.,\n"
"675 Mass Ave, Cambridge, MA 02139, USA.\n"
"\n"
"The author can be contacted at:\n"
"e-mail:     willus@ilm.pfc.mit.edu (til 9/93)\n"
"U.S. mail:  Will Menninger, 2162 Dudley St., Pasadena, CA 91104 (til 7/94)\n";
