/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 65                         
									      
 Tile Animation!

 This example shows two method of animating tiles within a scrolling window.
 The first technique is to reserve a tile number for the animated tile.
 The pointer contained in the tile array will be changed, so each time the
 screen is drawn a new image represents that tile.  If you look at the 
 anim.spr file, I've set up the first animating tile in positions 1-6.
 The seventh position is the tile I will animate, and is the same image
 as tile 1.  This lets you draw the map using tile 7.  If you use tiles
 1 to 6 on the map, they will not animate under this method.  Since tile
 seven's image pointer is going to change, we have to free the original
 image first.

 The second method cycles a range of image pointers.  This allows you to draw
 using any tile within the range.  
 
 Use the arrow keys to scroll, and ESC quits.
 
									      
 *** PROJECT ***                                                             
 This program requires the files WGT5_WC.LIB and WSCR_WC.LIB to be linked.   
									      
 *** DATA FILES ***                                                          
 ANIM.SPR, ANIM.WMP                                                          
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <wgt5.h>
#include <wgtscrol.h>

#define UP 72
#define DOWN 80
#define LEFT 75
#define RIGHT 77
#define ESC 1
#define WIN 0

short spx, spy;                    /* Speed of scrolling window */
wgtmap animmap;                     /* our world map */
color palette[256];                /* Our palette of colours */
block tiles[100];                  /* Tiles for the map */
block sprites[10];                 /* Our sprites */
scrollsprite wobject[100];         /* Objects in window */
short tiletypes[256];              /* Tile types */

short oldmode;                     /* Previous video mode */


int tile_anim1;                    /* Current tile number in first animation */

void animate_tiles (void)
{
block temp;
int i;

 /* First method */
 /* The first animation sequence is tiles 1 to 6. */
 tile_anim1++;
 if (tile_anim1 > 6)               /* Repeat animation */
     tile_anim1 = 1;
    
 tiles[7] = tiles[tile_anim1];     /* Make it point to the new image */



 /* Second method */
 /* The second animation sequence is tiles 8 to 17. */
 
 temp = tiles[8];  /* Store the pointer to the first tile in the sequence */
 
 for (i = 8; i < 17; i++)          /* Shift all the pointers up one */
  tiles[i] = tiles[i+1];
 
 tiles[17] = temp;                 /* Set the last pointer with the first */
}



void main(void)
{

  oldmode = wgetmode ();
  if (!vgadetected ())
  {
    printf ("VGA is required to run this program...");
    exit (1);
  }

  printf ("WGT Example #65\n\n");
  printf ("Tile Animation!\n");
  printf ("This example shows two method of animating tiles within a scrolling window.\n");
  printf ("The first technique is to reserve a tile number for the animated tile.\n");
  printf ("The pointer contained in the tile array will be changed, so each time the\n");
  printf ("screen is drawn a new image represents that tile.  If you look at the\n");
  printf ("anim.spr file, I've set up the first animating tile in positions 1-6.\n");
  printf ("The seventh position is the tile I will animate, and is the same image\n");
  printf ("as tile 1.  This lets you draw the map using tile 7.  If you use tiles\n");
  printf ("1 to 6 on the map, they will not animate under this method.  Since tile\n");
  printf ("seven's image pointer is going to change, we have to free the original\n");
  printf ("image first.\n");
  printf ("Use the arrow keys to scroll and ESC quits.\n");
  printf ("\nPress any key to begin.\n");
  getch ();

  vga256 ();

  tile_anim1 = 1;
  /* Tile image number 1 */

  /* Load the graphics */
  wloadsprites (palette, "anim.spr", tiles, 0, 99);
  
  wfreeblock (tiles[7]);
  /* Free the first animating tile */

  tiles[7] = tiles[tile_anim1];
  /* Set the image to be the first tile in the animation.  To animate  
     the tile, we just need to change the value of tile_anim1. */

  wsetpalette (0, 255, palette);

  winitscroll (WIN, NORMAL, -1, 10, 10, tiles);
  animmap = wloadmap (WIN, "anim.wmp", tiletypes, wobject);

  wcls (0);

  wshowwindow (WIN, 0, 0);
  
  installkbd ();

  do {
    spx = 0;
    spy = 0;

    animate_tiles ();

    /* check the keyboard */
    if (kbdon[RIGHT])
     spx += 4; 
    else if (kbdon[LEFT])
     spx -= 4; 
    
    if (kbdon[DOWN])
     spy += 4; 
    if (kbdon[UP])
     spy -= 4; 
    
    wscrollwindow (WIN, spx, spy);
    
    wretrace ();
    wputblock (0, 0, scrollblock[0], NORMAL);
  } while (!kbdon[ESC]);                 // until ESC is pressed

  uninstallkbd ();
  wendscroll (WIN);
  wfreesprites (tiles, 0, 99);
  wfreemap (animmap);
  wsetmode (oldmode);
}

