/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 3                          
                                                                              
 Clears the screen with random colours until you hit a key, and times how
 fast the system is at writing to video memory.  It will report the highest
 frame rate possible for copying 64k to the video card.
                                                                              
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.
                                                                              
 *** DATA FILES ***                                                          
 NONE                                                                        
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>

#define TIMERSPEED 60     /* timer_routine is called 60 times per second */
int timer;                /* Counts how many times it has been called */ 
int clearcount;           /* Counts the number of screen clears. */
void timer_routine (void)
{
 timer++;
}


void main(void)
{
  short x;
  short y;
  short oldmode;

  printf ("WGT Example #3\n\n");
  printf ("This program will use the wcls routine to clear the screen\n");
  printf ("using random colors as fast as it can until you press a key.\n");
  printf ("It will then report the highest frame rate possible on your computer.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }

  oldmode = wgetmode();         /* Store current video mode     */
  vga256();                     /* Initialize WGT system        */

  clearcount = 0;
  timer = 0;

  winittimer ();
  wstarttimer (timer_routine, TICKS(TIMERSPEED));

  while (!kbhit())
  {
                          /* Try including wretrace to see the difference */
  //  wretrace ();        /* Wait for VBLANK to prevent "shearing" */
    wcls(rand() % 256); /* Clear with random color out of 256 */
    clearcount++;
  }

  wstoptimer ();
  wdonetimer ();

  getch();
  wsetmode(oldmode);            /* Restore old video mode       */
  printf ("%f frames per second\n", (float)clearcount / ((float)timer 
               / (float)TIMERSPEED));
  printf ("This is the highest frame rate your computer can produce for full screen\n");
  printf ("animation.\n");
}
