/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
gjA(int n)
{
double pbA     [MXR][MXC*TWOCOL];matrix mA      ={MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbInvA  [MXR][MXC*TWOCOL];matrix mInvA   ={MXR,MXC*TWOCOL,&pbInvA[0][0]};
double pbu     [MXR][MXC*TWOCOL];matrix mu      ={MXR,MXC*TWOCOL,&pbu   [0][0]};
double pbuT    [MXR][MXC*TWOCOL];matrix muT     ={MXR,MXC*TWOCOL,&pbuT  [0][0]};
double pbv     [MXR][MXC*TWOCOL];matrix mv      ={MXR,MXC*TWOCOL,&pbv   [0][0]};

                                   n = 3;
                     mA.rows= n;                     mA.cols= n*TWOCOL;
                  mInvA.rows= n;                  mInvA.cols= n*TWOCOL;
                     mu.rows= n;                     mu.cols=   TWOCOL;
                    muT.rows= n;                    muT.cols=   TWOCOL;
                     mv.rows= n;                     mv.cols=   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndorth(&mA,3,2);
    rndmF(&mu,3,2);

  clrscrn();
  printf("   If A is the transition matrix from a basis   \n\n");
  printf("    B' to a basis B. InvA is the transition     \n\n");
  printf("               matrix  from B to B'.            \n\n");
  printf("                                      A :");
  printmF3(&mA);
  printf("                                      u :");
  printmF3(&mu);

  multmF(&mA,&mu, &mv);
  printf("                               v = A u :\n");
  printmF3(&mv);
  getchar();

  clrscrn();
  inverseF(&mA,&mInvA);
  printf("                                mInvA :\n");
  printmF3(    &mInvA);
  printf("                                    v :\n");
  printmF3(&mv);
    multmF(    &mInvA,&mv,&muT);
  printf("                          uT = InvA v :");
  printmF3(&muT);
  printf("                                    u :");
  printmF3(&mu);

 }

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n\n                                          \n");
  printf("   If A is the transition matrix from a basis   \n\n");
  printf("    B' to a basis B. InvA is the transition     \n\n");
  printf("               matrix  from B to B'.              \n");
  printf("               ********************               \n");
  printf("\n\n\n\n\n\n\n                                      ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 3){n=3;}


  gjA(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

