/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
gjA(int n)
{
     int i;
fraction det;
fraction InProd;

double pbA     [MXR][MXC*TWOCOL];matrix mA      ={MXR,MXC*TWOCOL,&pbA     [0][0]};
double pbAcn   [MXR][MXC*TWOCOL];matrix mAcn    ={MXR,MXC*TWOCOL,&pbAcn   [0][0]};
double pbb     [MXR][MXC*TWOCOL];matrix mb      ={MXR,MXC*TWOCOL,&pbb     [0][0]};
double pbAxmnsb[MXR][MXC*TWOCOL];matrix mAxmnsb ={MXR,MXC*TWOCOL,&pbAxmnsb[0][0]};
double pbAx    [MXR][MXC*TWOCOL];matrix mAx     ={MXR,MXC*TWOCOL,&pbAx    [0][0]};
double pTrpsA  [MXR][MXC*TWOCOL];matrix mTrpsA  ={MXR,MXC*TWOCOL,&pTrpsA  [0][0]};
double pTrpsA_A[MXR][MXC*TWOCOL];matrix mTrpsA_A={MXR,MXC*TWOCOL,&pTrpsA_A[0][0]};


                     mA.rows= n;             mA.cols=(n-1)*TWOCOL;
                     mb.rows= n;             mb.cols=      TWOCOL;
                   mAcn.rows= n;           mAcn.cols=      TWOCOL;
                mAxmnsb.rows= n;        mAxmnsb.cols=      TWOCOL;
                    mAx.rows= n;            mAx.cols=      TWOCOL;
                 mTrpsA.rows=(n-1);      mTrpsA.cols= n   *TWOCOL;
               mTrpsA_A.rows=(n-1);    mTrpsA_A.cols=(n-1)*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  do
  {
         rndmF(&mA,3,1);
   transposemF(&mA,&mTrpsA);
        multmF(    &mTrpsA,&mA,&mTrpsA_A);

          det = detF(&mTrpsA_A);
  }while(!det.numer);

  rndmF(&mb,3,2);

  clrscrn();
  printf(" Verify that the error vector Ax - b resulting from\n");
  printf(" the least squares solution x is orthogonal \n");
  printf(" to the column space of A (Acn)\n\n");
  printf("                                                            A :");
  printmF(&mA);
  printf("                                                            b :");
  printmF(&mb);
  getchar();

  orthprojwb(&mA,&mb,&mAx);

  for(i = 0; i < (mA.cols/2); i++)
     {
      clrscrn();
      printf("                                      A :\n");
      printmF(&mA);
      printf("\n                                 Ax - b :\n");
       submF(&mAx,&mb,&mAxmnsb);
     printmF(         &mAxmnsb);
      printf("                                 (Ac%d) :\n",
                       i+1);                                      /* math */
    copycolF(&mA,i,&mAcn,0);
     printmF(      &mAcn);

      InProd = innerprod(      &mAcn,&mAxmnsb);

      printf("\n  (Ax-b).(Ac%d) =  %6.0lf/%-6.0lf\n",
              i+1,                                               /* math */
              InProd.numer,
              InProd.denom);
      getchar();
     }
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.   \n");
  printf("\n\n\n\n\n\n                                         \n");
  printf(" Verify that the error vector Ax - b resulting from  \n");
  printf("     the least squares solution x is orthogonal      \n");
  printf("            to the column space of A.                \n");
  printf("            ************************                 \n");
  printf("\n\n\n\n\n\n\n                                         ");
  printf("\n Distributed  by :  http://www.simtel.net/           ");
  printf("\n                                                     ");
  printf("\n Press return to continue                            ");
  printf("\n                                                     ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 3){n=3;}


  gjA(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

