/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int p
)
{
fraction InnerProduct_uu;

double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};

   mu.rows = n;           mu.cols = p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,3);

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  InnerProduct_uu = innerprod_Mnm(&mu,&mu);
  printf("\n  Properties of inner product in Mnm :  \n");
  printf("\n             (Positivity axiom)          \n");
  printf("\n\n    <U,U>  >=  0              \n\n");
  printf("\n\n    <U,U>   =  %6.0lf/%-6.0lf \n\n\n",
            InnerProduct_uu.numer,
            InnerProduct_uu.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of inner product in Mnm :         \n");
  printf("\n             (Positivity axiom)                 \n");
  printf("\n\n\n                                              ");
  printf("\n                <U,U>  >=  0                      ");
  printf("\n                ************                      ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 3 && atoi(argv[1]) && atoi(argv[2]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;}
  }
else
 {
  n=rndpI(5);
  p=rndpI(5);
 }
   if(n<2){n=2;}
   if(p<2){p=2;}


  AB(n,p);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

