/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction InnerProduct_uv;
fraction InnerProduct_vu;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pbv    [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv    [0][0]};

if     (vectrow)
  {
   mu.rows = 1;           mu.cols = n*TWOCOL;
   mv.rows = 1;           mv.cols = n*TWOCOL;
  }
else if(!vectrow)
   {
    mu.rows = n;           mu.cols = 1*TWOCOL;
    mv.rows = n;           mv.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,3);
  rndmF(&mv,5,3);

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);

  printf("\n  Properties of Euclidian inner product in R**n\n  ");
  printf("\n                u.v  =  v.u                    \n\n");

  InnerProduct_uv = innerprod(&mu,&mv);
  printf("  u.v =  %6.0lf/%-6.0lf\n\n",
            InnerProduct_uv.numer,
            InnerProduct_uv.denom);

  InnerProduct_vu = innerprod(&mv,&mu);
  printf("  v.u =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_vu.numer,
            InnerProduct_vu.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of Euclidian inner product in R**n   ");
  printf("\n                                                  ");
  printf("\n                u.v  =  v.u                       ");
  printf("\n                ***********                       ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 2x1 ... 4x1.                \n");
  printf("\n     ex : \"euinprdaCF.exe\"                    \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"euinprdaCF.exe 2\" -> 4x1             ");
  printf("\n          \"euinprdaCF.exe 4\" -> 4x1           \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}

if( vectrow){vectrow = 0;}
else        {vectrow = 1;}


  AB(n,vectrow);



  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












