/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction Distance_uv;
fraction Distance_uw;
fraction Distance_wv;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pbv    [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv    [0][0]};
double pbw    [MXR][MXC*TWOCOL];matrix mw    ={MXR,MXC*TWOCOL,&pbw    [0][0]};

if     (vectrow)
  {
   mu.rows = 1;           mu.cols = n*TWOCOL;
   mv.rows = 1;           mv.cols = n*TWOCOL;
   mw.rows = 1;           mw.cols = n*TWOCOL;
  }
else if(!vectrow)
   {
    mu.rows = n;           mu.cols = 1*TWOCOL;
    mv.rows = n;           mv.cols = 1*TWOCOL;
    mw.rows = n;           mw.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,3);
  rndmF(&mv,5,3);
  rndmF(&mw,5,3);

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);
  printf("                                 w");
  printmF3(&mw);
  getchar();

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);
  Distance_uv = distanceP2(&mu,&mv);      /* It is the square of the distance.*/
  printf("\n\n d(u,v) =  (%.0lf/%-.0lf)**(1/2)\n\n",
            Distance_uv.numer,
            Distance_uv.denom);
  getchar();

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);
  printf("                                 w");
  printmF3(&mw);
  Distance_uw = distanceP2(&mu,&mw);      /* It is the square of the distance.*/
  printf("\n\n d(u,w) =  (%.0lf/%-.0lf)**(1/2)\n\n",
            Distance_uw.numer,
            Distance_uw.denom);
  Distance_wv = distanceP2(&mw,&mv);      /* It is the square of the distance.*/
  printf(" d(w,v) =  (%.0lf/%-.0lf)**(1/2)\n",
            Distance_wv.numer,
            Distance_wv.denom);
  getchar();


  clrscrn();
  printf("\n         Properties of distance in R**n :\n  ");
  printf("\n           d(u,v) =< d(u,w) + d(w,v)      \n\n");
  printf("  (%.0lf/%-.0lf)**(1/2) =<  ",
                 Distance_uv.numer,
                 Distance_uv.denom);

  printf(" (%.0lf/%-.0lf)**(1/2) + (%.0lf/%-.0lf)**(1/2)\n\n",
                 Distance_uw.numer,
                 Distance_uw.denom,
                 Distance_wv.numer,
                 Distance_wv.denom);

  printf("           %.3lf =<  %.3lf\n\n",
            sqrt(     Distance_uv.numer/     Distance_uv.denom),
            sqrt(Distance_uw.numer/Distance_uw.denom)
            +
            sqrt(Distance_wv.numer/Distance_wv.denom));
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n       Properties of distance in R**n\n           ");
  printf("\n                                                  ");
  printf("\n         d(u,v)  =<  d(u,w) + d(w,v)              ");
  printf("\n         ***************************              ");
  printf("\n\n                                                ");
  printf("\n The size of u, v, w : 2x1 ... 4x1.             \n");
  printf("\n     ex : \"distcdCF.exe\"                      \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"distcdCF.exe 2\" -> 4x1               ");
  printf("\n          \"distcdCF.exe 4\" -> 4x1             \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}

if     ( vectrow){vectrow = 0;}
else if(!vectrow){vectrow = 1;}


  AB(n,vectrow);



  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












