/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n)
{
fraction k;

double pbP    [MXR][MXC*TWOCOL];matrix mP    ={MXR,MXC*TWOCOL,&pbP    [0][0]};
double pbQ    [MXR][MXC*TWOCOL];matrix mQ    ={MXR,MXC*TWOCOL,&pbQ    [0][0]};
double pbPplsQ[MXR][MXC*TWOCOL];matrix mPplsQ={MXR,MXC*TWOCOL,&pbPplsQ[0][0]};
double pbkP   [MXR][MXC*TWOCOL];matrix mkP   ={MXR,MXC*TWOCOL,&pbkP   [0][0]};
double pbkQ   [MXR][MXC*TWOCOL];matrix mkQ   ={MXR,MXC*TWOCOL,&pbkQ   [0][0]};

double pk_PplsQ[MXR][MXC*TWOCOL];matrix mk_PplsQ={MXR,MXC*TWOCOL,&pk_PplsQ[0][0]};
double pkPplskQ[MXR][MXC*TWOCOL];matrix mkPplskQ={MXR,MXC*TWOCOL,&pkPplskQ[0][0]};

double pk_PplsQ_mns_kPplskQ[MXR][MXC*TWOCOL];
matrix mk_PplsQ_mns_kPplskQ={MXR,MXC*TWOCOL,&pk_PplsQ_mns_kPplskQ[0][0]};

           mP.rows = n;                   mP.cols = 1*TWOCOL;
           mQ.rows = n;                   mQ.cols = 1*TWOCOL;
       mPplsQ.rows = n;               mPplsQ.cols = 1*TWOCOL;
          mkP.rows = n;                  mkP.cols = 1*TWOCOL;
          mkQ.rows = n;                  mkQ.cols = 1*TWOCOL;
     mk_PplsQ.rows = n;             mk_PplsQ.cols = 1*TWOCOL;
     mkPplskQ.rows = n;             mkPplskQ.cols = 1*TWOCOL;

     mk_PplsQ_mns_kPplskQ.rows = n;
     mk_PplsQ_mns_kPplskQ.cols = 1*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  k = rndFI(5);

  rndmI(&mP,5);
  rndmI(&mQ,5);

  clrscrn();
  printf("\n          P = ");
  printpolyI(&mP);
  printf("\n          Q = ");
  printpolyI(&mQ);
  printf("\n      P + Q = ");
  addmF(&mP,&mQ,&mPplsQ);
  printpolyI(   &mPplsQ);
  printf("\n   k        = %.0f\n", k.numer);
  printf("\n   k(P + Q) = ");
  smultmF(k,&mPplsQ,&mk_PplsQ);
  printpolyI(         &mk_PplsQ);
  getchar();

  clrscrn();
  printf("\n          kP = ");
  smultmF(k,&mP,&mkP);
  printpolyI(&mkP);
  printf("\n          kQ = ");
  smultmF(k,&mQ,&mkQ);
  printpolyI(&mkQ);
  printf("\n     kP + kQ = ");
  addmF(&mkP,&mkQ,&mkPplskQ);
  printpolyI(       &mkPplskQ);
  getchar();

  clrscrn();
  printf("\n                k(P + Q) = ");
  printpolyI(&mk_PplsQ);
  printf("\n                kP + kQ  = ");
  printpolyI(&mkPplskQ);
  printf("\n  [k(P + Q)] - [kP + kQ] = ");
  submF(&mk_PplsQ,&mkPplskQ,&mk_PplsQ_mns_kPplskQ);
  printpolyI(                 &mk_PplsQ_mns_kPplskQ);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n            Vector space axioms.                  ");
  printf("\n                                                  ");
  printf("\n             k(P + Q) = kP + kQ                   ");
  printf("\n             ******************                   ");
  printf("\n\n\n                                              ");
  printf("\n The degree of P, Q : 2  ... 4.                 \n");
  printf("\n     ex : \"peI.exe\"                           \n");
  printf("\n You can choose the degree :                    \n");
  printf("\n     ex : \"peI.exe 2\"                           ");
  printf("\n          \"peI.exe 4\"                         \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {    n=rndpI(4);}
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












