; This program will dump data (usually stuff just in the header) of ANY file
; that I've created.

; v1.04 : Added LE support

include qlib.inc
include string.inc
include stdio.inc
include dos.inc
include process.inc

.data
  hand dw ?
  header db 3 dup (?)
  filename dd ?
.code
main proc,argc:byte,argv:dword
  callp printf,"File STATS v1.04  by : Peter Quiring\n"
  .if argc!=2
    callp printf,"Usage : STATS (file)        [Supports EXE,LE]\n"
    ret
  .else
    callp printf,"\n"
  .endif
  mov eax,argv
  mov eax,[eax+1*4]  ;1st argument (file name)
  mov filename,eax
  callp open,eax,O_BINARY or O_RDONLY
  .if eax==ERROR
    callp printf,"File not found\n"
    callp exit,0
  .endif
  mov hand,ax
  callp read,hand,offset header,3
  callp lseek,hand,0,SEEK_SET
  callp memcmp,offset header,"LE",2
  .if !eax
    xor edx,edx
    jmp LE_2
  .endif
  callp memcmp,offset header,"MZ",2
  .if !eax
    jmp EXE
  .endif
  callp close,hand
  callp printf,"File type unknown\n"
  ret
done::
  callp close,hand
  ret
main endp

.data
  exe_hdr db 28 dup (?)
.code
EXE:
  callp printf,"EXE format (%s):\n\n",filename
  callp read,hand,offset exe_hdr,sizeof exe_hdr
  callp printf,"Offset    Value           Description\n------------------------------\n"
  callp printf,"  0h(0)   %04Xh(%05d)    Signature (MZ)\n",wptr exe_hdr[0],wptr exe_hdr[0]
  callp printf,"  2h(2)   %04Xh(%05d)    Extra Bytes\n",wptr exe_hdr[2],wptr exe_hdr[2]
  callp printf,"  4h(4)   %04Xh(%05d)    Pages(512 bytes)\n",wptr exe_hdr[4],wptr exe_hdr[4]
  callp printf,"  6h(6)   %04Xh(%05d)    # Reloc Items\n",wptr exe_hdr[6],wptr exe_hdr[6]
  callp printf,"  8h(8)   %04Xh(%05d)    EXE Header size(*16)\n",wptr exe_hdr[8],wptr exe_hdr[8]
  callp printf," 0ah(10)  %04Xh(%05d)    Min alloc(*16)\n",wptr exe_hdr[0ah],wptr exe_hdr[0ah]
  callp printf," 0ch(12)  %04Xh(%05d)    Max alloc(*16)\n",wptr exe_hdr[0ch],wptr exe_hdr[0ch]
  callp printf," 0eh(14)  %04Xh(%05d)    Init SS\n",wptr exe_hdr[0eh],wptr exe_hdr[0eh]
  callp printf," 10h(16)  %04Xh(%05d)    Init SP\n",wptr exe_hdr[10h],wptr exe_hdr[10h]
  callp printf," 12h(18)  %04Xh(%05d)    Check Sum\n",wptr exe_hdr[12h],wptr exe_hdr[12h]
  callp printf," 14h(20)  %04Xh(%05d)    Init IP\n",wptr exe_hdr[14h],wptr exe_hdr[14h]
  callp printf," 16h(22)  %04Xh(%05d)    Init CS\n",wptr exe_hdr[16h],wptr exe_hdr[16h]
  callp printf," 18h(24)  %04Xh(%05d)    Reloc Table Offset\n",wptr exe_hdr[18h],wptr exe_hdr[18h]
  callp printf," 1ah(26)  %04Xh(%05d)    Overlay #\n\n",wptr exe_hdr[1ah],wptr exe_hdr[1ah]

  jmp LE_1

  jmp done

include lefile.inc

EXEs struct
  magic dw ?
  siz1 dw ?
  siz2 dw ?
  reits dw ?
  headsiz dw ?
EXEs ends

.data
  le_hdr LEHeader <>
  EXEd EXEs <>
.code
LE_1:
  callp lseek,hand,0,SEEK_SET
  callp read,hand,offset EXEd,sizeof EXEd

  xor eax,eax
  mov ax,EXEd.siz2
  dec eax
  imul eax,512
  mov edx,eax
  xor eax,eax
  mov ax,EXEd.siz1
  add eax,07h
  and eax,0fff8h
  add edx,eax

  callp lseek,hand,edx,SEEK_SET

  callp read,hand,offset le_hdr,2
  .if wptr le_hdr.LESignature != 'EL'
    jmp done
  .endif

  callp lseek,hand,edx,SEEK_SET

LE_2:

  callp read,hand,offset le_hdr,sizeof le_hdr

  callp printf,"LE format: (%s)\n\n",filename
  callp printf,"  LE image offset = %Xh(%u)\n",edx,edx
  callp printf,"Offset    Value           Description\n------------------------------\n"
  callp printf,"  0h      %06Xh(%08u)    Signature (LE)  \n",dptr le_hdr[0],dptr le_hdr[0]
  callp printf,"  4h      %06Xh(%08u)    LEFormatLevel   \n",dptr le_hdr[4],dptr le_hdr[4]
  callp printf,"  8h      %06Xh(%08u)    LECpuType       \n",wptr le_hdr[8],wptr le_hdr[8]
  callp printf," 0ah      %06Xh(%08u)    LETargetSystem  \n",wptr le_hdr[00ah],wptr le_hdr[00ah]
  callp printf," 0ch      %06Xh(%08u)    LEModuleVersion \n",dptr le_hdr[00ch],dptr le_hdr[00ch]
  callp printf," 10h      %06Xh(%08u)    LEModuleType    \n",dptr le_hdr[010h],dptr le_hdr[010h]
  callp printf," 14h      %06Xh(%08u)    LENumberPages   \n",dptr le_hdr[014h],dptr le_hdr[014h]
  callp printf," 18h      %06Xh(%08u)    LEEntrySection  \n",dptr le_hdr[018h],dptr le_hdr[018h]
  callp printf," 1ch      %06Xh(%08u)    LEEntryOffset   \n",dptr le_hdr[01ch],dptr le_hdr[01ch]
  callp printf," 20h      %06Xh(%08u)    LEStackSection  \n",dptr le_hdr[020h],dptr le_hdr[020h]
  callp printf," 24h      %06Xh(%08u)    LEInitialESP    \n",dptr le_hdr[024h],dptr le_hdr[024h]
  callp printf," 28h      %06Xh(%08u)    LEPageSize      \n",dptr le_hdr[028h],dptr le_hdr[028h]
  callp printf," 2ch      %06Xh(%08u)    LEBytesLastPage \n",dptr le_hdr[02ch],dptr le_hdr[02ch]
  callp printf," 30h      %06Xh(%08u)    LEFixupSize     \n",dptr le_hdr[030h],dptr le_hdr[030h]
  callp printf," 34h      %06Xh(%08u)    LEFixupChecks   \n",dptr le_hdr[034h],dptr le_hdr[034h]
  callp printf," 38h      %06Xh(%08u)    LELoaderSize    \n",dptr le_hdr[038h],dptr le_hdr[038h]
  callp printf," 3ch      %06Xh(%08u)    LELoaderChecks  \n",dptr le_hdr[03ch],dptr le_hdr[03ch]
  callp printf," 40h      %06Xh(%08u)    LEObjectTable   \n",dptr le_hdr[040h],dptr le_hdr[040h]
  callp printf," 44h      %06Xh(%08u)    LEObjectEntries \n",dptr le_hdr[044h],dptr le_hdr[044h]
  callp printf," 48h      %06Xh(%08u)    LEObjectPMTable \n",dptr le_hdr[048h],dptr le_hdr[048h]
  callp printf," 4ch      %06Xh(%08u)    LEIterateData   \n",dptr le_hdr[04ch],dptr le_hdr[04ch]
  callp printf," 50h      %06Xh(%08u)    LEResourceTable \n",dptr le_hdr[050h],dptr le_hdr[050h]
  callp printf," 54h      %06Xh(%08u)    LEResources     \n",dptr le_hdr[054h],dptr le_hdr[054h]
  callp printf," 58h      %06Xh(%08u)    LEResNamesTable \n",dptr le_hdr[058h],dptr le_hdr[058h]
  callp printf," 5ch      %06Xh(%08u)    LEEntryTable    \n",dptr le_hdr[05ch],dptr le_hdr[05ch]
  callp printf," 60h      %06Xh(%08u)    LEModuleDirTab  \n",dptr le_hdr[060h],dptr le_hdr[060h]
  callp printf," 64h      %06Xh(%08u)    LEModuleDirs    \n",dptr le_hdr[064h],dptr le_hdr[064h]
  callp printf," 68h      %06Xh(%08u)    LEFixupPageTab  \n",dptr le_hdr[068h],dptr le_hdr[068h]
  callp printf," 6ch      %06Xh(%08u)    LEFixupRecords  \n",dptr le_hdr[06ch],dptr le_hdr[06ch]
  callp printf," 70h      %06Xh(%08u)    LEImportModuleTable\n",dptr le_hdr[070h],dptr le_hdr[070h]
  callp printf," 74h      %06Xh(%08u)    LEImportModuleEntries\n",dptr le_hdr[074h],dptr le_hdr[074h]
  callp printf," 78h      %06Xh(%08u)    LEImportProcTable\n",dptr le_hdr[078h],dptr le_hdr[078h]
  callp printf," 7ch      %06Xh(%08u)    LEPPchecksumTab \n",dptr le_hdr[07ch],dptr le_hdr[07ch]
  callp printf," 80h      %06Xh(%08u)    LEDataPages     \n",dptr le_hdr[080h],dptr le_hdr[080h]
  callp printf," 84h      %06Xh(%08u)    LEPreloadPages  \n",dptr le_hdr[084h],dptr le_hdr[084h]
  callp printf," 88h      %06Xh(%08u)    LENonResNamesTab\n",dptr le_hdr[088h],dptr le_hdr[088h]
  callp printf," 8ch      %06Xh(%08u)    LENonResNamesEntries\n",dptr le_hdr[08ch],dptr le_hdr[08ch]
  callp printf," 90h      %06Xh(%08u)    LENonResNameschecksum\n",dptr le_hdr[090h],dptr le_hdr[090h]
  callp printf," 94h      %06Xh(%08u)    LEAutoData      \n",dptr le_hdr[094h],dptr le_hdr[094h]
  callp printf," 98h      %06Xh(%08u)    LEDebugStart    \n",dptr le_hdr[098h],dptr le_hdr[098h]
  callp printf," 9ch      %06Xh(%08u)    LEDebugSize     \n",dptr le_hdr[09ch],dptr le_hdr[09ch]
  callp printf,"0a0h      %06Xh(%08u)    LEPrelInstPages \n",dptr le_hdr[0a0h],dptr le_hdr[0a0h]
  callp printf,"0a4h      %06Xh(%08u)    LEDemdInstPages \n",dptr le_hdr[0a4h],dptr le_hdr[0a4h]
  callp printf,"0a8h      %06Xh(%08u)    LEExtraHeap     \n",dptr le_hdr[0a8h],dptr le_hdr[0a8h]  
  jmp done

end


