#include <qlib.h>  //QLIB only
#include <stdio.h>
#include <stdlib.h>

#include <crc.h>   //QLIB only

byte data[1024];

void calc_crc(int typ,int nb, dword bsiz, word flg1, word flg2, dword poly) {
  word a;
  void *crctable;
  word flgs= flg1 | flg2;
  dword crc=0;
     //init. CRC value  (changing this does not effect CRC effectiveness)
  dword boff=(dword)&data;

  switch (typ) {
    case 32:
      crctable=CRC32init(poly,flg1);
      if (crctable==(void *)ERROR) {
        printf("Not enough memory for CRC table!\n");
        exit(0);
      }
      for (a=0;a<nb;a++) {
        crc=CRC32(crc,crctable,(void *)boff,bsiz,flgs);
        boff+=bsiz;
      }
      printf("  CRC32 = %#010x\n",crc);
      break;
    case 16:
      crctable=CRC16init(poly,flg1);
      if (crctable==(void*)ERROR) {
        printf("Not enough memory for CRC table!\n");
        exit(0);
      }
      for (a=0;a<nb;a++) {
        crc=CRC16(crc,crctable,(void *)boff,bsiz,flgs);
        boff+=bsiz;
      }
      printf("  CRC16 = %#06x\n",crc);
      break;
  }
}

void main(void) {
  word a;
  byte *p=(byte *)&data;

  randomize();
  clrscr();

  //setup data[] with random data
  for (a=0;a<256;a++) *(p++)=rand() & 0xf;
  for (a=0;a<256;a++) *(p++)=rand() & 0xf0;
  for (a=0;a<256;a++) *(p++)=rand() & 0xf00;
  for (a=0;a<256;a++) *(p++)=rand() & 0xf000;

  printf("CRC16/32 Test program\n\n");

  //calc CRC32 of data[] in different methods and with different block sizing
  printf("Shift = Normal, Method #1\n");
  calc_crc(32,4,256  , CRC_SHIFT_NORM , CRC_METHOD1 , CRC_POLY_ZMODEM32);
  calc_crc(32,2,512  , CRC_SHIFT_NORM , CRC_METHOD1 , CRC_POLY_ZMODEM32);
  calc_crc(32,1,1024 , CRC_SHIFT_NORM , CRC_METHOD1 , CRC_POLY_ZMODEM32);

  //CRC16
  printf("Shift = Reversed, Method #1\n");
  calc_crc(16,2,512  , CRC_SHIFT_REV , CRC_METHOD1 , CRC_POLY_KERMIT);
  calc_crc(16,1,1024 , CRC_SHIFT_REV , CRC_METHOD1 , CRC_POLY_KERMIT);

  printf("Shift = Reversed, Method #2\n");
  calc_crc(16,2,512  , CRC_SHIFT_REV , CRC_METHOD2 , CRC_POLY_XYZMODEM);
  calc_crc(16,1,1024 , CRC_SHIFT_REV , CRC_METHOD2 , CRC_POLY_XYZMODEM);

  printf("Shift = Normal, Method #2\n");
  calc_crc(16,2,512  , CRC_SHIFT_NORM , CRC_METHOD2 , 0x1671);
  calc_crc(16,1,1024 , CRC_SHIFT_NORM , CRC_METHOD2 , 0x1671);
}
