/*  NJCARD.C - a demonstration program to show how to use NJSDK.
 *
 *  Copyright (C) Hongbo Ni 1992-1993. All Rights Reserved.
 *
 *  Last modified: 22:45:37 Sun  03-21-1993
 *------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <math.h>
#include <malloc.h>
#include <process.h>

#include "njsdk.h"
#include "keys.h"


int msgdialog(int, int s);
#define MAXDLOG 21
#define MAXNO   10
struct DIALOG_S dlog[MAXDLOG]={
/*  R  C  L T R    str  msg */
  { 3,8,51,0,0,   "","ĺӢģ"},
  { 4,8,51,0,0,   "","빫˾"},
  { 5,8,51,0,0,   "","ֺŻ"},
  { 6,8,51,0,0,   "","ݣʡ"},
  { 7,8,51,0,0,   "",""},
  { 9,8,51,0,0,   "","ַ (EMAIL ADDRESS)"},
  {10,8,51,0,0,   "","봫"},
  {11,8,51,0,0,   "","绰"},
  {13,8,51,0,0,   "","뱸¼"},
  {14,8,51,0,0,   "","뱸¼"},
  {15,8,51,0,0,   "","뱸¼"},

  {17,2, 6, -2,1,  "ʾ","ʾʾ"},
  {1,65,10,-1,1,   "һ¼","鿴һ¼"},
  {3,65,10,-1,1,   "һ¼","鿴һ¼"},
  {5,65,10,-1,1,   "","Ҽ¼"},
  {7,65,10,-1,1,   "Ӽ¼","Ӽ¼"},
  {9 ,65,10,-1,1,  "ɾ¼","ɾǰ¼"},
  {11,65,10,-1,1,  "Զ"," MODEM 绰"},
  {13,65,10,-1,1,  "ȡĶ","ǰ¼ĸĶ"},
  {15,65,10,-1,1,  "˳","м¼̲˳"},
  {17,65,10,-1,1,  "ӡǩ","ӡǰм¼ʼıǩ"}
};
char *ver={"C"};
int msgline(char *msg);
char *timedate(char *str);
struct NJVIDEO V;

int myautosave();
main(int argc, char **argv)
{
    char str[80],i,j,k;

    ReadDatabase();
    NJ_init(argv[0]);
    NJ_AutoSave(myautosave);
    NJ_getvideo(&V);

    i = dialog();
    NJ_end();
    if(i>=0){
       WriteDataBase();
    }
    exit(0);
}
int dialog()
{
       NJ_window(0, 0, 19*V.PixelsPerRow, 80, 1);
       NJ_window(0, 62,19*V.PixelsPerRow, 18, 7);
       paint();
       NJ_dialog( 15, 1, 14,3, 0,7, dlog, MAXDLOG, 0,  msgdialog, msgline);
}

int paint()
{
    NJ_puts("  ǡ ͨ Ѷ ¼",1,20,15,1);
    NJ_puts("", 3, 2, 11, 1);
    NJ_puts("˾", 4, 2, 11, 1);
    NJ_puts("ַ", 5, 2, 11, 1);
    NJ_puts("EMAIL:", 9, 2, 11, 1);
    NJ_puts("棺",10, 2, 11, 1);
    NJ_puts("绰",11, 2, 11, 1);
    NJ_puts("ע",13, 2, 11, 1);
    if(V.Nrows>20){
       NJ_window(19*V.PixelsPerRow+8,0, 4*V.PixelsPerRow, 80, 8);
       NJ_puts("ϲʹáϼǡͨѶ¼ US$19 ֧߼",21, 10, 10, 8);
       NJ_puts("Copyright (c) Hongbo Ni, P.O. Box 40, Epping NSW 2121, AUSTRALIA",22, 8, 10, 8);
    }
}
static oi=0;
int msgline(char *msg)
{
    int i = strlen(msg);

    NJ_clscolum(17,(64-oi)/2,oi,1);
    if(dlog[MAXDLOG-10].radio){
       oi = i;
       i = (64-i)/2;
       NJ_puts(msg,17,i,14,4);
    }
}

/* Process the dialog messages */
int msgdialog(int key, int s)
{
    int r=1;
    if(key==-1){    /* Initialise dialog Box */
       GetCurrent();
    }else if(key==0){    /* a Button is pressed */
       if(s==MAXDLOG-3){        /* Undo Editing */
          UndoEditing();
       }else{
          KeepCurrent();
          if(s==MAXDLOG-1) { /* Print */
             PrintRecord();
          }else if(s==MAXDLOG-2) { /* Save and Quit */
             SaveRecord();
             r=0;
          }else if(s==MAXDLOG-4) { /* Call */
             PhoneCall();
          }else if(s==MAXDLOG-5) { /* Delete Record */
             DelRecord();
          }else if(s==MAXDLOG-6) { /* Add Record */
             AddRecord();
          }else if(s==MAXDLOG-7) { /* Search */
             SearchRecord();
          }else if(s==MAXDLOG-8) { /* Next Record */
             NextRecord();
          }else if(s==MAXDLOG-9) { /* Previous Rec */
             PrevRecord();
          }else r=2;
       }
    }else{                /* a Key is pressed */
       if(key==PGUP){
          KeepCurrent();
          if(PrevRecord()<0) r=2;
       }else if(key==PGDN){
          KeepCurrent();
          if(NextRecord()<0) return(2);
       }else if(key==CTRL_HOME){
          KeepCurrent();
          FirstRecord();
       }else if(key==CTRL_END){
          KeepCurrent();
          LastRecord();
       }else r=2;
       msgline("\0");
    }
    DisplayCount();
    return(r);
}
/*------------------------------------------------------------------------*/
/* Simple In Memory Address Database Management                                    */
/*                                                                        */
/* Following codes are nothing to do with NJSDK, just to show how a       */
/* Database can be interfaced with NJSDK.                                 */
/*------------------------------------------------------------------------*/
struct Record {
    uchar name[51];
    uchar company[51];
    uchar address1[51];
    uchar address2[51];
    uchar address3[51];
    uchar email[51];
    uchar phone[51];
    uchar fax[51];
    uchar comment1[51];
    uchar comment2[51];
    uchar comment3[51];
    struct Record *next;
    struct Record *prev;
};
struct Record R, *root=NULL, *Rptr, *TmpRec;
int TotalRecord=0;
char str2[80];
int DisplayCount()
{
    int c=0;
    TmpRec=root;
    while(TmpRec!=NULL){
        c++;
        if(TmpRec==Rptr) break;
        TmpRec=TmpRec->next;
    }
    sprintf(str2,"%3d/%-3d",c,TotalRecord);
    NJ_puts(str2,2,53,14,1);
}
int Add(struct Record *record)
{
    struct Record *r;
    r = (struct Record *)malloc(sizeof(struct Record));
    if(r==NULL){
        msgline("¼̫࣬ڴ治");
        return(0);
    }
    memmove(r, record, sizeof(struct Record));
    if(root==NULL){
        root=r;
        r->next=r->prev=NULL;
    }else if(r->name[0]==0){
        Rptr = root;
        while(Rptr->next!=NULL){
           Rptr=Rptr->next;
        }
        Rptr->next = r;
        r->prev = Rptr;
        r->next = NULL;
    }else{
        TmpRec= root;
        while(TmpRec->next!=NULL){   /* add the new record in GB order */
            if(strcmp(r->name, TmpRec->name)<0) break;
            TmpRec=TmpRec->next;
        }
        if(strcmp(r->name, TmpRec->name)<0 ){
          (TmpRec->prev)->next = r;
          r->prev = TmpRec->prev;
          r->next = TmpRec;
          TmpRec->prev = r;
          if(TmpRec==root) root=r;
        }else{
          TmpRec->next = r;
          r->prev = TmpRec;
          r->next = NULL;
        }

    }
    Rptr = r;
    TotalRecord++;

}
int Del(struct Record *r)
{
    if(r==NULL || root==NULL || (r->next==NULL && r->prev==NULL))
       return(0);
    else if(r==root) {
       if(r->next==NULL) Rptr=root=NULL;
       else Rptr=root=root->next;
    }else if(r->next==NULL){
       Rptr=r->prev;
       Rptr->next=NULL;
    }else{
        Rptr=r->next;
        (r->prev)->next = Rptr;
        Rptr->prev = r->prev;
    }
    free(r);
    TotalRecord--;

}
FILE *fp;
int readstr(char *str)
{
    int c;
    char *p1,*p2;
    while((c=fgetc(fp))!='"' && !feof(fp));
    if(feof(fp)) return(-1);
    p1=str;
    while((c=fgetc(fp))!='"'){
        *p1++ = c;
    };
    *p1=0;
    return(0);
}
int ReadDatabase()
{
    int i,j=0;
    uchar *p;

    fp=fopen("NJCARD.DBS","r");
    if(fp!=NULL){
       do{
          i  = readstr(R.name);
          i += readstr(R.company);
          i += readstr(R.address1);
          i += readstr(R.address2);
          i += readstr(R.address3);
          i += readstr(R.email);
          i += readstr(R.fax);
          i += readstr(R.phone);
          i += readstr(R.comment1);
          i += readstr(R.comment2);
          i += readstr(R.comment3);

          if(feof(fp)) break;
          if(i>=0) Add(&R);
       }while(1);
       fclose(fp);
    }else AddRecord();
}
int WriteDataBase()
{
    int i,j=0;
    uchar *p;
    FILE *fgb;

    fp=fopen("NJCARD.DBS","w");
    fgb=fopen("NJCARD.GB","w");
    if(fp!=NULL){
       TmpRec=root;
       fprintf(fgb,"                ǡ ͨ Ѷ ¼\n\n");
       while(TmpRec!=NULL){
          fprintf(fgb," %s\n",TmpRec->name);
          fprintf(fgb,"˾ %s\n",TmpRec->company);
          fprintf(fgb,"ַ %s\n",TmpRec->address1);
          fprintf(fgb,"       %s\n",TmpRec->address2);
          fprintf(fgb,"       %s\n",TmpRec->address3);
          fprintf(fgb,"EMAIL: %s\n",TmpRec->email);
          fprintf(fgb,"棺 %s\n",TmpRec->fax);
          fprintf(fgb,"绰 %s\n",TmpRec->phone);
          fprintf(fgb,"ע %s\n",TmpRec->comment1);
          fprintf(fgb,"       %s\n\n",TmpRec->comment2);
          fprintf(fgb,"       %s\n\n",TmpRec->comment3);

          fprintf(fp,"\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"\n",
           TmpRec->name, TmpRec->company, TmpRec->address1, TmpRec->address2,
           TmpRec->address3,TmpRec->email,TmpRec->fax, TmpRec->phone,
           TmpRec->comment1, TmpRec->comment2,TmpRec->comment3);
           TmpRec=TmpRec->next;
       }
       fclose(fp);
       fclose(fgb);
    }

}

int myautosave()
{
    msgline("Autosaving DataBase...");
    WriteDataBase();
    msgline("\0");
    /* do something here */
}

int UndoEditing()
{
    GetCurrent();
    msgline("\0");
}
int SaveRecord()
{
    WriteDataBase();
}
char Name[51]="\0";
int SearchRecord()
{
    int found=0;
    char s2[80];

    TmpRec=Rptr;
    if(NJ_gets(Name,3,8,51,15,0)<0) return(0);
    while(TmpRec->next!=NULL){
        TmpRec=TmpRec->next;
        if(strstr(TmpRec->name,Name)!=NULL) {found=1; break;}
    }
    if(!found){
        TmpRec=root;
        do{
            if(strstr(TmpRec->name,Name)!=NULL) {found=1; break;}
            if(TmpRec==Rptr) break;
            TmpRec=TmpRec->next;
        }while(1);
    }
    if(found){
       Rptr=TmpRec;
       GetCurrent();
       msgline("\0");
    }else{
       sprintf(s2,"Ҳˣ%s",Name);
       msgline(s2);
    }
    return(0);

}
int NextRecord()
{
    if(Rptr->next!=NULL){
       Rptr = Rptr->next;
       GetCurrent();
       return(0);
    }else return(-1);
}
int PrevRecord()
{
    if(Rptr->prev!=NULL){
       Rptr = Rptr->prev;
       GetCurrent();
       return(0);
    }else return(-1);
}
int FirstRecord()
{
    Rptr = root      ;
    GetCurrent();
    return(0);
}
int LastRecord()
{
    Rptr = root      ;
    while(Rptr->next!=NULL){
        Rptr=Rptr->next;
    }
    GetCurrent();
    return(0);
}
int AddRecord()
{
    strcpy(dlog[0].str,"\0");
    strcpy(dlog[1].str,"\0");
    strcpy(dlog[2].str,"\0");
    strcpy(dlog[3].str,"\0");
    strcpy(dlog[4].str,"\0");
    strcpy(dlog[5].str,"\0");
    strcpy(dlog[6].str,"\0");
    strcpy(dlog[7].str,"\0");
    strcpy(dlog[8].str,"\0");
    strcpy(dlog[9].str,"\0");
    strcpy(dlog[10].str,"\0");

    strcpy(R.name,     "\0");
    strcpy(R.company,  "\0");
    strcpy(R.address1, "\0");
    strcpy(R.address2, "\0");
    strcpy(R.address3, "\0");
    strcpy(R.email,    "\0");
    strcpy(R.fax,      "\0");
    strcpy(R.phone,    "\0");
    strcpy(R.comment1, "\0");
    strcpy(R.comment2, "\0");
    strcpy(R.comment3, "\0");
    Add(&R);

}
int DelRecord()
{
    int i;
    msgline("ɾǰ¼ -- ϶(Yes/No)?");
    i=NJ_getkey();
    if(i=='Y' || i=='y'){
       Del(Rptr);
       GetCurrent();
    }
    msgline("\0");
}
int GetCurrent()
{
    strcpy(dlog[0].str,Rptr->name);
    strcpy(dlog[1].str,Rptr->company);
    strcpy(dlog[2].str,Rptr->address1);
    strcpy(dlog[3].str,Rptr->address2);
    strcpy(dlog[4].str,Rptr->address3);
    strcpy(dlog[5].str,Rptr->email);
    strcpy(dlog[6].str,Rptr->fax);
    strcpy(dlog[7].str,Rptr->phone);
    strcpy(dlog[8].str,Rptr->comment1);
    strcpy(dlog[9].str,Rptr->comment2);
    strcpy(dlog[10].str,Rptr->comment3);

}
int KeepCurrent()
{
    strcpy(Rptr->name,     dlog[0].str);
    strcpy(Rptr->company,  dlog[1].str);
    strcpy(Rptr->address1, dlog[2].str);
    strcpy(Rptr->address2, dlog[3].str);
    strcpy(Rptr->address3, dlog[4].str);
    strcpy(Rptr->email,    dlog[5].str);
    strcpy(Rptr->fax,      dlog[6].str);
    strcpy(Rptr->phone,    dlog[7].str);
    strcpy(Rptr->comment1, dlog[8].str);
    strcpy(Rptr->comment2, dlog[9].str);
    strcpy(Rptr->comment3, dlog[10].str);
}

static char Date[20];
char *getdate()
{
    union REGS r;
    r.h.ah = 0x2A;
    int86(0x21, &r, &r);
    sprintf(Date,"%02d/%02d/%d", r.h.dl, r.h.dh, r.x.cx);
    return (Date);
}
/*=====================================================================*/
int ComPort=1;
char prefix[15]={""}, comport[5]={"1"};
int PhoneCall()
{
    NJ_puts("Prefix:", 12, 8, 15,1);
    if(NJ_gets0(prefix,12,16,15,15,0)<0) {NJ_clscolum(12,8,52,1); return(0);}

    NJ_puts("COM Port:", 12, 35, 15,1);
    if(NJ_gets0(comport,12,45,5,15,0)<0) {NJ_clscolum(12,8,52,1); return(0);}
    ComPort= atoi(comport)-1;

    NJ_clscolum(12,8,52,1);

    sprintf(str2,"atdt%s-%s\r\n",prefix,dlog[7].str);
    serial_init();
    com_puts(str2);
    sprintf(str2,"Dialing: %s-%s",prefix, dlog[7].str);
    msgline(str2);
    mydelay(100);
    sprintf(str2,"绰...");
    msgline(str2);
    NJ_getkey();
    com_puts("\r\n");
    msgline("\0");
}
int PrintRecord()
{
    int k,i=1;
    char str[80];
    do{
       k = msg("ӡΧ 1-ȫ   2-ǰ¼   X-ȡӡ  ",1);
    }while(k!='1' && k!='2' && k!='X');
    if(k=='X' ) return(-1);
    if(NJ_prt_init()<0) return(-1);
    NJ_setmargin(0,10,0,0,6);

    KeepCurrent();
    if(k=='2' || k=='C') TmpRec = Rptr;
    else TmpRec=root;
    while(TmpRec!=NULL){
       sprintf(str,"                         #%03d",i++);
       NJ_prts(str);
       NJ_prts(TmpRec->name);
       NJ_prts(TmpRec->company);
       NJ_prts(TmpRec->address1);
       NJ_prts(TmpRec->address2);
       NJ_prts(TmpRec->address3);
       NJ_prts(" ");
       NJ_prts(" ");
       NJ_prts(" ");
       if(k=='2' || k=='C') break;
       TmpRec=TmpRec->next;
    }
    NJ_prt_end();
}
int serial_init()
{
    union REGS r;
    r.h.ah = 0;
    r.h.al = 0xe3; /*0x93=2400,8,N,1    0xe3=9600 */
    r.x.dx = ComPort;
    int86(0x14,&r,&r);
    return (r.h.ah);
}
int com_puts(char *str)
{
    while(*str){
        com_putc(*str++);
    }
}
int com_putc(int c)
{
    union REGS r;
    int i;

    do{
       i=com_status();
       kbhit();
       if(i&0x80)
       msgline("Time out error detected in serial port");
    }while(!(i&0x20));
    r.h.ah = 1;
    r.h.al = c;
    r.x.dx = ComPort;
    int86(0x14,&r,&r);
    return (r.h.ah);
}
int com_status()
{
    union REGS r;
    r.h.ah = 3;
    r.x.dx = ComPort;
    int86(0x14,&r,&r);
    return (r.h.ah);
}
/*------------------------------------------------------------------------*/
