/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
detTrpos(
int n)
{
fraction det;

double pbA    [MXR][MXC*TWOCOL];matrix mA     ={MXR,MXC*TWOCOL,&pbA     [0][0]};
double pTrposA[MXR][MXC*TWOCOL];matrix mTrposA={MXR,MXC*TWOCOL,&pTrposA [0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                mTrposA.rows=n;              mTrposA.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mA,5,2);

  clrscrn();
  printf("                                                       A :");
  printmF3(&mA);

  transposemF(&mA, &mTrposA);
  printf("                                                Trpos(A) :");
  printmF3(&mTrposA);

  det = detF(&mA);
  printf("\n      det(A) = %.0f/%.0f\n\n",det.numer, det.denom);

  det = detF(&mTrposA);
  printf("\n det(TrposA) = %.0f/%.0f\n\n",det.numer, det.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n                det(A) = det(TrposA)              ");
  printf("\n                ********************              ");
  printf("\n                                                  ");
  printf("\n The size of mA : 1x1 ... 6x6.                  \n");
  printf("\n     ex : \"dtrposf.exe\"                       \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"dtrposf.exe 2 \" -> 2x2               ");
  printf("\n          \"dtrposf.exe 3 \" -> 3x3               ");
  printf("\n          \"dtrposf.exe 4 \" -> 4x4               ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();

do
{

if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {  n = rndpI(5);}
if( n < 1){n=1;}


  detTrpos(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












