/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 5
#define mxc 5

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
AplsB_BplsA(int n)
{
double pbA       [mxr][mxc*TWOCOL];matrix mA        ={mxr,mxc*TWOCOL,&pbA       [0][0]};
double pbB       [mxr][mxc*TWOCOL];matrix mB        ={mxr,mxc*TWOCOL,&pbB       [0][0]};
double pbAplsB   [mxr][mxc*TWOCOL];matrix mAplsB    ={mxr,mxc*TWOCOL,&pbAplsB   [0][0]};
double pbAplsB_p2[mxr][mxc*TWOCOL];matrix mAplsB_p2 ={mxr,mxc*TWOCOL,&pbAplsB_p2[0][0]};
double pbA_p2    [mxr][mxc*TWOCOL];matrix mA_p2     ={mxr,mxc*TWOCOL,&pbA_p2    [0][0]};
double pbB_p2    [mxr][mxc*TWOCOL];matrix mB_p2     ={mxr,mxc*TWOCOL,&pbB_p2    [0][0]};
double pbAB      [mxr][mxc*TWOCOL];matrix mAB       ={mxr,mxc*TWOCOL,&pbAB      [0][0]};
double pbBA      [mxr][mxc*TWOCOL];matrix mBA       ={mxr,mxc*TWOCOL,&pbBA      [0][0]};
double pbT1      [mxr][mxc*TWOCOL];matrix mT1       ={mxr,mxc*TWOCOL,&pbT1      [0][0]};
double pbT2      [mxr][mxc*TWOCOL];matrix mT2       ={mxr,mxc*TWOCOL,&pbT2      [0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                     mB.rows=n;                   mB.cols=n*TWOCOL;
                 mAplsB.rows=n;               mAplsB.cols=n*TWOCOL;
              mAplsB_p2.rows=n;            mAplsB_p2.cols=n*TWOCOL;
                  mA_p2.rows=n;                mA_p2.cols=n*TWOCOL;
                  mB_p2.rows=n;                mB_p2.cols=n*TWOCOL;
                    mAB.rows=n;                  mAB.cols=n*TWOCOL;
                    mBA.rows=n;                  mBA.cols=n*TWOCOL;
                    mT1.rows=n;                  mT1.cols=n*TWOCOL;
                    mT2.rows=n;                  mT2.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  randmI(&mA, 9);
  randmI(&mB, 9);

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                     A+B :\n");
  addmF(&mA, &mB, &mAplsB);
  printmI(       &mAplsB);
  getchar();

  clrscrn();
  printf("                                                 A+B     :\n");
  printmI(       &mAplsB);
  printf("                                                (A+B)**2 :\n");
  multmF(&mAplsB,&mAplsB,&mAplsB_p2);
  printmI(               &mAplsB_p2);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                    A**2 :\n");
  multmF(&mA,&mA,&mA_p2);
  printmI(       &mA_p2);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                      AB :\n");
  multmF(&mA,&mB,&mAB);
  printmI(       &mAB);
  getchar();

  clrscrn();
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                       A :");
  printmI(&mA);
  printf("                                                      BA :\n");
  multmF(&mB,&mA,&mBA);
  printmI(       &mBA);
  getchar();

  clrscrn();
  printf("                                                       B :");
  printmI(&mB);
  printf("                                                    B**2 :\n");
  multmF(&mB,&mB,&mB_p2);
  printmI(       &mB_p2);
  getchar();

  clrscrn();
  printf("                                        A**2+AB+BA+B**2  :\n");
  addmF(&mA_p2,&mAB,&mT1);
  addmF(&mBA,  &mT1,&mT2);
  addmF(&mB_p2,&mT2,&mT1);
  printmI(          &mT1);
  printf("\n                                                (A+B)**2 :\n");
  printmI(               &mAplsB_p2);
  printf("\n                            (A+B)**2 - (A**2+AB+BA+B**2) :\n");
  submF(&mT1,&mAplsB_p2,&mT2);
  printmI(              &mT2);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n          (A+B)**2 = A**2+AB+BA+B**2              ");
  printf("\n          **************************            \n");
  printf("\n The size of mA, mB      : 1x1 ... 4x4.         \n");
  printf("\n     ex : \"idmai.exe\"                         \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"idmai.exe 2\" -> 2x2                  ");
  printf("\n          \"idmai.exe 1\" -> 1x1                  ");
  printf("\n          \"idmai.exe 4\" -> 4x4                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

  srand(time(&t));
  hello();

do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]);

  if( n > mxr){n=mxr;}
 }
else
 {
  n = (int) fabs(randF(mxr));
 }

    if( n < 1){n=1;}

  AplsB_BplsA(n);

  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}












