/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 4
#define mxc 4

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invB(int n)
{
int x;

double pb       [mxr][mxc*TWOCOL]; matrix m       ={mxr,mxc*TWOCOL,&pb       [0][0]};
double pbTrps   [mxr][mxc*TWOCOL]; matrix mTrps   ={mxr,mxc*TWOCOL,&pbTrps   [0][0]};
double pinvTrps [mxr][mxc*TWOCOL]; matrix minvTrps={mxr,mxc*TWOCOL,&pinvTrps [0][0]};
double pbinv    [mxr][mxc*TWOCOL]; matrix minv    ={mxr,mxc*TWOCOL,&pbinv    [0][0]};
double pbTrpsinv[mxr][mxc*TWOCOL]; matrix mTrpsinv={mxr,mxc*TWOCOL,&pbTrpsinv[0][0]};
double pbAID    [mxr][mxr*2*TWOCOL]; matrix mAID  ={mxr,mxc*2*TWOCOL,&pbAID  [0][0]};
double pbAIDT   [mxr][mxr*2*TWOCOL]; matrix mAIDT ={mxr,mxc*2*TWOCOL,&pbAIDT [0][0]};
double pbT      [mxr][mxc*TWOCOL]; matrix mT      ={mxr,mxc*TWOCOL,&pbT      [0][0]};
double pbT2     [mxr][mxc*TWOCOL]; matrix mT2     ={mxr,mxc*TWOCOL,&pbT2     [0][0]};
double pbT3     [mxr][mxc*TWOCOL]; matrix mT3     ={mxr,mxc*TWOCOL,&pbT3     [0][0]};
double pbT4     [mxr][mxc*TWOCOL]; matrix mT4     ={mxr,mxc*TWOCOL,&pbT4     [0][0]};
double pbID     [mxr][mxc*TWOCOL]; matrix mID     ={mxr,mxc*TWOCOL,&pbID     [0][0]};
double pbIDT1   [mxr][mxc*TWOCOL]; matrix mIDT1   ={mxr,mxc*TWOCOL,&pbIDT1   [0][0]};
double pbIDT2   [mxr][mxc*TWOCOL]; matrix mIDT2   ={mxr,mxc*TWOCOL,&pbIDT2   [0][0]};

double pinvTrps_mns_Trpsinv   [mxr][mxc*TWOCOL];
matrix minvTrps_mns_Trpsinv  ={mxr, mxc*TWOCOL,&pinvTrps_mns_Trpsinv    [0][0]};

                     m.rows=n;                     m.cols=n*TWOCOL;
                 mTrps.rows=n;                 mTrps.cols=n*TWOCOL;
              minvTrps.rows=n;              minvTrps.cols=n*TWOCOL;
                  minv.rows=n;                  minv.cols=n*TWOCOL;
              mTrpsinv.rows=n;              mTrpsinv.cols=n*TWOCOL;
                  mAID.rows=n;                  mAID.cols=n*2*TWOCOL;
                 mAIDT.rows=n;                 mAIDT.cols=n*2*TWOCOL;
                    mT.rows=n;                    mT.cols=n*TWOCOL;
                   mT2.rows=n;                   mT2.cols=n*TWOCOL;
                   mT3.rows=n;                   mT3.cols=n*TWOCOL;
                   mT4.rows=n;                   mT4.cols=n*TWOCOL;
                   mID.rows=n;                   mID.cols=n*TWOCOL;
                  mIDT1.rows=n;                mIDT1.cols=n*TWOCOL;
                  mIDT2.rows=n;                mIDT2.cols=n*TWOCOL;

        minvTrps_mns_Trpsinv.rows=n;    minvTrps_mns_Trpsinv.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =   6;
 if(n<4){x =  10;}
 if(n<3){x =  20;}

 randmF(&m,x,2);

 copymF(&m,&mT3);

 clrscrn();
 printf("                                                         m :\n");
 printmF(&m);
 printf("                                              transpose(m) :\n");
 transposeF(&m,&mTrps);
 printmF(      &mTrps);
 copymF(&mTrps,&mT4);
 mid(&mID);
 copymAID (&mTrps,&mID,&mAID);
 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mTrps);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT4,&mTrps);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mTrps);
 multmF(&mID,&mAIDT,&mAID);
 printf("                                    inverse(transpose(m)) :\n");
 copyinv(&mAID,&minvTrps);
 printmF(     &minvTrps);
 getchar();

 clrscrn();
 printf("                                                         m :\n");
 printmF(&m);
 mid(         &mID);
 copymAID (&m,&mID,&mAID);
 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&m);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT3,&m);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&m);
 multmF(&mID,&mAIDT,&mAID);
 printf("                                                 inverse(m) :\n");
 copyinv(&mAID, &minv);
 printmF(      &minv);
 printf("                                      transpose(inverse(m)) :\n");
 transposeF(&minv,&mTrpsinv);
 printmF(        &mTrpsinv);
 getchar();

 clrscrn();
 printf("                                     inverse(transpose(m)) :\n");
 printmF(&minvTrps);
 printf("                                     transpose(inverse(m)) :\n");
 printmF(&mTrpsinv);
 printf("\n           inverse(transpose(m)) - transpose(inverse(m)) :");
 submF(&minvTrps,&mTrpsinv,&minvTrps_mns_Trpsinv);
 printmF(                    &minvTrps_mns_Trpsinv);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n  Inverse(Transpose(m)) = Transpose(Inverse(m))   ");
  printf("\n  ********************************************* \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"trpinvi.exe\"                 \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"trpinvi.exe 2\" -> mA 2x2       ");
  printf("\n                \"trpinvi.exe 3\" -> mA 3x3       ");
  printf("\n                \"trpinvi.exe 4\" -> mA 4x4       ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);

    if( n> mxr){n=mxr;}
    }
  else
    {
    n = (int) fabs(randF(mxr));
    }

    if( n< 2){n=2;}

  invB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

