/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
gjA(int n)
{
int      x;

double pbA[MXR][MXC*TWOCOL];matrix mA={MXR,MXC*TWOCOL,&pbA[0][0]};
double pbL[MXR][MXC*TWOCOL];matrix mL={MXR,MXC*TWOCOL,&pbL[0][0]};
double pbU[MXR][MXC*TWOCOL];matrix mU={MXR,MXC*TWOCOL,&pbU[0][0]};
double pbT[MXR][MXC*TWOCOL];matrix mT={MXR,MXC*TWOCOL,&pbT[0][0]};

                     mA.rows=n;      mA.cols=n*TWOCOL;
                     mL.rows=n;      mL.cols=n*TWOCOL;
                     mU.rows=n;      mU.cols=n*TWOCOL;
                     mT.rows=n;      mT.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =   6;
 if(n<4){x =  10;}
 if(n<3){x = 100;}

  rndmF(&mA,x,2);

  clrscrn();
  printf("                                                       A :");
  printmF3(&mA);
  LU(&mA,&mL,&mU);
  printf("                                                       L :");
  printmF3(&mL);
  printf("                                                       U :");
  printmF3(&mU);
  printf("                                                      LU :");
  multmF(&mL,&mU,&mT);
  printmF3(&mT);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            LU decomposition.                     ");
  printf("\n            ****************                    \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"gjf.exe\"                     \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"LUF.exe 2\" -> mA 2x2           ");
  printf("\n                \"LUF.exe 3\" -> mA 3x3           ");
  printf("\n                \"LUF.exe 4\" -> mA 4x4           ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 2){n=2;}


  gjA(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

