
/*
 *    File slist.cpp
 *      Demonstrates the use of the simplest LIST in MGUI library
 */

#include <stdio.h>
#include <string.h>

#include "mguipp.h"

#include "mguitest.hpp"

class SListDialog : public CmCallback {
    CmShell *shell;
    CmLabel *label;
public:
    SListDialog();
    void onSelection(LIST_SEL * sel);
    void onActivate(LIST_ACT * la);
    void closeDialog(void) { delete shell; delete this; };
};

/***************************************************************
 *	This function shows the focused item text, position
 *	and user data
 ***************************************************************/
void SListDialog::
onSelection(LIST_SEL * la)
{
    static int nn;
    char str[128];

    if (la->pos >= 0)
	sprintf(str, " %c Focused row # %ld <%s> user data: %ld",
		(nn++) & 1 ? '-' : '|',
		la->pos, la->item, (long) la->u_data);
    else
	strcpy(str, "No focused item in the list !");
    label->setText(str);
}

/***************************************************************
 *	This function shows the activated item text, position
 *	and user data
 ***************************************************************/
void SListDialog::
onActivate(LIST_ACT * la)
{
    char str[128];

    sprintf(str, "Activated row # %ld\n<%s>\nuser data: %ld",
	    la->pos, la->item, (long) la->u_data);
    MMessageDialog("", str, "Ok", 0);
}

SListDialog::SListDialog(void)
{
    CmForm *form0, *form1;
    CmSList *slist;
    CmSFile *sfile;
    CmPushButton *pb;
    int i;
    char str[512];

    shell = new CmShell("Scrolled List", SF_MODAL);

    form0 = new CmColForm(shell);

    form1 = new CmColForm(form0);

    slist = new CmSList(form1, FIXED_MEDIUM, 16, 10, 12);
    slist->setCallback(this, (LISTACT_CB)&SListDialog::onActivate);
    slist->setSelectionCallback(this, (LISTSEL_CB)&SListDialog::onSelection);
    slist->setSortCallback(strcmp);
/*
 * Try this
 slist->enableSingleClickActivation();
 */
    slist->setHead("Nome    Cognome");
    slist->setColor(seagreen, white);

    for (i = 0; i < 50; i++)
    {
	sprintf(str, "nome%03d cogn%04d", i, i);
	slist->addItem(str, (void *) i);
	if (i == 10)
	    slist->setItemCheckStatus(str, True);
    }
/*
 * Create a SFile to view this source file
 */
    sfile = new CmSFile(form0, __FILE__, FIXED_MEDIUM, 15, 60);
    sfile->setColor(darkblue, white);

    label = new CmLabel(shell, "", FIXED_MEDIUM);

    pb = new CmPushButton(shell, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&SListDialog::closeDialog);

    shell->realize();
}

/*****************************************************
 *	This function opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void
SListDemo(void)
{
	new SListDialog;
}
