/** _locale.h ************************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

 --  Private declarations --
 *************************************************************************/
#ifndef   _LC_PRIVATE_H_
#define   _LC_PRIVATE_H_

#ifndef  _LOCALE_H_thin
#include "locale.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if   !defined(USE_OLENLS) && defined(__WIN32__)
#define        USE_OLENLS
#elif  defined(USE_OLENLS) && !defined(_Windows)
#undef         USE_OLENLS
#endif

#define lcBRK_         ' '  /* or ';' - category delimiter */
          /* in a string generated/accepted by setlocale() */

#if  !defined(_Windows) /* DOS - long format */

typedef unsigned long LC_ID_;

#define _DEFlocale_C_  "C       "   /* Predefined locales */
#define _DEFlocale_D_  "99999999"   /* not for direct use */
#define          LCS_   8    /* Fixed length of locale's values */

#define _lcn_C_       0xfffdfffdL
#define _lcn_BAD_     0xfffefffeL
#define _lcn_DEF_     0xffffffffL /* special value: don't change! */

#if   defined(__BORLANDC__) && !defined(__FLAT__)
#pragma option -a-
#else
#pragma pack(1)
#endif

struct _dos_LC_CharTab
      {
       unsigned short size;
       unsigned char  t[0x100];
      };

struct _dos_LCT_
      {
       char  info_id;
       const struct _dos_LC_CharTab DOS_FAR *t;
#if 2 & DOS_FAR_MODE
             struct _dos_LC_CharTab t2;
#endif
      };

struct _dos_LC_
      {
       char  info_id;
       unsigned
       short size,
             country,
             codepage,
             date_fmt;
       char  currency[5],
             thousands[2],
             decimal[2],
             date_sep[2],
             time_sep[2];
       char  curr_fmt,
             curr_frac,
             hours;
      };

#if   defined(__BORLANDC__) && !defined(__FLAT__)
#pragma option -a.
#else
#pragma pack()
#endif

extern int _dos_getLC_(void *buf, unsigned bufsiz,
                       unsigned table, LC_ID_ ccp); /* doslocal.c */

#define catLID(dli) ((unsigned long)dli.codepage << 16 | dli.country)

#elif defined(USE_OLENLS) /* Windows / Win32 - long format */

typedef unsigned long LC_ID_;

#define _DEFlocale_C_  "C       "  /* Predefined locales */
#define _DEFlocale_D_  "00000400"  /* not for direct use */
#define          LCS_   8    /* Fixed length of locale values */

#define _lcn_C_       0xfffffffeL
#define _lcn_DEF_     0x00000400L
#define _lcn_BAD_     0xffffffffL

int _lc_getLocaleInt(int entry);
extern LC_ID_ _lc_Intl_lcid;    /* argument for _lc_getLocaleInt() */
#define _LOCALEINT_BAD (-32768) /* error during _lc_getLocaleInt() */

#else  /*_Windows - short format */

typedef int LC_ID_;

#define _DEFlocale_C_  "C"         /* Predefined locales */
#define _DEFlocale_D_  "*"         /* not for direct use */
#define          LCS_   1    /* Fixed length of locale values */

#define _lcn_C_        'C'
#define _lcn_DEF_      '*'
#define _lcn_BAD_      '?'

extern const char _lc_Intl_sect[]; /* = "Intl" */

#endif /*_Windows */

extern const char _lcs_DEF_[LCS_+1], /* Predefined locales */
                  _lcs_C_  [LCS_+1]; /* for use            */

extern LC_ID_ _lc_str2lid_(const char *str);     /* doslocal.c */
extern void _lc_lid2str_(char *str, LC_ID_ cp);  /* doslocal.c */


#define LCS_0 (LCS_ + 1)

#ifdef    _Windows  /* short format */

#ifndef   USE_OLENLS
#define _lc_str2lid_(str)     (*(str))
#define _lc_lid2str_(str,ccp) (*(str) = ccp)
#endif

#ifndef    _LC_WIN  /* if != 0 -> WinAnsi else -> OEM */
extern int _lc_Win; /* FOR RunTime _lc_Win control */
#endif
#ifndef USE_ABBR_NAMES
#define USE_ABBR_NAMES 1 /* Short months and weekdays names - from Windows */
#endif
#else  /*!_Windows*/
#undef  USE_ABBR_NAMES
#define USE_ABBR_NAMES 0 /* Truncate months and weekdays names to 3 chars */
#endif /*!_Windows*/

extern int _lc_Coll2; /* if = 1 (default) strcoll()/strxfrm()
    use two pass: first - Case-less and second - Case-sensitive;
                    else if = 0 use single pass (Case-sensitive). */

extern LC_ID_ _lc_ctype_   (LC_ID_ ccp);
extern LC_ID_ _lc_collate_ (LC_ID_ ccp);
extern LC_ID_ _lc_time_    (LC_ID_ ccp);
extern LC_ID_ _lc_numeric_ (LC_ID_ ccp);
extern LC_ID_ _lc_monetary_(LC_ID_ ccp);

extern LC_ID_ (*_lc_fptr_[])(LC_ID_);

/******** Control of date/time formats: strftime.c, lc_time.c ***********/

#if     STRFTIME_EXT
extern const char _lc_fmt_N_[],
                  _lc_fmt_rI[],
                  _lc_fmt_RH[];
#endif

extern const char *_lc_Wday_ [2][ 7],
                  *_lc_Month_[2][12],
                  *_lc_AmPm_ [2][ 2];
#if    USE_ABBR_NAMES
extern const char *_lc_WdayS [ 7], /* Short weekdays */
                  *_lc_MonthS[12]; /* and months names - from Windows */
#endif
extern const char *_lc_fmt_c_[2],
                  *_lc_fmt_xD[2],
                  *_lc_fmt_XT[2];

extern int _lc_Txt_, /* 0="C", 1="Local Win"/"Rus DOS" Wday, Months, AmPm */
           _lc_Fmt_; /* 0="C", 1="Local", for formats %c %x %X */

#ifdef __cplusplus
           }
#endif
#endif  /*_LC_PRIVATE_H_*/
/* end of _locale.h */