/**  lc_numm.c ***********************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

     LC_NUMERIC & LC_MONETARY
 *-----------------------------------------------------------------------*/
#include "config.h"
#include <string.h>
#include <limits.h>
#ifdef   _Windows
#include "win.h"
#endif
#include "_locale.h"

#ifdef  _Windows
#define LSI_SF_SIZE (4+1)
#else
#define LSI_SF_SIZE (1+1)
#endif

struct LC_STR_INFO {
                    char currency[6],
                         decimal[2][LSI_SF_SIZE],
                         grouping[2][2],
                         thousands[2][LSI_SF_SIZE],
                         negative_sgn[LSI_SF_SIZE];
#ifdef   USE_OLENLS
                    char positive_sgn[2],
                         currency_i[5];
#else
                    char zeros[1];
#define                  positive_sgn zeros
#define                  currency_i   zeros
#endif
                   };

static struct LC_STR_INFO ets = { /* etalon for strings */
           /* currency */       { ""      },
           /* decimal  */       { ".", "" },
           /* grouping */       { "" , "" },
           /* thousands */      { "" , "" },
           /* negative_sgn */   { ""      },
#ifdef   USE_OLENLS
           /* positive_sgn */   { "" },
           /* currency_i */     { "" }
#else
           /* zeros */          { "" }
#endif
                                };

 /* Possible to make second LC_STR_INFO, duplicate ets for init
    lconv eti to preserve ets from modifications through lc_info */
#ifdef    USE_NATIVE_INTERFACE
struct LC_INT_INFO {
                    char int_frac_digits,
                         frac_digits,
                         p_cs_precedes,
                         p_sep_by_space,
                         n_cs_precedes,
                         n_sep_by_space,
                         p_sign_posn,
                         n_sign_posn;
                   };
static struct LC_INT_INFO eti = {
#else  /*!USE_NATIVE_INTERFACE*/
static struct lconv       eti = {
              ets.decimal[0],     /* decimal_point */
              ets.thousands[0],   /* thousands_sep */
              ets.grouping[0],    /* grouping */
              ets.currency_i,     /* int_curr_symbol */
              ets.currency,       /* currency_symbol */
              ets.decimal[1],     /* mon_decimal_point */
              ets.thousands[1],   /* mon_thousands_sep */
              ets.grouping[1],    /* mon_grouping */
              ets.positive_sgn,   /* positive_sign */
              ets.negative_sgn,   /* negative_sign */
#endif /*!USE_NATIVE_INTERFACE*/
              CHAR_MAX,           /* int_frac_digits */
              CHAR_MAX,           /* frac_digits */
              CHAR_MAX,           /* p_cs_precedes */
              CHAR_MAX,           /* p_sep_by_space */
              CHAR_MAX,           /* n_cs_precedes */
              CHAR_MAX,           /* n_sep_by_space */
              CHAR_MAX,           /* p_sign_posn */
              CHAR_MAX          };/* n_sign_posn */

/* fills: 1= numeric only; 2= monetary only;
   0= both; 3= non-initialized only */

static struct lconv *get_info(int nummon)
{
 static int init;
 static struct lconv lc_info;
#ifdef    USE_NATIVE_INTERFACE
 if (!(2 & init & nummon))
   {
    lc_info.decimal_point     = ets.decimal[0];
    lc_info.thousands_sep     = ets.thousands[0];
    lc_info.grouping          = ets.grouping[0];
   }
 if (!(1 & init & nummon))
   {
    lc_info.int_curr_symbol   = ets.currency_i;
    lc_info.currency_symbol   = ets.currency;
    lc_info.mon_decimal_point = ets.decimal[1];
#if !defined(__DJGPP__) || 2 != __DJGPP__ && 1 != __DJGPP_MINOR__ \
 || !defined(USE_NATIVE_INTERFACE)
    lc_info.mon_thousands_sep = ets.thousands[1]; /*DJGPP*/
#endif
    lc_info.mon_grouping      = ets.grouping[1];
    lc_info.positive_sign     = ets.positive_sgn;
    lc_info.negative_sign     = ets.negative_sgn;

    lc_info.int_frac_digits   = eti.int_frac_digits;
    lc_info.frac_digits       = eti.frac_digits;
    lc_info.p_cs_precedes     = eti.p_cs_precedes;
    lc_info.p_sep_by_space    = eti.p_sep_by_space;
    lc_info.n_cs_precedes     = eti.n_cs_precedes;
    lc_info.n_sep_by_space    = eti.n_sep_by_space;
    lc_info.p_sign_posn       = eti.p_sign_posn;
    lc_info.n_sign_posn       = eti.n_sign_posn;
   }
#else
 if (3 != (init & nummon)) lc_info = eti;
#endif /*!USE_NATIVE_INTERFACE*/
 init |= nummon;
 return &lc_info;
}

struct lconv *localeconv(void)
{
/* ets.zeros[0] = '\0'; */      /* Side effects are:  */
                                /* 1) filling lc_info */
#if 0 == LINK_NUMMON            /* 2) registration    */
 _lc_fptr_[3] = _lc_numeric_;
 _lc_fptr_[4] = _lc_monetary_;
#endif
 return get_info(3);
}

#ifdef   _Windows
#ifdef    USE_OLENLS

#ifdef __WIN32__
#define locale_DECIMAL(mon)  (!mon? LOCALE_SDECIMAL  \
                               : LOCALE_SMONDECIMALSEP)
#define locale_THOUSAND(mon) (!mon? LOCALE_STHOUSAND \
                               : LOCALE_SMONTHOUSANDSEP)
#define locale_GROUPING(mon) (!mon? LOCALE_SGROUPING \
                               : LOCALE_SMONGROUPING)
#else
#define locale_DECIMAL(mon)         LOCALE_SDECIMAL
#define locale_THOUSAND(mon)        LOCALE_STHOUSAND
#define locale_GROUPING(mon)        LOCALE_SGROUPING
#endif

#define GETcfgINT(Entry)       _lc_getLocaleInt(Entry)

static void GETcfgSTR_(LCTYPE entry, char *name, size_t len)
{
 if (0 >= GetLocaleInfoA(_lc_Intl_lcid, entry, name, len))
   {
    *name = '\0'; return;
   }   /* to be Continued... */
#else  /*!USE_OLENLS*/

#define GETcfgINT(Entry)       GetProfileInt(_lc_Intl_sect,Entry,0)

#define LOCALE_ICURRDIGITS   "iCurrDigits"
#define LOCALE_ICURRENCY     "iCurrency"
#define LOCALE_INEGCURR      "iNegCurr"
#define LOCALE_SCURRENCY     "sCurrency"
#define locale_DECIMAL(mon)  "sDecimal"
#define locale_THOUSAND(mon) "sThousand"

static void GETcfgSTR_(const char *entry, char *name, size_t len)
{
 GetProfileString(_lc_Intl_sect, entry, "", name, len);
#endif /*!USE_OLENLS*/
/* Common part of GETcfgSTR_ */
#ifndef  _LC_WIN
    if (!_lc_Win) AnsiToOem(name, name);
#elif   !_LC_WIN
                  AnsiToOem(name, name);
#endif
}

#define GETcfgSTR(Entry,Name)  GETcfgSTR_(Entry,Name,sizeof(Name))

#endif /*_Windows*/

static LC_ID_ _common_num_mon(int mon, LC_ID_ ccp)
{
 if (ccp == _lcn_C_)
   {
    ets.decimal  [mon][0] = '.';
    ets.decimal  [mon][1] =
    ets.grouping [mon][0] =
    ets.thousands[mon][0] = '\0';
    if (mon)
      {
       ets.decimal[1][0] =
       ets.negative_sgn[0] =
#ifdef   USE_OLENLS
       ets.positive_sgn[0] =
       ets.currency_i[0] =
#endif
       ets.currency[0] = '\0';
       eti.int_frac_digits =
       eti.frac_digits =
       eti.p_cs_precedes =
       eti.p_sep_by_space =
       eti.n_cs_precedes =
       eti.n_sep_by_space =
       eti.p_sign_posn =
       eti.n_sign_posn = CHAR_MAX;
   }  }
#ifndef  _Windows
 else
   {
    struct _dos_LC_ dli;
    if (0 > _dos_getLC_(&dli, sizeof(dli), 1, ccp)) return _lcn_BAD_;
    ccp = catLID(dli);
    ets.grouping [mon][0] = '\3';
    ets.decimal  [mon][0] = dli.decimal[0];
    ets.thousands[mon][0] = dli.thousands[0];
    if (mon)
      {
       memcpy(ets.currency, dli.currency, 5);
       eti.frac_digits = dli.curr_frac;
       if (dli.curr_fmt & 4) dli.curr_fmt |= 1; /*???*/
       eti.p_cs_precedes =
       eti.n_cs_precedes = 1 & ~dli.curr_fmt;
       eti.p_sep_by_space =
       eti.n_sep_by_space = 1 & dli.curr_fmt >> 1;
       eti.int_frac_digits =
       eti.p_sign_posn = CHAR_MAX;

       eti.n_sign_posn = 1; /* ?? (3 & dli.curr_fmt)? 4: 1 */
       ets.negative_sgn[0] = '-';
       switch(dli.country)
         {
       case  61:
       case  64:
          break;
       default :
          if (!strchr(ets.currency, '$'))
            {
#if 1
             if (eti.n_sep_by_space & eti.n_cs_precedes)
                 eti.n_sep_by_space = 0,
                 eti.n_sign_posn = 4;
#endif
             break;
            }
       case  86:
       case 886:
          eti.n_sign_posn = 0;
          break;
         }
/*  .int_curr_symbol .int_frac_digits -- can be determined trough
     request about CodePage 437 or (on fault) 850 */
   }  }
#else  /*_Windows*/
 else
   {
    int val;
#ifndef  USE_OLENLS
    if (ccp != _lcn_DEF_) return _lcn_BAD_;
    ets.grouping[mon][0] = '\3';
#else
    _lc_Intl_lcid = ccp;
    if (_LOCALEINT_BAD == (val = GETcfgINT(locale_GROUPING(mon))))
      return _lcn_BAD_;
    ets.grouping[mon][0] = (char)val;
#endif
    GETcfgSTR(locale_DECIMAL(mon), ets.decimal[mon]);
    GETcfgSTR(locale_THOUSAND(mon), ets.thousands[mon]);
    if (mon)
      { /* bits: 0...2 = n_sign_pos      07,
                     3 = n_sep_by_space 010,
                     4 = n_cs_precedes  020 */
       static const char MonFmt[16] = {
       020 /* ($1)*/, 021/*3 -$1 */, 024 /* $-1 */, 022 /* $1- */,
       000 /* (1$)*/, 001 /* -1$ */, 003 /* 1-$ */, 002/*4 1$- */,
       011 /* -1 $*/, 031/*3 -$ 1*/, 012/*4 1 $-*/, 032 /* $ 1-*/,
       034 /* $ -1*/, 013 /* 1- $*/, 030 /*($ 1)*/, 010 /*(1 $)*/
                                      };
       GETcfgSTR(LOCALE_SCURRENCY, ets.currency);
       eti.frac_digits = (char)GETcfgINT(LOCALE_ICURRDIGITS);
#ifdef    USE_OLENLS
       GETcfgSTR(LOCALE_SINTLSYMBOL, ets.currency_i);
       GETcfgSTR(LOCALE_SNEGATIVESIGN, ets.negative_sgn);
       eti.int_frac_digits = (char)GETcfgINT(LOCALE_IINTLCURRDIGITS);
/*       GETcfgSTR(LOCALE_SPOSITIVESIGN, ets.positive_sgn);
         eti.p_sign_posn = GETcfgINT(IPOSSIGNPOSN, def:CHAR_MAX);
-------- Not Used */
       ets.positive_sgn[0] = '\0';
       eti.p_sign_posn = CHAR_MAX;
#else  /*!USE_OLENLS*/
       ets.negative_sgn[0] = '-';
       eti.int_frac_digits =
       eti.p_sign_posn = CHAR_MAX;
#endif /*!USE_OLENLS*/
/* Also   LOCALE_SPOSITIVESIGN
          LOCALE_IPOSSIGNPOSN      LOCALE_INEGSIGNPOSN
          LOCALE_IPOSSYMPRECEDES   LOCALE_IPOSSEPBYSPACE
          LOCALE_INEGSYMPRECEDES   LOCALE_INEGSEPBYSPACE
   are supplied but it's not a general way in MS-Windows
   and may works incorrectly. */

       val = GETcfgINT(LOCALE_ICURRENCY);
       eti.p_cs_precedes = 1 & ~val;
       eti.p_sep_by_space = 1 & val >> 1;
       val = GETcfgINT(LOCALE_INEGCURR);
       val = MonFmt[val & 15];
       eti.n_sign_posn =    7 & val;
       eti.n_sep_by_space = 1 & val >> 3;
       eti.n_cs_precedes =  1 & val >> 4;
   }  }
#endif /*_Windows*/
 get_info(++mon); /* filling work_copy for lc_info */
 return ccp;
}

LC_ID_ _lc_numeric_(LC_ID_ ccp)
{
 return _common_num_mon(0, ccp);
}

LC_ID_ _lc_monetary_(LC_ID_ ccp)
{
 return _common_num_mon(1, ccp);
}

/* end of lc_numm.c */