/** config.h *************************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

 -------------------------------------------------------------------------
     This file has included in each source of locale.lib before any other
     statements.
     All configurable parametrs for building locale.lib are located here.
     Most of these options can be changed also in the Makefile (through -D
     compiler's command line option).
 *************************************************************************/
#ifndef  BUILDING_LOCALE_LIB
#define  BUILDING_LOCALE_LIB

/* Borland - like consideradion was used to determinate target OS:
 * MS-DOS (extended DOS)     - no _Windows nor __WIN32__ are defined
 * Windows 3x                - _Windows is defined
 * Windows NT/95 (Win32 API) - both _Windows and __WIN32__ defined
 */

#if !defined(__WIN32__) && defined(__NT__)
#define      __WIN32__  /* for Watcom C */
#endif
#if !defined(_Windows) &&  defined(__WINDOWS__)
#define      _Windows   /* for Watcom C */
#endif
#if !defined(_Windows) &&  defined(_WINDOWS)
#define      _Windows   /* for Microsoft C */
#endif
#if !defined(_Windows) && defined(__WIN32__)
#define      _Windows
#endif

/****** DOS_FAR_MODE ***
 Mode for access to some DOS-data. This definitions depends from
 memory model, compiler, DOS-extender, etc...
 This definition affected to lc_chars.c and doslocal.c
 Only some of combinations of this flags are valid:
 0x01 = use __far modifier for few pointers;
 0x02 = use "secondary" buffer on stack for retreived information;
 0x04 = Watcom C32;
 See also doslocal.c for details. */

#if    defined(_Windows)
#define DOS_FAR_MODE 0   /* any Windows: DOS_DATA hasn't used at all */

#elif  defined(_M_I86CM) || defined(_M_I86LM) || defined(_M_I86HM) \
    || defined(__BORLANDC__) && \
      (defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__))
#define DOS_FAR_MODE 0   /* dos: far16 DATA by default */

#elif  defined(_M_I86MM) || defined(_M_I86SM) \
    || defined(__BORLANDC__) && \
      (defined(__MEDIUM__) || defined(__SMALL__) || defined(__TINY__))
    /* That must be true for DOS-16bit & near data by default Only */
#define DOS_FAR_MODE 1   /* dos: explict far16 DATA */

#elif  defined(__DJGPP__)
#define DOS_FAR_MODE 2   /* Haven't a direct access to conventional mem */

#elif !defined(DOS_FAR_MODE)
#error Unknown Memory Mode
#endif

#if 1 & DOS_FAR_MODE
#define DOS_FAR  __far
#else
#define DOS_FAR
#endif
/*****************************************************************/

/****** USE_NATIVE_INTERFACE *
 Source declaration for LC_XXXX constants and struct lconv.
 if Unefined (prefferd): use "locale.h" from this package;
 if Defined: use standard <locale.h> from your compilation system.
 Note: you should define it here or in a Makefile if declarations
 for LC_XXX and/or struct lconv which are provided by your system
 are completely incompatible to declared in "locale.h".
 As in DJGPP v2 for example * /
#define USE_NATIVE_INTERFACE
/*****************************************************************/

/****** LINK_NUMMON  ***
  if == 0: Do not link support for LC_NUMERIC and LC_MONETARY by default.
 It is acceptable, because both LC_NUMERIC and LC_MONETARY are rare used.
 If you want to use that categories you may:
    at run-time:
       make a call of localeconv() at least once before setlocale();
 OR at compile-time:
       define LINK_NUMMON as 1 here or in command line -DLINK_NUMMON=1
 See also locale.c and lc_numm.c for details. */
#ifndef LINK_NUMMON
#define LINK_NUMMON 0
#endif
/*****************************************************************/

/****** STRFTIME_EXT ***
  if == 0 Use ANSI-C with small extensions format-spec set in strftime();
  if != 0 Use full (UNIX/POSIX-compatible) format-spec set in strftime().
  Also can be defined in command line -D. */
#ifndef STRFTIME_EXT
#define STRFTIME_EXT 0
#endif
/*****************************************************************/

/****** STRFTIME_WIN ***
  if != 0 Use few additional strftime()/strptime() format-spec for
  better representation of some Windows's date/time fields without
  leading zero or blank such as M(month), d(day) and h(hour).
  Also can be defined in command line -D. */
#if !defined(STRFTIME_WIN) || !defined(_Windows)
#define STRFTIME_WIN 0
#endif
/*****************************************************************/

/****** INTERPOLATE_CTYPEF *
  if != 0 Performs more "agressive" research strategy for ctype flags.
  Also can be defined in command line -D. */
#ifndef INTERPOLATE_CTYPEF
#define INTERPOLATE_CTYPEF 1
#endif
/*****************************************************************/

#ifdef   _Windows
   /* The Windows only options ***********************************/

/****** USE_OLENLS   ***
  Use support from ole2nls.dll under Windows 3.x if defined.
  Can be defiend in command line (Makefile) -DUSE_OLENLS so. * /
#define USE_OLENLS
/*****************************************************************/

/****** _LC_WIN      ***
  Determinate using WinANSI/OEM charset under Windows
  if "defined" as 0 or 1 - at compile time
  else "extern int _lc_Win" - at run time.
  In both cases "1" mean WinANSI (in real that is NOT ANSI),
  "0" = OEM. Can be defined in Makefile: -D_LC_WIN=0 so. * /
#define _LC_WIN 0
/*****************************************************************/

/****** USE_ABBR_NAMES **
  For strftime() - using short day and month names:
  if != 0 - from Windows (by default);
  else - by truncating full names to 3 chars.
  Can be defined in Makefile. * /
#define USE_ABBR_NAMES 0
/*****************************************************************/

/****** COMPAT31     ***
  For pure 16-bits code (without USE_OLENLS) only.
  if COMPAT31 != 0 (by default) the names of months and weekdays are
  extracted from (first) "ole2nls.dll" and on fail (second) from "main.cpl".
  That is prevent from access to "main.cpl" in true 32-bits Windows
  (such as NT or '95).
  if COMPAT31 == 0 thats names are obtained directly from "main.cpl"
  thus "ole2nls.dll" and "olenls.h" not used at all.
  if "ole2nls.dll" is used then language can be selected through
  win.ini/intl/sLanguage=...
  This parametr can be defined also in lc_time.c or Makefile. * /
#define COMPAT31 0
/*****************************************************************/

#endif /*_Windows*/

/* Other tunable parametrs are: *********************************

locale.h, strcoll.c: _lc_Coll2:
  RunTime switch for using single/double pass in strcoll()/strxfrm().

locale.h: _lc_igncase: Table for case-less comparision in stricmp()
                    (library compile-time), (_lc_toupper by default).

locale.h: LC_XXXX: You can to adjust the values of categories according
  your compiler/headers/libraries to avoid conflicts between this
  library and your standard <locale.h>
  (if USE_NATIVE_INTERFACE isn't defined).

lc_chars.c: Binding to _ctype[] and _ctype-flags
            is required for some systems.

to_uplw.c: Look up at that file. Some compilers has incorrect macros
  for toupper(), tolower(). Also 'signed char' may cause a problem.

/*****************************************************************/
#endif /*BUILDING_LOCALE_LIB*/