/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <go32.h>
#include <jlib.h>

extern void jdosmemput(UBYTE *buff,unsigned int len,unsigned int addr);

/*+------------------------------------------------------------------------+ */
/*|blit a fullscreen buffer to the screen                                  | */
/*+------------------------------------------------------------------------+ */
JINLINE void screen_blit_fs_buffer (buffer_rec * buff)
{
  jdosmemput(B_BUFF_PTR(buff),64000,0xA0000);
}

/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen without clipping.                   | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_toNC (int x, int y, buffer_rec * sbuff,
			 int sbx1, int sby1, int sbx2, int sby2)
{
   unsigned int sbuffx = B_X_SIZE (sbuff);
   UBYTE *src = B_BUFF_PTR (sbuff) + (sbuffx * sby1) + sbx1;
   UBYTE *dest = (UBYTE *) 0xA0000 + (y * SCREEN_WIDTH) + x;
   unsigned int h_len= sbx2-sbx1+1;
   unsigned int v_iterations= sby2 - sby1+1;


   switch(get_best_copy_method((void *)src,(void *)dest,h_len)){

     case ALIGNMENT_STATE_1:
	for(;v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_1 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_2:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_2 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_3:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_3 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
        }
	break;

     case ALIGNMENT_STATE_4:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_4 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_5:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_5 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_6:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_6 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_7:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_7 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_8:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_8 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     default:
	jlib_exit("Unknown Copy Method.");
	break;
     }


}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen with clipping.                      | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_to (int x, int y, buffer_rec * sbuff,
			  int sbx1, int sby1, int sbx2, int sby2)
{
   unsigned int sbuffx,sbuffy, h_len, v_iterations;
   UBYTE *src,*dest=(UBYTE *)0xA0000;

   src=B_BUFF_PTR(sbuff);
   sbuffx= B_MAX_X(sbuff);
   sbuffy= B_MAX_Y(sbuff);

   /* sort coordinates if needed */
   if(sbx2 < sbx1){
        JLIB_SWAP(sbx1, sbx2);
   }

   if(sby2 < sby1){
        JLIB_SWAP(sby1, sby2);
   }

   /* clip src buffer */
   if((sbx1>sbuffx) ||(sby1>sbuffy) || (sbx2<0) || (sby2<0)){
      return;
   }

   if(sbx1<0){
      sbx1=0;
   }
   if(sby1<0){
      sby1=0;
   }
   if(sbx2>sbuffx){
      sbx2=sbuffx;
   }
   if(sby2>sbuffy){
      sby2=sbuffy;
   }

   /* test coordinates for "don't draw" clipping */
   if((x > SCREEN_MAX_X) || (y > SCREEN_MAX_Y)){
	return;
   }

   if(x<0){
      sbx1-=x;
      x=0;
      if(sbx1>sbx2){
         return;
      }
   }
   if(y<0){
      sby1-=y;
      y=0;
      if(sby1>sby2){
         return;
      }
   }

   sbuffx++; /* from max x to buffer width */
   src+= (sby1*sbuffx)+ sbx1;
   dest+= (y*SCREEN_WIDTH)+ x;

   v_iterations= (sby2 - sby1+1);        /* number of times to repeat horiz. blit */
   h_len= (sbx2-sbx1+1);                 /* length of horizontal blit */

   /* test coordinates to clip area drawn */
   if (x + h_len > SCREEN_WIDTH){
        h_len = SCREEN_WIDTH - x;
   }

   if (y + v_iterations > SCREEN_HEIGHT){
        v_iterations = SCREEN_HEIGHT - y;
   }

   switch (get_best_copy_method((void *)src,(void *)dest,h_len)){

     case ALIGNMENT_STATE_1:
	for(;v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_1 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_2:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_2 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_3:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_3 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
        }
	break;

     case ALIGNMENT_STATE_4:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_4 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_5:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_5 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_6:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_6 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_7:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_7 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     case ALIGNMENT_STATE_8:
	for(; v_iterations != 0; v_iterations--){
	     DOS_MEMCOPY_ALIGN_8 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	}
	break;

     default:
	jlib_exit("Unknown Copy Method.");
	break;
     }
}
