/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <jlib.h>

#define NUM_SPRITES 32
#define NUM_ITERATIONS 500
#define RANDOM(u) ( rand() % ( ((u) + 1)  ) )

/* simple sprite demo */

int main(void)
{
 int i;
 unsigned char *pal;
 sprite_system *demo_sprites;
 buffer_rec *buff;
 int animation[6] = {0,1,2,3,4,5};

 JLIB_DEBUG_OFF
 screen_set_video_mode();
 
 /* init stuff*/
 buff = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 demo_sprites = sprite_init(NUM_SPRITES,64);
 pal = pal_load("demo5.pal");
 
 if((demo_sprites == NULL) || (pal == NULL)){
   jlib_exit("Initialisation Failed.");
 }

 if(sprite_load("demo5.spr",demo_sprites)!=SUCCESS){
    jlib_exit("Sprite Load Failed.");
 }
 
 srand(time(NULL));
 screen_block_set_pal(pal);

 /* set up sprite movements in whole mode steps */
 for(i=0;i<NUM_SPRITES;i++){
     sprite_set_xy(demo_sprites,i,RANDOM(B_X_SIZE(buff)),
				  RANDOM(B_Y_SIZE(buff)));
     sprite_set_an_frame(demo_sprites,i,RANDOM(5));
     sprite_set_move_info(demo_sprites,i,RANDOM(2)+1,RANDOM(8)-4,RANDOM(8)-4);
     sprite_set_anim_info(demo_sprites,i,RANDOM(3)+1,6,animation);
     sprite_turn_on(demo_sprites,i);
 }

 /* this is the main sprite drawing loop */
 for(i=0;i<NUM_ITERATIONS;i++){
   buff_save_all_sprites(demo_sprites,buff);

   buff_draw_all_sprites(demo_sprites,buff);

   screen_blit_fs_buffer(buff);

   buff_rest_all_sprites(demo_sprites,buff);

   sprite_update_all_anim_and_move(demo_sprites);
 };


 screen_restore_video_mode();
 return(1);
}
