/*
Ŀ
 Title   : jaz.h							     
 Purpose : Define general purpose macros for use in my programs	     
									     
	Written by Jack Zucker - 75766,1336    301-794-5950  on 1/15/85      

*/

/* given a segment and offset, return a pointer which will point to the */
/* seg:off pair 							*/

#define LPOINTER(type,seg,ofs) (type far *) ((long) seg << 16 | ofs)
#define CNULL 0
#define SEG(x) *((unsigned*)&(x)+1)
#define OFS(x) *((unsigned*)&(x))
#define msdos(_wreg) intr(0x21,_wreg)	/* define turbo like msdos call */
#define lobyte(a) *((unsigned char *)&(a))
#define hibyte(a) *((unsigned char *)&(a)+1)
#define loword(a) *((unsigned *)&(a))
#define hiword(a) *((unsigned *)&(a)+1)
#define max(x,y) (x > y ? x : y)
#define min(x,y) (x < y ? x : y)


/*  define various memory peek macros.  */

/* this one returns a char */
#define MEMB(seg,ofs) (*LPOINTER(unsigned char,seg,ofs))

/* this one returns a word */
#define MEMW(seg,ofs) (*LPOINTER(unsigned int,seg,ofs))

#define MEML(seg,ofs) (*LPOINTER(long,seg,ofs))
/* this one returns a long */

/*  define a macro for avoiding snow.   */

/* this next macro will wait for the horizontal retrace status bit to */
/* avoid snow. Much more elegant than writing the routines in masm    */

#define WAITSCR while (inp(0x3da) & 1) ; while (! (inp(0x3da) & 1)) ;

struct tfat {
  long		free;
  long		total;
  long		used;
} ;
#define TFAT struct tfat

/* structure for keyboard shift state */
struct shiftstate {
  unsigned rightshift : 1;
  unsigned leftshift  : 1;
  unsigned control    : 1;
  unsigned alt	      : 1;
  unsigned scroll     : 1;
  unsigned numlock    : 1;
  unsigned capslock   : 1;
  unsigned insert     : 1;
};
#define SHIFTSTATE struct shiftstate

/* structure for keyboard hold state */
/* this byte indicates whether or not the key is being pressed, not the state */
struct holdstate {
  unsigned filler     : 2;
  unsigned pcjrclick  : 1;
  unsigned ctrlnum    : 1;
  unsigned scroll     : 1;
  unsigned numlock    : 1;
  unsigned capslock   : 1;
  unsigned insert     : 1;
};
#define HOLDSTATE struct holdstate

union keystate {
  HOLDSTATE   h;
  SHIFTSTATE  s;
};
#define KEYSTATE union keystate

struct REGW {
  unsigned int ax,bx,cx,dx,si,di,ds,es,flags;
};

struct REGB {
  unsigned char al,ah,bl,bh,cl,ch,dl,dh;
};

union TREG {
  struct REGW x;
  struct REGB h;
};

struct tname {
  char *filename;
  struct tname *next;
};
#define TNAME struct tname

struct tdiskblk {
  char jmploc[3];	/* code to jump to boot rec */
  char sysid[8];	/* system id */
  int  bytes;		/* bytes per sector */
  char sectors; 	/* sectors per cluster */
  int rsvsect;		/* number of reserved sectors */
  char numfat;		/* num of fat tables */
  int numdir;		/* num of root dir entries */
  unsigned int ttlsect; /* total sectors on disk */
  char fmtid;		/* format id */
  int sectfat;		/* num of sectors per fat */
  int secttrack;	/* num of sectors per track */
  int numheads; 	/* num of heads (sides) */
  int special;		/* special reserved sectors */
};
#define TDISKBLK struct tdiskblk

struct tdiskdir {
    char filename[8];
    char ext[3];
    unsigned char attribute;
    char reserved[10];
    unsigned int time;
    unsigned int date;
    unsigned int cluster;
    long size;
  };
#define TDISKDIR struct tdiskdir

struct tfcb {
  char flag ;
  char junk[5];
  char search;
  char drive;
  char name[8];
  char ext[3];
  char attr;
  char dos[10];
  int time;
  int date;
  int cluster;
  long size;
};
#define TFCB struct tfcb

struct tbit {
  unsigned b : 1;
};

struct tbitmap {
  struct tbit bit[8];
};
#define TBITMAP struct tbitmap

struct thead {
  int listlen;
  struct tname *first,*last;
};
#define THEAD struct thead


THEAD *rsplist();
THEAD *dirlist();

struct tregx {			/* define a register struct for bios calls */
  unsigned int ax,bx,cx,dx,si,di,ds,es,flags;
};

struct tregh {
  unsigned char al,ah,bl,bh,cl,ch,dl,dh;
};

struct tstack				/* stack structure for pushdir/popdir*/
{
  char *pointer;			/* pointer to path name */
  int wint;				/* generic integer */
  struct tstack *next,*prev;
};
#define TSTACK struct tstack

struct tstkhead
{					/* head of stack struct */
  int numitems; 			/* size of stack items	*/
  struct tstack *first , *last;      /* pointer to items in stack */
};
#define TSTKHEAD struct tstkhead

union treg {
  struct tregx x;
  struct tregh h;
};
#define TREG union treg

struct tvector { unsigned int offset,segment; };
#define TVECTOR struct tvector

#if LINT_ARGS
/*global*/  void intr(int , TREG *);
/*global*/  int rindex(char *,char);
/*global*/ char *tabtosp(char *,char *);
/*global*/ void jzdskfre(TFAT *,int);
/*global*/ char *jzpad(int , int);
/*global*/ void jzgetint(int,TVECTOR *);
/*global*/ int jzinstr(char*,int,int,int,int,long,char*);
/*global*/ char *jzrgtjst(char *,int);
/*global*/ void jzdelay(long);
/*global*/ char *jzstrpos(char *,char*);
/*global*/  unsigned char far *jzfat(int ,int  *,int  *,int  *);
/*global*/  void jzgetfat(char **, int);
/*global*/  unsigned int jzgetcls( char *, int , int);
/*global*/  int jzfateof( unsigned int , int );
/*global*/ char *jzcntstr( char * , int );
/*global*/ char *jzrgtstr(char * , int);
/*global*/ char *jzlftstr(char *,int);
/*global*/ char *jzmidstr(char *,int , int);
/*global*/ int jzcrtfil( char * , int);
/*global*/ int jzredfil(int , char * , int);
/*global*/ int jzwrtfil(int , char * , int);
/*global*/ long jzsekfil(int , unsigned long , int);
#endif

