/*************************************************************************
** interpcom-1.1 (command interpreter - tutorial)                        **
** names.c :    Names of commands                                        **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#include "interp.h"
#include "protos.h"
#include "funct.h"

pfi             proc[] =
{
    add_objet,
    add_func,
    assign_membre,
    temps,
    close_file_cmd,
    comp_func,
    cnst,
    Ccnst_cmd,
    const_func,
    RPolcnst,
    ThPolcnst,
    copie_objet,
    copy_func,
    def_bessel_param,
    def_funct_f,
    def_funct_d,
    def_funct_C,
    def_funct_dC,
    def_xrange_f,
    def_xrange_d,
    def_four_prec,
    delcom,
    deldon,
    delprog_cmd,
    delres,
    desassign_membre,
    desc_struct,
    desc_func,
    detruit_obj,
    diff_func,
    div_func,
    echo_cmd,
    echo_float_cmd,
    echo_int_cmd,
    editeur,
    fin_mon_cmd,
    eval_cmd,
    exit_cmd,
    fill_func,
    fix_func_R,
    fix_func_C,
    fix_xrange_f,
    fix_xrange_d,
    flush_cmd,
    hist_cmd,
    reel_imag_Cfunc,
    reel_imag_fix_func,
    init_var_cmd,
    integ_func,
    inv_func_cmd,
    is_cmd,
    liste_obj,
    load_cmd,
    bouclex,
    bouclex_f,
    Max_funct_cmd,
    Min_funct_cmd,
    mon_cmd,
    mult_objet,
    mul_func,
    num_com,
    obj_create,
    proglist_cmd,
    question_cmd,
    fread_cmd,
    reel_imag_Cfunc,
    reel_imag_fix_func,
    repetex,
    restore_cmd,
    Rmul_func,
    sauve_func,
    shell_cmd,
    si_cmd,
    silence_cmd,
    struc_create,
    sub_objet,
    sub_func,
    svg_cmd,
    time_cmd,
    trans_bessel,
    trans_four_prec,
    undef_cmd,
    val_func,
    var_list_cmd,
    file_cmd,
};



FUNCTION Funcs[] =
{
   /* name, funtion to call */
   { "sin",     1,    sin },		/* 0    */
   { "cos",     1,    cos },		/* 1    */
   { "tan",     1,    tan },		/* 2    */
   { "asin",    1,    asin },		/* 3    */
   { "acos",    1,    acos },		/* 4    */
   { "atan",    1,    atan },		/* 5    */
   { "sinh",    1,    sinh },		/* 6    */
   { "cosh",    1,    cosh },		/* 7    */
   { "tanh",    1,    tanh },		/* 8    */
   { "exp",     1,    exp },		/* 9    */
   { "log",     1,    log },		/* 10   */
   { "log10",   1,    log10 },		/* 11   */
   { "sqrt",    1,    sqrt },		/* 12   */
   { "floor",   1,    floor },		/* 13   */
   { "ceil",    1,    ceil },		/* 14   */
   { "abs",     1,    fabs },		/* 15   */
   { "hypot",   2,    hypot },		/* 16   */
   { "acosh",   1,    acosh },		/* 17   */
   { "asinh",   1,    asinh },		/* 18   */
   { "atanh",   1,    atanh },		/* 19   */
   { "beta",    2,    beta },		/* 20   */
   { "lbeta",   2,    lbeta },		/* 21   */
   { "deg",     1,    deg },		/* 22   */
   { "rad",     1,    rad },		/* 23   */
   { "chdtrc",  2,    chdtrc }, 	/* 24   */
   { "chdtr",   2,    chdtr },  	/* 25   */ 
   { "chdtri",  2,    chdtri },  	/* 26   */ 
   { "dawsn",   1,    dawsn },  	/* 27   */ 
   { "ellie",   2,    ellie },  	/* 28   */ 
   { "ellik",   2,    ellik },  	/* 29   */ 
   { "ellpe",   1,    ellpe },  	/* 30   */ 
   { "ellpk",   1,    ellpk },  	/* 31   */ 
   { "gamma",   1,    gamma },  	/* 32   */ 
   { "lgam",    1,    lgam },  		/* 33   */ 
   { "gdtr",    3,    gdtr },		/* 34   */
   { "gdtrc",   3,    gdtrc },		/* 35   */
   { "hyperg",  3,    hyperg },		/* 36   */
   { "i0",      1,    i0 },  	        /* 37   */ 
   { "i0e",     1,    i0e },  	        /* 38   */ 
   { "igamc",   2,    igamc },  	/* 39   */ 
   { "igam",    2,    igam },  		/* 40   */ 
   { "igami",   2,    igami },  	/* 41   */ 
   { "incbet",  3,    incbet },		/* 42   */
   { "incbi",   3,    incbi },		/* 43   */
   { "iv",      2,    iv },  		/* 44   */ 
   { "j0",      1,    j0 },  	        /* 45   */ 
   { "y0",      1,    y0 },  	        /* 46   */ 
   { "j1",      1,    j1 },  	        /* 47   */ 
   { "y1",      1,    y1 },  	        /* 48   */ 
   { "jv",      2,    jv },  		/* 49   */ 
   { "k0",      1,    k0 },  	        /* 50   */ 
   { "k0e",     1,    k0e },  	        /* 51   */ 
   { "k1",      1,    k1 },  	        /* 52   */ 
   { "k1e",     1,    k1e },  	        /* 53   */ 
   { "ndtr",    1,    ndtr },           /* 54   */ 
   { "ndtri",   1,    ndtri },          /* 55   */ 
   { "erf",     1,    erf },  	        /* 56   */ 
   { "erfc",    1,    erfc },  	        /* 57   */ 
   { "psi",     1,    psi },  	        /* 58   */ 
   { "rgamma",  1,    rgamma },  	/* 59   */ 
   { "spence",  1,    spence },  	/* 60   */ 
   { "struve",  2,    struve },  	/* 61   */ 
   { "zeta",    2,    zeta },  		/* 62   */ 
   { "zetac",   1,    zetac },  	/* 63   */ 
   { "bdtr",    3,    bdtr },  		/* 64   */ 
   { "bdtri",   3,    bdtri },  	/* 65   */ 
   { "bdtrc",   3,    bdtrc },  	/* 66   */ 
   { "fdtr",    3,    fdtr },  		/* 67   */ 
   { "fdtri",   3,    fdtri },  	/* 68   */ 
   { "fdtrc",   3,    fdtrc },  	/* 69   */ 
   { "jn",      2,    jnn },  	        /* 70   */ 
   { "kn",      2,    kn },  	        /* 71   */ 
   { "nbdtr",   3,    nbdtr },  	/* 72   */ 
   { "nbdtri",  3,    nbdtri },  	/* 73   */ 
   { "nbdtrc",  3,    nbdtrc },  	/* 74   */ 
   { "pdtr",    2,    pdtr },  		/* 75   */ 
   { "pdtri",   2,    pdtri },  	/* 76   */ 
   { "pdtrc",   2,    pdtrc },  	/* 77   */ 
   { "yn",      2,    ynn },  		/* 78   */ 
   { "stdtri",  2,    stdtri },  	/* 79   */ 
   { "stdtr",   2,    stdtr },  	/* 80   */ 

   { 0 }				/* 81   */
};


int    _NBFONC=81;
