; strupr
;   AAA=str
;   BBB=013
;   F=
;   O=
; str013.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strupr:FN_CALL PTR
p_fn_strupr P_FN_CALL strupr
EXTERNDEF C p_fn_fc_strupr:FN_CALL PTR
p_fn_fc_strupr P_FN_CALL @strupr
EXTERNDEF C p_fn_strupr_sss:FN_CALL PTR
p_fn_strupr_sss P_FN_CALL strupr_sss
EXTERNDEF C p_fn_fc_strupr:FN_CALL PTR
p_fn_fc_strupr_sss P_FN_CALL @strupr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strupr() -- Convert string to uppercase
;char __near * fn_call strupr(char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str)
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strupr PROC FN_CALL C uses es si di, p_str:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str]	    ;ds:si = p_str
	    mov di, [p_str]	    ;es:di = p_str

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    cmp al,'a'		    ;Check for lowercase
	    jb @F
            cmp al,'z'
	    ja @F
		sub al,20h	    ;Convert to uppercase
@@:
	    stos BYTE PTR es:[di]   ; Store char
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]	; return p_str
	    ret

strupr ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strupr() -- Convert string to uppercase
;char __near * __fastcall fn_call strupr(char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, (source) offset from ds
; RETURNS:
;   AX		near pointer, offset from ds (p_str)
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strupr PROC FN_CALL USES es ds si di

	    mov si, bx		    ;ds:si = p_str
	    mov di, bx		    ;es:di = p_str
	    mov ax, ds
	    mov es, ax


@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    cmp al,'a'		    ;Check for lowercase
	    jb @F
            cmp al,'z'
	    ja @F
		sub al,20h	    ;Convert to uppercase
@@:
	    stos BYTE PTR es:[di]   ; Store char
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, bx		; return p_str
	    ret

@strupr ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strupr_sss() -- Convert string to uppercase
;char __near * fn_call strupr_sss(char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss (p_str)
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strupr_sss PROC FN_CALL C uses ds es si di, p_str:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax
	    mov ds, ax

	    mov si, [p_str]	    ;ds:si = p_str
	    mov di, [p_str]	    ;es:di = p_str

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    cmp al,'a'		    ;Check for lowercase
	    jb @F
            cmp al,'z'
	    ja @F
		sub al,20h	    ;Convert to uppercase
@@:
	    stos BYTE PTR es:[di]   ; Store char
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]	; return p_str
	    ret

strupr_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strupr_sss() -- Convert string to uppercase
;char __near * __fastcall fn_call strupr_sss(char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, (source) offset from ss
; RETURNS:
;   AX		near pointer, offset from ss (p_str)
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strupr_sss PROC FN_CALL USES es ds si di

	    mov si, bx		    ;ds:si = p_str
	    mov di, bx		    ;es:di = p_str
	    mov ax, ss
	    mov es, ax
	    mov ds, ax


@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    cmp al,'a'		    ;Check for lowercase
	    jb @F
            cmp al,'z'
	    ja @F
		sub al,20h	    ;Convert to uppercase
@@:
	    stos BYTE PTR es:[di]   ; Store char
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, bx		; return p_str
	    ret

@strupr_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
