; strncat
;   AAA=str
;   BBB=015
;   F=
;   O=
; str015.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strncat:FN_CALL PTR
p_fn_strncat P_FN_CALL strncat
EXTERNDEF C p_fn_fc_strncat:FN_CALL PTR
p_fn_fc_strncat P_FN_CALL @strncat
EXTERNDEF C p_fn_strncat_sss:FN_CALL PTR
p_fn_strncat_sss P_FN_CALL strncat_sss
EXTERNDEF C p_fn_fc_strncat_sss:FN_CALL PTR
p_fn_fc_strncat_sss P_FN_CALL @strncat_sss
EXTERNDEF C p_fn_strncat_dss:FN_CALL PTR
p_fn_strncat_dss P_FN_CALL strncat_dss
EXTERNDEF C p_fn_fc_strncat_dss:FN_CALL PTR
p_fn_fc_strncat_dss P_FN_CALL @strncat_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strncat() -- Append strings, max length
;char __near * fn_call strncat(char __near * const, const char __near * const, const int);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ds
;   num 	max number of characters to copy
;RETURNS: (char *)
;   pointer	near pointer, offset from ds (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strncat PROC FN_CALL C USES es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str2]	; ds:si = p_str2
	    mov di, [p_str1]	; es:di = p_str1
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    mov di, [p_str1]	    ;es:di = p_str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov si, [p_str2]	     ; ds:si = p_str2
	    mov cx, [num]	    ; cx = max to copy
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncat ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strncat() -- Append strings, max length
;char __near * __farcall fn_call strncat(char __near * const, const char __near * const, const int);
; __fastcall
; GIVEN:
;   BX	    p_str1, (dest) offset from ds
;   AX	    p_str2, (source) offset from ds
;   DX	    num
;RETURNS:
;   AX		near pointer, offset from ds (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strncat PROC FN_CALL USES es si di cx dx
	    mov di, bx		     ;es:di = p_str1
	    mov si, ax		     ;ds:si = p_str2
				     ;dx=num
	    mov cx, ds
	    mov es, cx

	    cmp ax, bx
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov cx, dx	    ; cx = max to copy, dx=num, bx=p_str1
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, bx	    ; return p_str1
@@exit:
	    ret
@strncat ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strncat_sss() -- Append strings, max length
;char __near * fn_call strncat_sss(char __near * const, const char __near * const, const int);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ss
;   num 	max number of characters to copy
;RETURNS: (char *)
;   pointer	near pointer, offset from ds (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strncat_sss PROC FN_CALL C USES ds es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov bx, ds
	    mov es, bx

	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str2]	; ds:si = p_str2
	    mov di, [p_str1]	; es:di = p_str1

	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    mov di, [p_str1]	    ;es:di = p_str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov si, [p_str2]	     ; ds:si = p_str2
	    mov cx, [num]	    ; cx = max to copy
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncat_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strncat_sss() -- Append strings, max length
;char __near * __farcall fn_call strncat_sss(char __near * const, const char __near * const, const int);
; __fastcall
; GIVEN:
;   BX	    p_str1, (dest) offset from ds
;   AX	    p_str2, (source) offset from ss
;   DX	    num
;RETURNS:
;   AX	    near pointer, offset from ds (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strncat_sss PROC FN_CALL USES ds es si di cx dx
	    mov di, bx		     ;es:di = p_str1
	    mov si, ax		     ;ds:si = p_str2
				     ;dx=num
	    mov cx, ds
	    mov es, cx

	    cmp bx, ax
	    jne @@cont
	    mov ax, ss
	    mov ds, ax
	    cmp ax, cx
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov cx, dx	    ; cx = max to copy, dx=num, bx=p_str1
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, bx	    ; return p_str1
@@exit:
	    ret
@strncat_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strncat_dss() -- Append strings, max length
;char __near * fn_call strncat_dss(char __near * const, const char __near * const, const int);
;GIVEN:
;   p_str1	near pointer, (dest) offset from ss
;   p_str2	near pointer, (source) offset from ds
;   num 	max number of characters to copy
;RETURNS: (char *)
;   pointer	near pointer, offset from ss (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strncat_dss PROC FN_CALL C USES es si di,
	    p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE, num:WORD

	    mov ax, ss
	    mov es, ax
	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    mov si, [p_str2]	; ds:si = p_str2
	    mov di, [p_str1]	; es/ss:di = p_str1
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    mov di, [p_str1]	    ;es:di = p_str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov si, [p_str2]	     ; ds:si = p_str2
	    mov cx, [num]	    ; cx = max to copy
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, [p_str1]
@@exit:
	    ret
strncat_dss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strncat_dss() -- Append strings, max length
;char __near * __farcall fn_call strncat_dss(char __near * const, const char __near * const, const int);
; __fastcall
; GIVEN:
;   BX	    p_str1, (dest) offset from ss
;   AX	    p_str2, (source) offset from ds
;   DX	    num
;RETURNS:
;   AX	    near pointer, offset from ss (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strncat_dss PROC FN_CALL USES es si di cx dx
	    mov di, bx		     ;es:di = p_str1
	    mov si, ax		     ;ds:si = p_str2
				     ;dx=num
	    mov cx, ss
	    mov es, cx
	    cmp bx, ax
	    jne @@cont
	    mov ax, ds
	    cmp ax, cx
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov cx, dx	    ; cx = max to copy, dx=num, bx=p_str1
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, bx	    ; return p_str1
@@exit:
	    ret
@strncat_dss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
