; strcmp
;   AAA=str
;   BBB=005
;   F=
;   O=
; str005.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strcmp:FN_CALL PTR
p_fn_strcmp P_FN_CALL strcmp
EXTERNDEF C p_fn_fc_strcmp:FN_CALL PTR
p_fn_fc_strcmp P_FN_CALL @strcmp
EXTERNDEF C p_fn_strcmp_sss:FN_CALL PTR
p_fn_strcmp_sss P_FN_CALL strcmp_sss
EXTERNDEF C p_fn_fc_strcmp_sss:FN_CALL PTR
p_fn_fc_strcmp_sss P_FN_CALL @strcmp_sss
EXTERNDEF C p_fn_strcmp_dss:FN_CALL PTR
p_fn_strcmp_dss P_FN_CALL strcmp_dss
EXTERNDEF C p_fn_fc_strcmp_dss:FN_CALL PTR
p_fn_fc_strcmp_dss P_FN_CALL @strcmp_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcmp() -- Compare strings
;int fn_call strcmp(const char __near * const, char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ds
;   p_str2	near pointer, offset from ds
; RETURNS:
;   <0	if str1 < str2
;   0	if str1 = str2 (identical)
;   >0	if str1 > str2
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strcmp PROC FN_CALL C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov di,[p_str1]	    ;es:di = destination
	    mov si,[p_str2]	    ;ds:si = source

@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    jne @@done
	    test al, al
	    jnz @@loop
	    ; equal
	    xor ax, ax
	    jmp @@exit
@@done:
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
strcmp ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcmp() -- Compare strings
;int __fastcall fn_call strcmp(const char __near * const, char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str1, (dest) offset from ds
;   AX	    p_str2, (source) offset form ds
; RETURNS:
;   AX <0	if str1 < str2
;   AX 0	if str1 = str2 (identical)
;   AX >0	if str1 > str2
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strcmp PROC FN_CALL USES es si di

	    mov di, bx	    ;es:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ds
	    mov es, ax


@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    jne @@done
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    ; str1 = str2
	    xor ax, ax		    ; equal strings
	    jmp @@exit
@@done:
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@strcmp ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcmp_sss() -- Compare strings
;int fn_call strcmp_sss(const char __near * const, char __near * const);
; GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (source) offset from ss
; RETURNS:
;   <0	if str1 < str2
;   0	if str1 = str2 (identical)
;   >0	if str1 > str2
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strcmp_sss PROC FN_CALL C USES ds es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE
	    mov bx, ds
	    mov es, bx

	    mov ax, ss
	    mov ds, ax

	    mov di,[p_str1]	    ;es:di = destination
	    mov si,[p_str2]	    ;ds:si = source

@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    jne @@done
	    test al, al
	    jnz @@loop
	    ; equal
	    xor ax, ax
	    jmp @@exit
@@done:
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
strcmp_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcmp_sss() -- Compare strings
;int __fastcall fn_call strcmp(const char __near * const, char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str1, (dest) offset from ds
;   AX	    p_str2, (source) offset form ss
; RETURNS:
;   AX <0	if str1 < str2
;   AX 0	if str1 = str2 (identical)
;   AX >0	if str1 > str2
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strcmp_sss PROC FN_CALL USES ds es si di

	    mov di, bx	    ;es:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ds
	    mov es, ax

	    mov ax, ss
	    mov ds, ax


@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    jne @@done
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    ; str1 = str2
	    xor ax, ax		    ; equal strings
	    jmp @@exit
@@done:
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@strcmp_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcmp_dss() -- Compare strings
;int fn_call strcmp_dss(const char __near * const, char __near * const);
; GIVEN:
;   p_str1	near pointer, (dest) offset from ss
;   p_str2	near pointer, (source) offset from ds
; RETURNS:
;   <0	if str1 < str2
;   0	if str1 = str2 (identical)
;   >0	if str1 > str2
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strcmp_dss PROC FN_CALL C USES ds es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE
	    mov bx, ss
	    mov es, bx

	    mov di,[p_str1]	    ;es:di = destination
	    mov si,[p_str2]	    ;ds:si = source

@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    jne @@done
	    test al, al
	    jnz @@loop
	    ; equal
	    xor ax, ax
	    jmp @@exit
@@done:
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
strcmp_dss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strcmp_dss() -- Compare strings
;int __fastcall fn_call strcmp(const char __near * const, char __near * const);
; __fastcall
;   BX	    p_str1, (dest) offset from ss
;   AX	    p_str2, (source) offset form ds
; RETURNS:
;   AX <0	if str1 < str2
;   AX 0	if str1 = str2 (identical)
;   AX >0	if str1 > str2
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strcmp_dss PROC FN_CALL USES es si di

	    mov di, bx	    ;es:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ss
	    mov es, ax

@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    jne @@done
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    ; str1 = str2
	    xor ax, ax		    ; equal strings
	    jmp @@exit
@@done:
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@strcmp_dss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
