; @strncat
;   AAA=str
;   BBB=015
;   F=1
;   O=0
; str01510.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strncat:FN_CALL PTR
p_fn_fc_strncat P_FN_CALL @strncat
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strncat() -- Append strings, max length
;char __near * __farcall fn_call strncat(char __near * const, const char __near * const, const int);
; __fastcall
; GIVEN:
;   BX	    p_str1, (dest) offset from ds
;   AX	    p_str2, (source) offset from ds
;   DX	    num
;RETURNS:
;   AX		near pointer, offset from ds (p_str1)
;NOTES:
;   always adds a terminating '\0'
;   if p_str1 == p_str2, returns p_str1
BEGIN_CODE_SEGMENT <STRING>
@strncat PROC FN_CALL USES es si di cx dx
	    mov di, bx		     ;es:di = p_str1
	    mov si, ax		     ;ds:si = p_str2
				     ;dx=num
	    mov cx, ds
	    mov es, cx

	    cmp ax, bx
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

	    ; find end of str1
	    xor ax, ax		    ;look for null
	    mov cx, ax
	    dec cx		    ;set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    mov cx, dx	    ; cx = max to copy, dx=num, bx=p_str1
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    mov ax, bx	    ; return p_str1
@@exit:
	    ret
@strncat ENDP
END_CODE_SEGMENT <STRING>
END
